/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.CachedMo;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.mim.CabinetViewerMimModel;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.MoMatchedData;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.MoRelationConsumer;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.PimcuManager;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.PimcuPort;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.TopMoRelationship;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.constraints.MoConstraint;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.dynamicproperty.DynamicProperty;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.dynamicproperty.DynamicVariables;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.dynamicproperty.DynamicVariablesImpl;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.dynamicproperty.KeysAndValues;

public abstract class MoRelationship {
    public static final int ANY_CARDINALITY = -1;
    public static final int MAX_VALUE_NOT_SET = Integer.MIN_VALUE;
    public static final String ANY_MOTYPE = "ANY_MO_TYPE";
    public static final ArrayList NO_MATCH = null;
    private static final String RAW_CARDINALITY = "rawCardinality";
    final String moType;
    private String moId;
    private Hashtable properties = new Hashtable();
    private DynamicProperty dynamicProperty;
    private DynamicVariables dynamicVariables;
    private Map<String, Object> globalProperties = new HashMap<String, Object>();
    final int maxCardinality;
    final int minCardinality;
    final CabinetViewerMimModel mimModel;
    private boolean isHidden = false;
    final ArrayList relationList = new ArrayList();
    private MoRelationship parent = null;
    final List<MoConstraint> constraints = new ArrayList<MoConstraint>();
    protected boolean failTemplateOnConstraints = false;
    protected Map<String, String> storeAttributes = new HashMap<String, String>();
    protected Map<String, String> storeAttributeAsProperty = new HashMap<String, String>();

    public MoRelationship(String string, int n, int n2, CabinetViewerMimModel cabinetViewerMimModel) {
        this.moType = string;
        this.minCardinality = n;
        this.maxCardinality = n2;
        this.mimModel = cabinetViewerMimModel;
    }

    public String getMoType() {
        return this.moType;
    }

    protected Hashtable getProperties() {
        return this.properties;
    }

    public void putProperties(Hashtable hashtable) {
        this.properties.putAll(hashtable);
    }

    public void setDynamicProperty(DynamicProperty dynamicProperty) {
        this.dynamicProperty = dynamicProperty;
    }

    protected DynamicProperty getDynamicProperty() {
        return this.dynamicProperty;
    }

    protected void setDynamicVariables(DynamicVariables dynamicVariables) {
        this.dynamicVariables = dynamicVariables;
    }

    public void setStoreAttribute(Map<String, String> map) {
        this.storeAttributes.putAll(map);
    }

    public void setStoreAttributeAsProperty(Map<String, String> map) {
        this.storeAttributeAsProperty.putAll(map);
    }

    public void storeAttributes(CachedMo cachedMo) {
        if (this.storeAttributes.size() < 1) {
            return;
        }
        Set<String> set = this.storeAttributes.keySet();
        for (String string : set) {
            Object object = null;
            try {
                cachedMo.cacheAttribute(string, null);
                object = cachedMo.getAttribute(string);
                this.putGlobalProperty(this.storeAttributes.get(string), object);
            }
            catch (Exception exception) {
                Trace.warning(this, "Unable to store attribute " + string + " on LDN " + cachedMo.getLdn(), exception);
            }
        }
    }

    public void storeAttributeAsProperty(CachedMo cachedMo) {
        if (this.storeAttributeAsProperty.size() < 1) {
            return;
        }
        Set<String> set = this.storeAttributeAsProperty.keySet();
        for (String string : set) {
            Object object = null;
            try {
                cachedMo.cacheAttribute(string, null);
                object = cachedMo.getAttribute(string);
                this.putGlobalProperty(this.storeAttributeAsProperty.get(string), object);
            }
            catch (Exception exception) {
                Trace.warning(this, "Unable to store attribute " + string + " on LDN " + cachedMo.getLdn(), exception);
            }
        }
    }

    public void putGlobalProperty(String string, Object object) {
        if (this instanceof TopMoRelationship) {
            this.putGlobalPropertyContinued(string, object);
        } else {
            MoRelationship moRelationship = this.parent;
            while (moRelationship != null && !(moRelationship instanceof TopMoRelationship)) {
                moRelationship = moRelationship.parent;
            }
            moRelationship.putGlobalPropertyContinued(string, object);
        }
    }

    private void putGlobalPropertyContinued(String string, Object object) {
        this.globalProperties.put(string, object);
        for (MoRelationship moRelationship : this.relationList) {
            moRelationship.putGlobalPropertyContinued(string, object);
        }
    }

    public void clearGlobalProperties() {
        if (this instanceof TopMoRelationship) {
            this.clearGlobalPropertyContinued();
        } else {
            MoRelationship moRelationship = this.parent;
            while (moRelationship != null && !(moRelationship instanceof TopMoRelationship)) {
                moRelationship = moRelationship.parent;
            }
            moRelationship.clearGlobalPropertyContinued();
        }
    }

    private void clearGlobalPropertyContinued() {
        this.globalProperties = new HashMap<String, Object>();
        for (MoRelationship moRelationship : this.relationList) {
            moRelationship.clearGlobalPropertyContinued();
        }
    }

    public Object getGlobalProperty(String string) {
        return this.globalProperties.get(string);
    }

    public boolean hasGlobalProperty(String string) {
        return this.globalProperties.containsKey(string);
    }

    public void putProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public void putProperty(String string) {
        this.properties.put(string, string);
    }

    public boolean hasProperty(String string) {
        return this.properties.containsKey(string);
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public void setProperties(Hashtable hashtable) {
        this.properties = hashtable;
    }

    public void addConstraint(MoConstraint moConstraint) {
        this.constraints.add(moConstraint);
    }

    public void setMoIdentity(String string) {
        this.moId = string;
    }

    public String getMoIdentity() {
        return this.moId;
    }

    public int getMinCardinality() {
        return this.minCardinality;
    }

    public int getMaxCardinality() {
        return this.maxCardinality;
    }

    public CabinetViewerMimModel getMimModel() {
        return this.mimModel;
    }

    public void setHidden(boolean bl) {
        this.isHidden = bl;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public MoRelationship addRelationship(MoRelationship moRelationship) {
        this.relationList.add(moRelationship);
        moRelationship.setParent(this);
        return moRelationship;
    }

    public ArrayList getRelationships() {
        return this.relationList;
    }

    protected void setParent(MoRelationship moRelationship) {
        this.parent = moRelationship;
    }

    public MoRelationship getParent() {
        return this.parent;
    }

    private boolean isCardinalityMatching(List list, MoRelationConsumer moRelationConsumer) {
        int n = list.size();
        int n2 = this.getMinCardinality();
        int n3 = this.getMaxCardinality();
        if (n2 != -1 && n < n2) {
            if (moRelationConsumer != null) {
                moRelationConsumer.mismatch("Minimum cardinality mismatched: found " + n + ", expected  " + n2);
            }
            return false;
        }
        if (n3 != -1 && n3 != Integer.MIN_VALUE && n > n3) {
            if (moRelationConsumer != null) {
                moRelationConsumer.mismatch("Maximum cardinality mismatched: found " + n + ", expected  " + n3);
            }
            return false;
        }
        return true;
    }

    protected List filterMos(List list) {
        this.properties.put(RAW_CARDINALITY, list.size());
        if (this.moType == null && this.moId == null) {
            return list;
        }
        if (this.moType.equals(ANY_MOTYPE)) {
            return list;
        }
        ArrayList<CachedMo> arrayList = new ArrayList<CachedMo>();
        for (CachedMo cachedMo : list) {
            boolean bl = true;
            if (this.moType != null && !this.moType.equals(cachedMo.getMoType())) {
                bl = false;
            }
            if (this.moId != null) {
                bl = this.moId.endsWith("*") && cachedMo.getName().toUpperCase().startsWith(this.moId.substring(0, this.moId.indexOf("*"))) ? true : (this.moId.startsWith("*") && cachedMo.getName().toUpperCase().endsWith(this.moId.substring(1)) ? true : this.moId.equalsIgnoreCase(cachedMo.getName()));
            }
            for (MoConstraint moConstraint : this.constraints) {
                if (moConstraint.check(cachedMo)) continue;
                this.failTemplateOnConstraints = moConstraint.failTemplateOnConstraints();
                bl = false;
            }
            if (!bl) continue;
            arrayList.add(cachedMo);
        }
        return arrayList;
    }

    protected boolean matchToRelationship(CachedMo cachedMo, MoRelationConsumer moRelationConsumer) {
        moRelationConsumer.beginRelationship(this);
        boolean bl = this.doMatching(cachedMo, moRelationConsumer);
        moRelationConsumer.endRelationship(this);
        return bl;
    }

    protected boolean matchToSubRelationships(List list, MoRelationConsumer moRelationConsumer) {
        int n = 0;
        ArrayList arrayList = this.getRelationships();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object;
            CachedMo cachedMo;
            Iterator iterator2;
            Object object2;
            Object object32;
            int n2 = 0;
            CachedMo cachedMo2 = (CachedMo)iterator.next();
            this.storeAttributeAsProperty(cachedMo2);
            if (moRelationConsumer.isMoConsumed(cachedMo2) && this.properties.containsKey("KEY_UNIQUE")) continue;
            if (this.properties.containsKey("KEY_ONE_TO_ONE_L")) {
                boolean bl = false;
                if (cachedMo2.getName().contains("BB_")) {
                    object32 = cachedMo2.getParent();
                    object2 = object32.getChildren(this.moType);
                    iterator2 = object2.iterator();
                    while (iterator2.hasNext()) {
                        cachedMo = (CachedMo)iterator2.next();
                        if (cachedMo.getName() == null || cachedMo.getName().length() <= 0 || !cachedMo.getName().contains("RU_") || !moRelationConsumer.isMoConsumed(cachedMo)) continue;
                        object = cachedMo2.getName().substring(cachedMo2.getName().length() - 1);
                        boolean bl2 = cachedMo.getName().endsWith((String)object);
                        if (!bl2) continue;
                        bl = true;
                    }
                }
                if (!bl) {
                    continue;
                }
            } else if (this.properties.containsKey("KEY_ONE_TO_ONE_W")) {
                boolean bl = false;
                object32 = cachedMo2.getAttribute("objectAConnector");
                object2 = cachedMo2.getAttribute("objectBConnector");
                iterator2 = object32 != null ? PimcuPort.valueOf((Integer)object32) : null;
                Object object4 = cachedMo = object2 != null ? PimcuPort.valueOf((Integer)object2) : null;
                if ((iterator2 != null || cachedMo != null) && (object = cachedMo2.getReferenced("connectedToObjectARef")) != null && ((CachedMo[])object).length > 0) {
                    String string = object[0].getMoType();
                    PimcuManager pimcuManager = PimcuManager.getInstance();
                    if (pimcuManager.compareToRUPortOfPimcu((PimcuPort)((Object)iterator2)) && string.equals("AuxPlugInUnit")) {
                        pimcuManager.addRUPortOfPimcu((PimcuPort)((Object)iterator2));
                    } else if (pimcuManager.compareToBBPortOfPimcu((PimcuPort)((Object)cachedMo)) && string.equals("PlugInUnit") && !(bl = pimcuManager.isExistRefRU((PimcuPort)((Object)cachedMo)))) continue;
                }
            }
            moRelationConsumer.beginMo(cachedMo2);
            for (Object object32 : arrayList) {
                ((MoRelationship)object32).setDynamicVariables(this.dynamicVariables);
                boolean bl = ((MoRelationship)object32).matchToRelationship(cachedMo2, moRelationConsumer);
                if (!bl) {
                    if (this.maxCardinality == Integer.MIN_VALUE) continue;
                    moRelationConsumer.endMo(cachedMo2);
                    return false;
                }
                ++n2;
            }
            moRelationConsumer.endMo(cachedMo2);
            if (arrayList.size() == n2) {
                ++n;
            }
            if (this.maxCardinality != Integer.MIN_VALUE || n < this.minCardinality || iterator.hasNext()) continue;
            moRelationConsumer.clearMismatchFlag();
            return true;
        }
        if (this.maxCardinality == Integer.MIN_VALUE && n >= this.minCardinality) {
            return true;
        }
        return this.maxCardinality != Integer.MIN_VALUE && n == list.size();
    }

    protected boolean matchToParentRelationships(CachedMo cachedMo, MoRelationConsumer moRelationConsumer) {
        ArrayList arrayList = this.getRelationships();
        Object object = this.getProperty("KEY_INCLUDE_PARENT_MO");
        if (object == null) {
            return true;
        }
        this.storeAttributeAsProperty(cachedMo);
        moRelationConsumer.beginMo(cachedMo);
        for (MoRelationship moRelationship : arrayList) {
            moRelationship.setDynamicVariables(this.dynamicVariables);
            boolean bl = moRelationship.matchToRelationship(cachedMo, moRelationConsumer);
            if (bl) continue;
            return false;
        }
        moRelationConsumer.endMo(cachedMo);
        return true;
    }

    protected abstract boolean doMatching(CachedMo var1, MoRelationConsumer var2);

    public boolean checkRules(List list, MoRelationConsumer moRelationConsumer) {
        boolean bl = this.isCardinalityMatching(list, moRelationConsumer);
        return bl;
    }

    public MoMatchedData getMoMatchedData(CachedMo cachedMo) {
        MoListHelper moListHelper = new MoListHelper();
        this.dynamicVariables = new DynamicVariablesImpl();
        moListHelper.findMos(this, cachedMo);
        ArrayList<CachedMo> arrayList = new ArrayList<CachedMo>();
        List<CachedMo> list = moListHelper.getContainedMos();
        Hashtable<CachedMo, Hashtable<String, Object>> hashtable = moListHelper.getMoToProperties();
        Hashtable<String, Hashtable<CachedMo, Object>> hashtable2 = moListHelper.getPropertiesToMoAndValue();
        if (list != NO_MATCH) {
            for (CachedMo cachedMo2 : list) {
                Hashtable<String, Object> hashtable3;
                if (cachedMo2 == null || (hashtable3 = hashtable.get(cachedMo2)) != null && hashtable3.contains("KEY_REMOVE")) continue;
                boolean bl = false;
                for (CachedMo cachedMo3 : arrayList) {
                    if (!cachedMo2.getLdn().equals(cachedMo3.getLdn())) continue;
                    bl = true;
                }
                if (bl) continue;
                arrayList.add(cachedMo2);
            }
        }
        MoMatchedData moMatchedData = new MoMatchedData(arrayList, hashtable2, hashtable, this.cloneGlobalProperties());
        return moMatchedData;
    }

    private Map<String, Object> cloneGlobalProperties() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Set<String> set = this.globalProperties.keySet();
        for (String string : set) {
            Object object = this.globalProperties.get(string);
            hashMap.put(string, object);
        }
        return hashMap;
    }

    public String toString() {
        return super.toString() + "(" + this.moType + this.moId + ")";
    }

    class MoListHelper
    implements MoRelationConsumer {
        static final String INDENT = "    ";
        private int indentLevel = 0;
        private List<CachedMo> containedMoList = new ArrayList<CachedMo>();
        private boolean isMismatched = false;
        static final boolean isDebug = false;
        final Stack relStack = new Stack();
        private MoRelationship currentRelationship;
        final Hashtable<String, Hashtable<CachedMo, Object>> propertyToMoAndValue = new Hashtable();
        final Hashtable<CachedMo, Hashtable<String, Object>> moToProperty = new Hashtable();

        MoListHelper() {
        }

        public void findMos(MoRelationship moRelationship, CachedMo cachedMo) {
            boolean bl = moRelationship.matchToRelationship(cachedMo, this);
            if (!bl || this.isMismatched) {
                this.containedMoList = NO_MATCH;
            }
        }

        public List<CachedMo> getContainedMos() {
            if (this.isMismatched) {
                this.containedMoList = NO_MATCH;
            }
            return this.containedMoList;
        }

        public Hashtable<String, Hashtable<CachedMo, Object>> getPropertiesToMoAndValue() {
            return this.propertyToMoAndValue;
        }

        public Hashtable<CachedMo, Hashtable<String, Object>> getMoToProperties() {
            return this.moToProperty;
        }

        public Hashtable<String, Object> getProperties(CachedMo cachedMo) {
            return this.moToProperty.get(cachedMo);
        }

        @Override
        public void beginRelationship(MoRelationship moRelationship) {
            if (this.currentRelationship != null) {
                this.relStack.push(this.currentRelationship);
            }
            this.currentRelationship = moRelationship;
        }

        @Override
        public boolean isMoConsumed(CachedMo cachedMo) {
            return this.containedMoList.contains(cachedMo);
        }

        @Override
        public void beginMo(CachedMo cachedMo) {
            boolean bl = this.currentRelationship.isHidden();
            if (!bl) {
                this.containedMoList.add(cachedMo);
                this.addAllProperties(this.currentRelationship, cachedMo);
            }
            this.executeDynamicProperties(this.currentRelationship, cachedMo);
        }

        @Override
        public void endMo(CachedMo cachedMo) {
        }

        @Override
        public void endRelationship(MoRelationship moRelationship) {
            if (!this.relStack.isEmpty()) {
                this.currentRelationship = (MoRelationship)this.relStack.pop();
            }
        }

        @Override
        public void mismatch(String string) {
            this.isMismatched = true;
        }

        @Override
        public int getSizeOfCurrentMatchedElements() {
            return this.containedMoList.size();
        }

        @Override
        public void clearMismatchFlag() {
            this.isMismatched = false;
        }

        @Override
        public void setSizeOfMatchedElements(int n) {
            if (n > 0 && n < this.containedMoList.size()) {
                int n2;
                for (int i = n2 = this.containedMoList.size(); i > n; --i) {
                    this.containedMoList.remove(i - 1);
                }
            }
        }

        private void executeDynamicProperties(MoRelationship moRelationship, CachedMo cachedMo) {
            DynamicProperty dynamicProperty = moRelationship.getDynamicProperty();
            DynamicVariables dynamicVariables = moRelationship.dynamicVariables;
            if (dynamicProperty == null) {
                return;
            }
            dynamicProperty.execute(dynamicVariables);
            KeysAndValues keysAndValues = dynamicProperty.getCopyOfKeysAndValues();
            Set<String> set = keysAndValues.keySet();
            for (String string : set) {
                List<String> list = keysAndValues.get(string);
                this.addProperty(string, cachedMo, list);
                this.addToMoToProperty(cachedMo, string, list);
            }
        }

        private void addAllProperties(MoRelationship moRelationship, CachedMo cachedMo) {
            Hashtable hashtable = moRelationship.properties;
            Set set = hashtable.keySet();
            for (String string : set) {
                Object v = hashtable.get(string);
                this.addProperty(string, cachedMo, v);
                this.addToMoToProperty(cachedMo, string, v);
            }
        }

        private void addToMoToProperty(CachedMo cachedMo, String string, Object object) {
            Hashtable<Object, Object> hashtable;
            if (this.moToProperty.containsKey(cachedMo)) {
                hashtable = this.moToProperty.get(cachedMo);
            } else {
                hashtable = new Hashtable();
                this.moToProperty.put(cachedMo, hashtable);
            }
            hashtable.put(string, object);
        }

        private void addProperty(String string, CachedMo cachedMo, Object object) {
            Hashtable<Object, Object> hashtable;
            if (this.propertyToMoAndValue.containsKey(string)) {
                hashtable = this.propertyToMoAndValue.get(string);
            } else {
                hashtable = new Hashtable();
                this.propertyToMoAndValue.put(string, hashtable);
            }
            hashtable.put(cachedMo, object);
        }

        private String getIndent() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("MODEL;");
            for (int i = 0; i < this.indentLevel; ++i) {
                stringBuffer.append(INDENT);
            }
            return stringBuffer.toString();
        }
    }
}

