/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.loader;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;

public class VimModelValidator {
    public static final int OK = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final int FATAL_ERROR = 3;
    public static final int SCHEMA_FILE_MISSING = 4;
    private SchemaFactory schemaFactory;
    private Hashtable schemas = new Hashtable();

    public VimModelValidator() {
        this.schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    }

    public void addSchemaFile(String string, URL uRL) throws SAXException {
        if (uRL == null) {
            return;
        }
        Schema schema = this.schemaFactory.newSchema(uRL);
        this.schemas.put(string, schema);
    }

    private String adjustPathInFileName(String string) {
        String string2;
        int n = string.indexOf(".." + File.separator);
        if (n == -1) {
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if ("..".equals(string2)) {
                int n2 = stringBuffer.toString().lastIndexOf(File.separator);
                String string3 = stringBuffer.substring(0, n2);
                stringBuffer = new StringBuffer(string3);
                continue;
            }
            stringBuffer.append(File.separator + string2);
        }
        string2 = stringBuffer.toString();
        if (string2.startsWith(File.separator)) {
            string2 = string2.substring(1, string2.length());
        }
        return string2;
    }

    public int validateFile(String string, String string2, Document document) throws IOException, SAXException {
        String string3 = this.adjustPathInFileName(string2);
        Object v = this.schemas.get(string3);
        if (v == null) {
            Trace.warning(this, "Can't find schema file when validating file \"" + string + "\" using schema: \"" + string3 + "\". ");
            return 4;
        }
        Schema schema = (Schema)v;
        Validator validator = schema.newValidator();
        TestErrorHandler testErrorHandler = new TestErrorHandler(string, string3);
        validator.setErrorHandler(testErrorHandler);
        validator.validate(new DOMSource(document));
        int n = testErrorHandler.getErrorResult();
        return n;
    }

    private class TestErrorHandler
    implements ErrorHandler {
        private String xmlFileName;
        private String schemaFile;
        private int errorResult = 0;

        protected TestErrorHandler(String string, String string2) {
            this.xmlFileName = string;
            this.schemaFile = string2;
        }

        public int getErrorResult() {
            return this.errorResult;
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.errorResult = 1;
            Trace.warning(this, "Warning when validating file \"" + this.xmlFileName + "\" using schema: \"" + this.schemaFile + "\". " + sAXParseException);
            throw sAXParseException;
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            this.errorResult = 2;
            Trace.error(this, "Error when validating file \"" + this.xmlFileName + "\" using schema: \"" + this.schemaFile + "\". " + sAXParseException);
            throw sAXParseException;
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.errorResult = 3;
            Trace.error(this, "Fatal Error when validating file \"" + this.xmlFileName + "\" using schema: \"" + this.schemaFile + "\". " + sAXParseException);
            throw sAXParseException;
        }
    }
}

