/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.rbs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.SubrackLayout;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.ModelException;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.rbs.RbsAbstractTemplate;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.rbs.RbsSlotInSubrackLayout;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.util.Helper;

public class RbsSubRackLayout
extends RbsAbstractTemplate {
    private Collection slots = new ArrayList();
    private boolean slotOrder = false;

    public RbsSubRackLayout(Hashtable hashtable, Node node) {
        super(hashtable, node);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equals("slot")) {
                this.slots.add(new RbsSlotInSubrackLayout(this.getParams(), node2));
                continue;
            }
            if (!string.equals("slotOrder")) continue;
            this.slotOrder = true;
            this.slots = Helper.getValuesFromNode(this.getParams(), node2, "slot");
        }
    }

    protected SubrackLayout getSubrackLayout() {
        if (this.slotOrder) {
            int[] nArray = new int[this.slots.size()];
            int n = 0;
            for (Object e : this.slots) {
                if (!(e instanceof String)) continue;
                String string = (String)e;
                int n2 = 0;
                try {
                    n2 = Integer.parseInt(string);
                    nArray[n++] = n2;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ModelException("The child element slot to element slotOrder contains \"" + string + "\" instead of an Integer.", numberFormatException);
                }
            }
            return new SubrackLayout(nArray);
        }
        SubrackLayout subrackLayout = new SubrackLayout();
        for (Object e : this.slots) {
            if (!(e instanceof RbsSlotInSubrackLayout)) continue;
            RbsSlotInSubrackLayout rbsSlotInSubrackLayout = (RbsSlotInSubrackLayout)e;
            int n = 0;
            int n3 = 0;
            try {
                n = rbsSlotInSubrackLayout.getSlot();
            }
            catch (NullPointerException nullPointerException) {
                throw new ModelException("The child element slot to element subrackLayout does NOT exist in rbsTemplate.", nullPointerException);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ModelException("The child element slot to element subrackLayout contains \"" + rbsSlotInSubrackLayout.getSlot() + "\" instead of an Integer.", numberFormatException);
            }
            try {
                n3 = rbsSlotInSubrackLayout.getWidth();
            }
            catch (NullPointerException nullPointerException) {
                throw new ModelException("The child element width to element slot does NOT exist in rbsTemplate.", nullPointerException);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ModelException("The child element width to element slot contains \"" + rbsSlotInSubrackLayout.getSlot() + "\" instead of an Integer.", numberFormatException);
            }
            subrackLayout.setSlotWidth(n, n3);
        }
        return subrackLayout;
    }
}

