/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pmreporter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.moframework.csnotifications.CSNotificationSubscriber;
import se.ericsson.cello.moframework.csnotifications.CSNotificationSubscriberMgr;
import se.ericsson.cello.moframework.csnotifications.CSNotificationSubscriberMgrFactory;
import se.ericsson.cello.moframework.csnotifications.MibPrefixChangedSubscriber;
import se.ericsson.cello.moframework.csnotifications.NameValue;
import se.ericsson.cello.moframework.csnotifications.SubscriptionFilter;
import se.ericsson.cello.moframework.csnotifications.TopologyAndAVCSubscriber;
import se.ericsson.cello.pmreporter.PmReporterAdmin;
import se.ericsson.cello.pmreporter.proxy.PmReporterProxy;
import se.ericsson.cello.pms.generic.PmAttributeSettingListener;
import se.ericsson.cello.pms.generic.PmAttributeSettingListenerMgr;
import se.ericsson.cello.pms.generic.PmReporterPushXmlHandler;
import se.ericsson.cello.pms.generic.PmReporterPushXmlMgr;
import se.ericsson.cello.pms.generic.PmReporterRecoveryHandler;
import se.ericsson.cello.pms.ne.NEInfoSupplier;
import se.ericsson.cello.pms.ne.NESupplier;
import se.ericsson.cello.support.debug.MessageLog;

public class PmReporter
implements PmReporterPushXmlHandler,
PmReporterAdmin,
PmAttributeSettingListener,
MibPrefixChangedSubscriber,
TopologyAndAVCSubscriber,
PmReporterRecoveryHandler {
    private static PmReporter instance;
    private PmReporterProxy proxy = PmReporterProxy.getInstance();
    private String mibPrefix = "";
    private String softwareVersion = "";
    private String userName = "";
    private String performanceDataPath = "";
    private int maxNoOfPmFiles;
    private List myRecoveryHandlers;

    private PmReporter() {
        PmAttributeSettingListenerMgr.getInstance().registerListener((PmAttributeSettingListener)this);
        CSNotificationSubscriberMgr cSNotificationSubscriberMgr = CSNotificationSubscriberMgrFactory.createCSNotificationSubscriberMgr();
        SubscriptionFilter subscriptionFilter = new SubscriptionFilter();
        String[] stringArray = new String[]{"ManagedElement"};
        subscriptionFilter.setMoTypes(stringArray);
        cSNotificationSubscriberMgr.register((TopologyAndAVCSubscriber)this, subscriptionFilter);
        cSNotificationSubscriberMgr.register((CSNotificationSubscriber)this);
        PmReporterPushXmlMgr.getInstance().registerHandler((PmReporterPushXmlHandler)this);
        this.mibPrefix = "";
        this.softwareVersion = "";
        this.userName = "";
        this.performanceDataPath = "";
        this.maxNoOfPmFiles = 0;
        this.proxy.registerRecoveryHandler(this);
        this.myRecoveryHandlers = new ArrayList();
    }

    public static PmReporter getInstance() {
        if (instance == null) {
            instance = new PmReporter();
        }
        return instance;
    }

    public void performPmrRecovery() {
        MessageLog.info((String)"Requested to perform recovery for the Pm Reporter");
        Iterator iterator = this.myRecoveryHandlers.iterator();
        while (iterator.hasNext()) {
            PmReporterRecoveryHandler pmReporterRecoveryHandler = (PmReporterRecoveryHandler)iterator.next();
            if (pmReporterRecoveryHandler == null) continue;
            pmReporterRecoveryHandler.performPmrRecovery();
        }
    }

    public void collectData() {
        this.mibPrefix = MibMgr.instance().getMib().getMibPrefix();
        NEInfoSupplier nEInfoSupplier = NESupplier.instance().getNE();
        if (nEInfoSupplier != null) {
            this.softwareVersion = nEInfoSupplier.getSoftwareVersion();
            this.userName = nEInfoSupplier.getUserName();
        }
        this.proxy.setMibPrefix(this.mibPrefix);
        this.proxy.setNESoftwareVersion(this.softwareVersion);
        this.proxy.setNeUserName(this.userName);
    }

    public void registerCounterNames(int n, int n2, int[] nArray, String[] stringArray) {
        if (nArray.length != stringArray.length) {
            MessageLog.info((String)"List of tags and list of counter names have different lengths");
            return;
        }
        this.proxy.updateCounterNames(0, n, n2, nArray, stringArray);
    }

    public void deregisterCounterNames(int n, int n2, int[] nArray, String[] stringArray) {
        if (nArray.length != stringArray.length) {
            MessageLog.info((String)"List of tags and list of counter names have different lengths");
            return;
        }
        this.proxy.updateCounterNames(1, n, n2, nArray, stringArray);
    }

    public void registerPdfCounters(int n, int n2, PmReporterAdmin.PdfIndexInfo[] pdfIndexInfoArray) {
        this.proxy.sendOmsPmReporterRegisterPdfCountersReq(n, n2, pdfIndexInfoArray);
    }

    public void registerLdns(int n, int n2, int[] nArray, String[] stringArray) {
        if (nArray.length != stringArray.length) {
            MessageLog.info((String)"List of froIds and list of ldns have different lengths");
            return;
        }
        this.proxy.updateLdns(0, n, n2, nArray, stringArray);
    }

    public void deregisterLdns(int n, int n2, int[] nArray, String[] stringArray) {
        if (nArray.length != stringArray.length) {
            MessageLog.info((String)"List of froIds and list of ldns have different lengths");
            return;
        }
        this.proxy.updateLdns(1, n, n2, nArray, stringArray);
    }

    public void registerPmReporterRecoveryHandler(PmReporterRecoveryHandler pmReporterRecoveryHandler) {
        if (!this.myRecoveryHandlers.contains(pmReporterRecoveryHandler)) {
            this.myRecoveryHandlers.add(pmReporterRecoveryHandler);
        }
    }

    public void maxNoOfPmFilesChanged(int n) {
        if (this.maxNoOfPmFiles != n) {
            this.maxNoOfPmFiles = n;
            this.proxy.setMaxNoOfFiles(n);
        }
    }

    public void performanceDataPathChanged(String string) {
        if (!this.performanceDataPath.equals(string)) {
            this.performanceDataPath = string;
            this.proxy.setFilePath(string);
        }
    }

    public void pushXml(int n, String string) {
        if (string.length() > 60000) {
            MessageLog.info(this.getClass(), (String)("Length of specified XML string, " + string.length() + ", exeeds allowed max size " + 60000 + ". Data shall be pushed in chunks"));
            int n2 = string.length() / 60000 + 1;
            String[] stringArray = new String[n2];
            int n3 = 0;
            int n4 = 0;
            while (n3 < string.length()) {
                stringArray[n4] = string.substring(n3, Math.min(string.length(), n3 + 60000));
                n3 += 60000;
                ++n4;
            }
            for (n3 = 0; n3 < n2; ++n3) {
                this.proxy.pushXML(n, stringArray[n3]);
            }
        } else {
            this.proxy.pushXML(n, string);
        }
    }

    public void mibPrefixValueChanged(String string) {
        if (!this.mibPrefix.equals(string)) {
            this.mibPrefix = string;
            this.proxy.setMibPrefix(string);
        }
    }

    public void moChanged(String string, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2;
            NameValue nameValue = (NameValue)iterator.next();
            MessageLog.info((String)("nameValue: " + nameValue.getName()));
            if (!nameValue.getName().equals("LogicalName") || (string2 = (String)nameValue.getValue()).equals(this.userName)) continue;
            this.userName = string2;
            this.proxy.setNeUserName(string2);
        }
    }

    public void moCreated(String string) {
    }

    public void moDeleted(String string) {
    }

    public void queueOverflow() {
    }
}

