/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.aue;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorMo;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.BoamSubAueBase;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.common.FindMo;
import se.ericsson.wcdma.rbs.boam.upfwk.common.TransactionWrapper;

public abstract class AbstractConfigureSectorAue
extends BoamSubAueBase {
    public static final String SECTOR = "Sector";
    private static final int INITIALIZE = 100;
    private static final int UNINITIALIZE = 101;
    private static final long PAUSE = 1000L;

    public AbstractConfigureSectorAue(Class subClazz) {
        super(subClazz);
    }

    protected void triggerFinish(List commands) throws Exception {
        this.traceEnter("triggerFinish(), causing execution");
        commands.add(CommandHandler.createAueCommand(this, 1));
    }

    protected boolean execute(TransactionWrapper tw) throws Exception {
        this.traceEnter("execute()");
        try {
            if (this.couldExecute(tw.getCoordinator())) {
                HashMap sectorDataMap = new HashMap();
                this.executeInTransaction(tw, 101, sectorDataMap);
                this.sleep(1000L);
                this.executeInTransaction(new TransactionWrapper(), 100, sectorDataMap);
            }
            return true;
        }
        catch (Exception e) {
            this.traceError("caught exception: " + e, e);
            return false;
        }
    }

    public abstract boolean couldExecute(Coordinator var1);

    public abstract int getMaximumAttempts();

    private void executeInTransaction(TransactionWrapper tx, int mode, Map sectorDataMap) {
        try {
            Coordinator context = tx.getCoordinator();
            int failures = 0;
            int count = 0;
            while (true) {
                if (count > 0 && count < this.getMaximumAttempts()) {
                    this.trace("there were " + failures + " failures; retrying, loop count: " + count);
                } else if (count == this.getMaximumAttempts()) {
                    this.traceError("failed to " + AbstractConfigureSectorAue.modeToString(mode) + " some Sector MOs after " + this.getMaximumAttempts() + " attempts");
                    break;
                }
                failures = 0;
                MoIterator moit = FindMo.findMOs(SECTOR);
                while (moit.hasMoreElements()) {
                    SectorMo smo = (SectorMo)moit.nextMo();
                    String smoName = smo.getFullDistinguishedName();
                    switch (mode) {
                        case 101: {
                            if (!smo.isSectorInitialized(context)) {
                                this.trace("not initialized, no action for: " + smoName);
                                break;
                            }
                            sectorDataMap.put(smoName, new SectorData(smo.getNumberOfTxBranches(context), smo.getBand(context)));
                            try {
                                smo.actionUnInitSector(context);
                                this.trace("successfully uninitialized: " + smoName);
                            }
                            catch (Exception e) {
                                this.traceError("failed to uninitialize: " + smoName + ", caught exception", e);
                                ++failures;
                            }
                            break;
                        }
                        case 100: {
                            if (smo.isSectorInitialized(context)) {
                                this.trace("already initialized, no action for: " + smoName);
                                break;
                            }
                            SectorData sectorData = (SectorData)sectorDataMap.get(smoName);
                            if (sectorData == null) {
                                this.trace("leaving as uninitalized: " + smoName);
                                break;
                            }
                            try {
                                smo.actionInitSector(sectorData.ntxb, sectorData.band, context);
                                this.trace("successfully reinitialized: " + smoName);
                                break;
                            }
                            catch (Exception e) {
                                this.traceError("failed to initialize: " + smoName + ", caught exception", e);
                                ++failures;
                            }
                        }
                    }
                }
                if (failures == 0) {
                    this.trace("all " + AbstractConfigureSectorAue.modeToString(mode) + " operations successful");
                    break;
                }
                this.sleep(1000L);
                ++count;
            }
            tx.commit();
        }
        catch (Throwable t) {
            try {
                this.traceError("mode: " + AbstractConfigureSectorAue.modeToString(mode) + ", rollback due to: ", t);
                tx.rollback();
            }
            catch (Throwable t1) {
                this.traceError("rollback failed, caught: ", t1);
            }
        }
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            this.trace("unexpectedly interrupted sleep");
        }
    }

    private static String modeToString(int mode) {
        switch (mode) {
            case 101: {
                return "UNINITIALIZE";
            }
            case 100: {
                return "INITIALIZE";
            }
        }
        return "UNKNOWN MODE";
    }

    private static final class SectorData {
        private final int ntxb;
        private final int band;

        private SectorData(int ntxb, int band) {
            this.ntxb = ntxb;
            this.band = band;
        }
    }
}

