/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.aue;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.swmanagement.PiuTypeMo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.auxpiu.AuxPlugInUnitUpgradeHelper;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.BoamSubAueBase;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.common.TransactionWrapper;

public final class FixPiuTypeMatchAue
extends BoamSubAueBase {
    private static boolean isRbsInit = false;
    private static ArrayList auxLst = new ArrayList();
    private static final int LOW_VERSION = 13030800;
    private static final int HIGH_VERSION = 13101900;
    private static final FixPiuTypeMatchAue INSTANCE = new FixPiuTypeMatchAue();

    private FixPiuTypeMatchAue() {
        super(FixPiuTypeMatchAue.class);
    }

    public static FixPiuTypeMatchAue instance() {
        return INSTANCE;
    }

    protected void triggerRbsInitiate(List commands) throws Exception {
        this.traceEnter("triggerRbsInitiate()");
        isRbsInit = true;
        commands.add(CommandHandler.createAueCommand(this, 1));
    }

    protected void triggerPreload(List commands) throws Exception {
        MessageLog.traceEnter(this.getClass(), (String)"triggerPreload()");
        isRbsInit = false;
        commands.add(CommandHandler.createAueCommand(this, 1));
    }

    protected boolean execute(TransactionWrapper tw) throws Exception {
        this.traceEnter("execute()");
        boolean result = false;
        result = isRbsInit ? this.executeRbsInit(tw) : this.executePreload(tw);
        return result;
    }

    private boolean executeRbsInit(TransactionWrapper tw) throws MoAccessException {
        this.traceEnter("executeRbsInit() <---");
        Coordinator c = tw.getCoordinator();
        MoIterator moIter = BoamHelper.findMOs((String)"AuxPlugInUnit");
        while (moIter.hasMoreElements()) {
            AuxPlugInUnitMo aux = (AuxPlugInUnitMo)moIter.nextMo();
            PiuTypeMo piu = (PiuTypeMo)aux.getPiuType(c);
            if (!AuxPlugInUnitUpgradeHelper.isGenericPiuType((PiuTypeMo)piu, (Coordinator)c)) continue;
            this.trace("Aux=" + aux.getLocalDistinguishedName() + " wih  generic piuType" + "<---");
            if (0 == aux.getAdministrativeState(c) || !this.shouldGenericPIULock(aux, c)) continue;
            aux.setAdministrativeState(0, c);
            auxLst.add(aux);
            this.trace("Aux=" + aux.getLocalDistinguishedName() + " is Locked" + "<---");
        }
        return true;
    }

    private boolean shouldGenericPIULock(AuxPlugInUnitMo aux, Coordinator c) {
        boolean shouldLock = false;
        try {
            String boardPNum = aux.getProductNumber(c);
            String boardPRev = aux.getProductRevision(c);
            ManagedObject newpiu = AuxPlugInUnitUpgradeHelper.fetchNewPiuType((ManagedObject)aux, (String)boardPNum, (String)boardPRev, (Coordinator)c);
            if (newpiu == null) {
                shouldLock = true;
                MessageLog.info(this.getClass(), (String)("aux = " + aux.getLocalDistinguishedName() + " is a generic PIU and no newPIU, Need to be locked" + "<---"));
            }
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), (String)"Meet problem when get new Piu for a generic piuType.<---");
            e.printStackTrace();
        }
        return shouldLock;
    }

    private boolean executePreload(TransactionWrapper tw) throws MoAccessException {
        this.traceEnter("executePreload() <---");
        Iterator it = auxLst.iterator();
        while (it.hasNext()) {
            AuxPlugInUnitMo aux = (AuxPlugInUnitMo)it.next();
            aux.setAdministrativeState(1, tw.getCoordinator());
            this.trace("Unlocd Aux=" + aux.getLocalDistinguishedName());
        }
        auxLst.clear();
        return true;
    }

    public String getDciReference() {
        return "14/109 26-CRH 109 0239-1";
    }

    public int getHighVersion() {
        return 13101900;
    }

    public int getLowVersion() {
        return 13030800;
    }
}

