/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.aue;

import java.util.List;
import se.ericsson.cello.equipment.SlotMo;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.sync.GpsSyncRefMo;
import se.ericsson.cello.sync.SynchronizationMo;
import se.ericsson.cello.sync.TimingUnitMo;
import se.ericsson.cello.sync.TuSyncRefMo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.NodeBFunctionMo;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.BoamSubAueBase;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.common.TransactionWrapper;

public class Gps02Aue
extends BoamSubAueBase {
    private static final String DCI_REFERENCE = "13/109 26-CRH 109 0239-1";
    public static final int LOW_VERSION = 12000000;
    private static final int HIGH_VERSION = 16010800;
    private static final Gps02Aue INSTANCE = new Gps02Aue();
    private Coordinator context = null;
    private NodeBFunctionMo nodeBFunc = null;
    private SynchronizationMo sync = null;
    int priorityIndex = -1;

    private Gps02Aue() {
        super(Gps02Aue.class);
    }

    public static Gps02Aue instance() {
        return INSTANCE;
    }

    public String getDciReference() {
        return DCI_REFERENCE;
    }

    protected boolean execute(TransactionWrapper tw) throws Exception {
        this.traceEnter("execute() for Gps02Aue");
        this.context = tw.getCoordinator();
        this.nodeBFunc = (NodeBFunctionMo)BoamHelper.getFirstMatchingMo((String)"NodeBFunction");
        this.sync = (SynchronizationMo)BoamHelper.getFirstMatchingMo((String)"Synchronization");
        boolean featureStateActived = true;
        if ((Integer)this.nodeBFunc.getAttribute("featureStateAbsoluteTimeSynch", this.context) == 0) {
            featureStateActived = false;
        }
        MoIterator moIter = BoamHelper.findMOs((String)"Slot");
        while (moIter.hasMoreElements()) {
            SlotMo slot = (SlotMo)moIter.nextMo();
            int slotNum = (Integer)slot.getAttribute("slotNumber", this.context);
            TimingUnitMo tUnit = (TimingUnitMo)BoamHelper.getFirstMatchingMo((ManagedObject)slot, (String)"TimingUnit");
            this.trace("Gps02Aue handling SlotMo Num:" + slotNum);
            if (null == tUnit || null != tUnit && !this.checkTimingUnit(tUnit)) continue;
            switch (slotNum) {
                case 1: {
                    if (!featureStateActived) break;
                    this.removeTuSyncRef(tUnit);
                    if (this.priorityIndex == -1) break;
                    this.createGps(tUnit);
                    break;
                }
                case 2: {
                    this.removeTuSyncRef(tUnit);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkTimingUnit(TimingUnitMo timingUnit) throws NoSuchAttributeException, MoAccessException, TransactionRolledBackException, InactiveTransactionException {
        this.traceEnter("checkTimingUnit(TimingUnitMo timingUnit)");
        TransactionWrapper tw = this.createTransactionWrapper();
        Coordinator context = tw.getCoordinator();
        try {
            if (timingUnit.getAttribute("gpsOutEnabled", context).toString().equalsIgnoreCase("true")) {
                boolean bl = false;
                return bl;
            }
            GpsSyncRefMo gpsSyncRef = (GpsSyncRefMo)BoamHelper.getFirstMatchingMo((ManagedObject)timingUnit, (String)"GpsSyncRef");
            if (null != gpsSyncRef) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            tw.commit();
        }
        return true;
    }

    private void createGps(TimingUnitMo timingUnit) throws MoAccessException, InactiveTransactionException, TransactionRolledBackException {
        this.traceEnter("createGps(TimingUnitMo timingUnit)");
        TransactionWrapper createGpsTw = this.createTransactionWrapper();
        Coordinator context = createGpsTw.getCoordinator();
        AttrListImpl gpsAttrList = new AttrListImpl();
        gpsAttrList.addElement("gpsCompensationDelay", (Object)new Integer(0));
        MoFactory gpsFactory = MoFactoryMgr.instance().lookup("GpsSyncRef");
        ManagedObject gps = gpsFactory.createMo((ManagedObject)timingUnit, (AttrList)gpsAttrList, "1", null, context);
        this.trace("Gps02Aue create gpsSyncRef successfully");
        this.trace(" the free slot No." + this.priorityIndex + " in SynchronizationMo");
        this.sync.actionAddSyncRefResource(gps, this.priorityIndex, context);
        createGpsTw.commit();
    }

    private void removeTuSyncRef(TimingUnitMo timingUnit) throws TransactionRolledBackException, MoAccessException, InactiveTransactionException {
        this.traceEnter("removeTuSyncRef(TimingUnitMo timingUnit)");
        TransactionWrapper deleteTw = this.createTransactionWrapper();
        Coordinator context = deleteTw.getCoordinator();
        this.priorityIndex = -1;
        TuSyncRefMo tuSyncRef = (TuSyncRefMo)BoamHelper.getFirstMatchingMo((ManagedObject)timingUnit, (String)"TuSyncRef");
        if (null != tuSyncRef) {
            ManagedObject[] moList = this.sync.getSyncReference(context);
            for (int i = 0; i < moList.length; ++i) {
                if (moList[i] == null) continue;
                String ldn = moList[i].getLocalDistinguishedName();
                this.trace("get SyncRef LDN: " + ldn);
                if (!tuSyncRef.getLocalDistinguishedName().equals(ldn)) continue;
                int[] priorityList = this.sync.getSyncRefPriority(context);
                this.priorityIndex = priorityList[i];
                this.sync.actionRemoveSyncRefResource((ManagedObject)tuSyncRef, context);
                this.trace("actionRemoveSyncRefResource successfully");
                break;
            }
            tuSyncRef.delete(context);
        }
        deleteTw.commit();
    }

    public int getLowVersion() {
        return 12000000;
    }

    public int getHighVersion() {
        return 16010800;
    }

    private TransactionWrapper createTransactionWrapper() throws TransactionRolledBackException {
        try {
            return new TransactionWrapper();
        }
        catch (TransactionRolledBackException e) {
            this.traceError("Interrupting the system upgrade!! Failed to create transaction", e);
            throw e;
        }
    }

    protected void triggerFinish(List commands) throws Exception {
        MessageLog.traceEnter(this.getClass(), (String)"triggerFinish() for Gps02 CR16185");
        commands.add(CommandHandler.createAueCommand(this, 1));
    }
}

