/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.aue;

import java.util.List;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.aue.fpx.AueProxy;
import se.ericsson.wcdma.rbs.boam.aue.fpx.MpswTaAueCreateBasebandPoolRspS;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DownlinkBaseBandPoolMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.UplinkBaseBandPoolMo;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.BoamSubAueBase;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.common.LDNHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.TransactionWrapper;
import se.ericsson.wcdma.rbs.boam.upfwk.data.CMoData;
import se.ericsson.wcdma.rbs.boam.upfwk.data.IntegerAttribute;
import se.ericsson.wcdma.rbs.boam.upfwk.data.ReferenceAttribute;
import se.ericsson.wcdma.rbs.boam.upfwk.data.SequenceAttribute;
import se.ericsson.wcdma.rbs.boam.upfwk.data.StringAttribute;

public class IncreaseBasebandPoolAue
extends BoamSubAueBase {
    private static final String DCI_REFERENCE = "14/109 26-CRH 109 0239-1";
    public static final int LOW_VERSION = 11030000;
    private static final int HIGH_VERSION = 18020300;
    private static final int DOWNLINK_BASEBAND_POOL_TYPE_ID = 0;
    private static final int UPLINK_BASEBAND_POOL_TYPE_ID = 1;
    private static final String RADIO_INTERFACE_BOARD_REF = "radioInterfaceBoardRef";
    private static final IncreaseBasebandPoolAue INSTANCE = new IncreaseBasebandPoolAue();

    public IncreaseBasebandPoolAue() {
        super(IncreaseBasebandPoolAue.class);
    }

    public static IncreaseBasebandPoolAue instance() {
        return INSTANCE;
    }

    public String getDciReference() {
        return DCI_REFERENCE;
    }

    public boolean execute(TransactionWrapper tw) throws Exception {
        MpswTaAueCreateBasebandPoolRspS rspSig;
        int bbpId;
        MessageLog.traceEnter((Class)IncreaseBasebandPoolAue.class, (String)"--> execute");
        AueProxy.instance();
        MoIterator ulBbps = BoamHelper.findMOs((String)"UplinkBaseBandPool");
        while (ulBbps.hasMoreElements()) {
            MessageLog.traceEnter((Class)(class$se$ericsson$wcdma$rbs$boam$aue$IncreaseBasebandPoolAue == null ? IncreaseBasebandPoolAue.class$("se.ericsson.wcdma.rbs.boam.aue.IncreaseBasebandPoolAue") : class$se$ericsson$wcdma$rbs$boam$aue$IncreaseBasebandPoolAue), (String)("ulBbps" + ulBbps.toString()));
            UplinkBaseBandPoolMo ulBbp = (UplinkBaseBandPoolMo)ulBbps.nextElement();
            bbpId = Integer.parseInt(LDNHelper.getNamingAttributeValue(ulBbp.getLocalDistinguishedName())) + 2;
            rspSig = AueProxy.instance().createBbp(bbpId, 1);
            IncreaseBasebandPoolAue.updateCollectedMoData(ulBbp.getParent().getLocalDistinguishedName(), "UplinkBaseBandPool", String.valueOf(bbpId), rspSig.bbpFroId, tw.getCoordinator());
        }
        MoIterator dlBbps = BoamHelper.findMOs((String)"DownlinkBaseBandPool");
        while (dlBbps.hasMoreElements()) {
            DownlinkBaseBandPoolMo dlBbp = (DownlinkBaseBandPoolMo)dlBbps.nextElement();
            bbpId = Integer.parseInt(LDNHelper.getNamingAttributeValue(dlBbp.getLocalDistinguishedName())) + 2;
            rspSig = AueProxy.instance().createBbp(bbpId, 0);
            IncreaseBasebandPoolAue.updateCollectedMoData(dlBbp.getParent().getLocalDistinguishedName(), "DownlinkBaseBandPool", String.valueOf(bbpId), rspSig.bbpFroId, tw.getCoordinator());
        }
        return true;
    }

    private static void updateCollectedMoData(String parentLdn, String moType, String newMoIdentity, int froId, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter((Class)IncreaseBasebandPoolAue.class, (String)"--> updateCollectedMoData");
        MessageLog.traceParam((Class)IncreaseBasebandPoolAue.class, (String)("--> parentLdn=" + parentLdn + ",moType=" + moType + ",newMoIdentity=" + newMoIdentity + ",froId=" + froId));
        String preMoLdn = parentLdn + "," + moType + "=";
        String newMoLDN = preMoLdn + newMoIdentity;
        CMoData cMoData = new CMoData(newMoLDN, moType, true, context);
        if (moType.equals("UplinkBaseBandPool")) {
            cMoData.registerPersistentAttr(new StringAttribute("userLabel", false, ""));
            cMoData.registerPersistentAttr(IncreaseBasebandPoolAue.getRadioRef(newMoIdentity));
            cMoData.setRevision(5020000);
            cMoData.registerPersistentAttr(new IntegerAttribute("alarmStatus", false, 0));
            cMoData.registerPersistentAttr(new IntegerAttribute("froId", false, froId));
        } else if (moType.equals("DownlinkBaseBandPool")) {
            cMoData.registerPersistentAttr(new StringAttribute("userLabel", false, ""));
            cMoData.registerPersistentAttr(IncreaseBasebandPoolAue.getRadioRef(newMoIdentity));
            cMoData.setRevision(5020000);
            cMoData.registerPersistentAttr(new IntegerAttribute("alarmStatus", false, 0));
            cMoData.registerPersistentAttr(new IntegerAttribute("froId", false, froId));
        } else {
            MessageLog.traceError((Class)IncreaseBasebandPoolAue.class, (String)"Wrong BasebandPool Type");
        }
        cMoData.handleTransaction(context, CMoData.WRITE_ACCESS);
    }

    public int getHighVersion() {
        return 18020300;
    }

    public int getLowVersion() {
        return 11030000;
    }

    protected void triggerConvert(List commands) throws Exception {
        this.traceEnter("triggerConvert(), causing execution");
        commands.add(CommandHandler.createAueCommand(this, 1));
    }

    private static SequenceAttribute getRadioRef(String newMoIdentity) {
        MessageLog.traceEnter((Class)IncreaseBasebandPoolAue.class, (String)("--> getRadioRef() with newMoIdentity=" + newMoIdentity));
        SequenceAttribute sa = new SequenceAttribute(RADIO_INTERFACE_BOARD_REF, false);
        int slotId = Integer.parseInt(newMoIdentity) - 2;
        ManagedObject slot = BoamHelper.getFirstMatchingMo((String)"Slot", (String)String.valueOf(slotId));
        ManagedObjectBase dui = (ManagedObjectBase)BoamHelper.getMatchingMo((ManagedObject)slot, (String)"DeviceGroup", (String)"DUI");
        ReferenceAttribute ra = new ReferenceAttribute(RADIO_INTERFACE_BOARD_REF, false, (ManagedObject)dui);
        MessageLog.traceParam((Class)IncreaseBasebandPoolAue.class, (String)("--> radioInterfaceBoardRef=" + dui.getLocalDistinguishedName()));
        sa.addElement(ra);
        return sa;
    }
}

