/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.aue;

import java.util.List;
import se.ericsson.cello.equipment.SlotMo;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.swmanagement.RepertoireMo;
import se.ericsson.cello.swmanagement.SwAllocationMo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.mao.common.ProductDataUtil;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.BoamSubAueBase;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.common.FindMo;
import se.ericsson.wcdma.rbs.boam.upfwk.common.TransactionWrapper;

public final class IpOnGpbAue
extends BoamSubAueBase {
    private static final String DCI_REFERENCE = "10/109 26-CRH 109 042/1-2";
    public static final int LOW_VERSION = 5000000;
    private static final int HIGH_VERSION = 7999999;
    private static final String GPB_PROD_NO = "ROJ1192106/51";
    private static final int GPB_REV = 2;
    private static final String PRERELEASE_DATE = "20061017";
    public static final String REPERTOIRE1 = "Cello_SCTP_IP_MP";
    public static final String REPERTOIRE2 = "Cello_Function_Adm1_RBS_Sigtran";
    public static final String SW_ALLOCATION_ID = "Main_GPB";
    private static final IpOnGpbAue INSTANCE = new IpOnGpbAue();
    private static boolean isRepertoireMosFetched = false;
    private static RepertoireMo repertoireMo1 = null;
    private static RepertoireMo repertoireMo2 = null;

    private IpOnGpbAue() {
        super(IpOnGpbAue.class);
    }

    public static IpOnGpbAue instance() {
        return INSTANCE;
    }

    public int getLowVersion() {
        return 5000000;
    }

    public int getHighVersion() {
        return 7999999;
    }

    public String getDciReference() {
        return DCI_REFERENCE;
    }

    protected void triggerRbsInitiate(List commands) throws Exception {
        this.traceEnter("triggerRbsInitiate(), causing execution");
        commands.add(CommandHandler.createAueCommand(this, 1));
    }

    protected boolean execute(TransactionWrapper tw) throws Exception {
        this.traceEnter("execute()");
        Coordinator context = tw.getCoordinator();
        int updateCount = 0;
        MoIterator it = FindMo.findMOs("SwAllocation");
        while (it.hasMoreElements()) {
            ManagedObject mo = it.nextMo();
            SwAllocationMo swAllocationMo = (SwAllocationMo)mo;
            if (!mo.getNamingAttributeValue().equalsIgnoreCase(SW_ALLOCATION_ID) || !this.needsRepertoire(swAllocationMo, context)) continue;
            boolean isUpdated = false;
            if (!this.hasRepertoire(swAllocationMo, REPERTOIRE1, context)) {
                this.setRepertoire(swAllocationMo, this.getRepertoireMo(REPERTOIRE1, context), context);
                isUpdated = true;
            }
            if (!this.hasRepertoire(swAllocationMo, REPERTOIRE2, context)) {
                this.setRepertoire(swAllocationMo, this.getRepertoireMo(REPERTOIRE2, context), context);
                isUpdated = true;
            }
            if (!isUpdated) continue;
            ++updateCount;
        }
        this.trace("n. of SwAllocationMo for which the repertoire was extended: " + updateCount);
        return true;
    }

    private boolean needsRepertoire(SwAllocationMo swAllocationMo, Coordinator context) throws MoAccessException {
        ManagedObject[] slots = swAllocationMo.getSlotList(context);
        for (int i = 0; i < slots.length; ++i) {
            SlotMo slotMo;
            if (slots[i] == null || !(slots[i] instanceof SlotMo) || !this.isRecentEnough(slotMo = (SlotMo)slots[i], context)) continue;
            return true;
        }
        return false;
    }

    public boolean isRecentEnough(SlotMo slot, Coordinator context) throws MoAccessException {
        boolean isWellFormedProductionDate;
        int productRevisionNumber;
        this.traceEnter("isRecentEnough()");
        Struct productData = slot.getProductData(context);
        if (productData == null) {
            this.trace("slot MO " + slot + " has no product data");
            return false;
        }
        String productNumber = (String)productData.getValue("productNumber");
        if (productNumber == null) {
            this.trace("slot MO " + slot + " has no product number");
            return false;
        }
        try {
            productRevisionNumber = this.getRevisionNumber((String)productData.getValue("productRevision"));
        }
        catch (RuntimeException e) {
            this.trace("slot MO " + slot + ", cannot parse revision number: " + e.getMessage() + "; ignoring this slot MO");
            return false;
        }
        String productionDate = (String)productData.getValue("productionDate");
        if (productionDate == null) {
            this.trace("slot has no production date, considering only product number and revision");
            isWellFormedProductionDate = false;
        } else {
            this.trace("The original productionDate: " + productionDate);
            productionDate = ProductDataUtil.verifyDateFormat((String)productionDate);
            this.trace("The productionDate after verifyDateFormat(...): " + productionDate);
            if (productionDate.equals("00000000")) {
                this.trace("The productionDate is not well-formed; ignoring it ");
                isWellFormedProductionDate = false;
            } else {
                isWellFormedProductionDate = true;
            }
        }
        return productNumber.equalsIgnoreCase(GPB_PROD_NO) && productRevisionNumber >= 2 && (!isWellFormedProductionDate || productionDate.compareTo(PRERELEASE_DATE) > 0);
    }

    private boolean hasRepertoire(SwAllocationMo swAllocationMo, String repertoire, Coordinator context) throws MoAccessException {
        this.traceEnter("hasRepertoire()");
        ManagedObject[] repertoires = swAllocationMo.getRepertoireList(context);
        for (int i = 0; i < repertoires.length; ++i) {
            if (!repertoire.equals(((RepertoireMo)repertoires[i]).getName(context))) continue;
            return true;
        }
        return false;
    }

    private void setRepertoire(SwAllocationMo swAllocationMo, RepertoireMo repertoireMo, Coordinator context) throws MoAccessException {
        this.traceEnter("setRepertoire()");
        swAllocationMo.actionAddRepertoire((ManagedObject)repertoireMo, context);
        this.trace("added repertoire " + repertoireMo.getName(context) + " to " + swAllocationMo);
    }

    private synchronized RepertoireMo getRepertoireMo(String repertoire, Coordinator context) throws MoAccessException {
        this.traceEnter("getRepertoireMo()");
        if (!REPERTOIRE1.equals(repertoire) && !REPERTOIRE2.equals(repertoire)) {
            throw new IllegalArgumentException("AUE internal error");
        }
        if (isRepertoireMosFetched) {
            if (REPERTOIRE1.equals(repertoire)) {
                return repertoireMo1;
            }
            return repertoireMo2;
        }
        MoIterator it = FindMo.findMOs("Repertoire");
        while (it.hasMoreElements()) {
            RepertoireMo repertoireMo = (RepertoireMo)it.nextMo();
            if (REPERTOIRE1.equals(repertoireMo.getName(context))) {
                repertoireMo1 = repertoireMo;
                continue;
            }
            if (!REPERTOIRE2.equals(repertoireMo.getName(context))) continue;
            repertoireMo2 = repertoireMo;
        }
        if (repertoireMo1 == null || repertoireMo2 == null) {
            StringBuffer msg = new StringBuffer("no RepertoireMo found for");
            if (repertoireMo1 == null) {
                msg.append(": ");
                msg.append(REPERTOIRE1);
            }
            if (repertoireMo2 == null) {
                msg.append(": ");
                msg.append(REPERTOIRE2);
            }
            throw new IllegalStateException(msg.toString());
        }
        isRepertoireMosFetched = true;
        return this.getRepertoireMo(repertoire, context);
    }

    public int getRevisionNumber(String rev) {
        this.traceEnter("getRevisionNumber()");
        if (rev == null) {
            throw new IllegalArgumentException("revision string is null");
        }
        if (rev.length() < 2) {
            throw new IllegalArgumentException("revision string shorter than 2 characters");
        }
        if (!rev.substring(0, 1).equalsIgnoreCase("R")) {
            throw new IllegalArgumentException("revision string does not start by 'R' or 'r'");
        }
        StringBuffer b = new StringBuffer();
        for (int i = 1; i < rev.length() && Character.isDigit(rev.charAt(i)); ++i) {
            b.append(rev.charAt(i));
        }
        if (b.length() == 0) {
            throw new IllegalArgumentException("revision string contains no digits");
        }
        if (b.length() > 6) {
            throw new IllegalArgumentException("revision string has more than 6 digits");
        }
        return Integer.parseInt(b.toString());
    }
}

