/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.aue;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.aue.fpx.AueProxy;
import se.ericsson.wcdma.rbs.boam.aue.fpx.MpswTaAueGetDeviceInfoT;
import se.ericsson.wcdma.rbs.boam.aue.impl.CreateMoHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.common.MaoHasFro;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.BoamSubAueBase;
import se.ericsson.wcdma.rbs.boam.upfwk.command.Command;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.common.FindMo;
import se.ericsson.wcdma.rbs.boam.upfwk.common.MoDataHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.TransactionWrapper;
import se.ericsson.wcdma.rbs.boam.upfwk.data.BoamCollectorBaseMo;
import se.ericsson.wcdma.rbs.boam.upfwk.data.CMoData;
import se.ericsson.wcdma.rbs.boam.upfwk.data.IntegerAttribute;

public class UpdateDeviceCardinalityAue
extends BoamSubAueBase
implements Command {
    private static final Class SELF = UpdateDeviceCardinalityAue.class;
    private static final UpdateDeviceCardinalityAue instance = new UpdateDeviceCardinalityAue();
    private static final HashMap typeNames = new HashMap();
    private static final String DCI_REF = "14/10926-CRH109042/1-4";
    private static List createdDevices;
    public static final int LOW_VERSION = 8029999;
    private static final int HIGH_VERSION = 11030599;

    private UpdateDeviceCardinalityAue() {
        super(UpdateDeviceCardinalityAue.class);
    }

    protected void triggerConvert(List commands) throws Exception {
        MessageLog.traceEnter((Class)SELF, (String)("triggerConvert() in " + SELF.getName()));
        commands.add(CommandHandler.createAueCommand(this, 1));
    }

    public static UpdateDeviceCardinalityAue instance() {
        return instance;
    }

    public int getHighVersion() {
        return 11030599;
    }

    public int getLowVersion() {
        return 8029999;
    }

    public String getDciReference() {
        return DCI_REF;
    }

    public boolean execute(TransactionWrapper tw) throws Exception {
        int numberOfTrDeviceSets;
        this.traceEnter("execute()");
        Coordinator context = tw.getCoordinator();
        createdDevices = new ArrayList();
        typeNames.put("DpclDeviceSet", "DpclDevice");
        typeNames.put("TrDeviceSet", "TrDevice");
        MoIterator dpclDeviceSetMolist = FindMo.findMOs("DpclDeviceSet");
        MoIterator trDeviceSetMolist = FindMo.findMOs("TrDeviceSet");
        if (dpclDeviceSetMolist.size() == 0 && trDeviceSetMolist.size() == 0) {
            this.trace("Couldn't find any device sets!! No mismatches that needs to be corrected!");
            return false;
        }
        int numberOfDpclDeviceSets = dpclDeviceSetMolist.size();
        int[] deviceSetFroIds = new int[numberOfDpclDeviceSets + (numberOfTrDeviceSets = trDeviceSetMolist.size())];
        if (deviceSetFroIds.length > 0) {
            this.findDeviceSetFroIds(dpclDeviceSetMolist, 0, deviceSetFroIds, context);
            this.findDeviceSetFroIds(trDeviceSetMolist, numberOfDpclDeviceSets, deviceSetFroIds, context);
            MpswTaAueGetDeviceInfoT[] deviceInfo = AueProxy.instance().getDeviceFroIds(deviceSetFroIds);
            if (this.getNumberOfSets(deviceInfo) != deviceSetFroIds.length) {
                throw new Exception("Inconsistent number of DeviceSets between request and response");
            }
            this.updateDeviceCardinalities(deviceInfo, context);
        }
        return true;
    }

    private void findDeviceSetFroIds(MoIterator moList, int offset, int[] deviceSetFroIds, Coordinator context) throws Exception {
        for (int i = offset; i < moList.size() + offset; ++i) {
            ManagedObject deviceSet = moList.nextMo();
            deviceSetFroIds[i] = ((MaoHasFro)deviceSet).getFroId(context);
            this.trace("Aue will synchronize devices under MO: " + deviceSet.getFullDistinguishedName() + ", FroId: " + deviceSetFroIds[i]);
        }
    }

    private void updateDeviceCardinalities(MpswTaAueGetDeviceInfoT[] deviceInfo, Coordinator context) throws Exception {
        this.traceEnter("updateDeviceCardinalities()");
        if (deviceInfo == null) {
            throw new Exception("Not possible to read deviceInfo from signal (null)");
        }
        for (int i = 0; i < deviceInfo.length; ++i) {
            int setFroId = deviceInfo[i].setFroId;
            int devFroId = deviceInfo[i].deviceFroId;
            ManagedObject setMo = this.getDeviceSetMo(setFroId, context);
            List existingBoamDevFroId = this.getChildrenFroIds(setMo, context);
            if (existingBoamDevFroId.contains(new Integer(devFroId))) continue;
            this.trace("Found missing MO in Boam with froId " + devFroId + ", creation of CMoData needed");
            this.createDeviceMoIfNotExisting(setMo, setMo.getType(), deviceInfo[i].setFroId, this.getNextAvailableRdn(setMo), devFroId, context);
        }
    }

    private ManagedObject getDeviceSetMo(int setFroId, Coordinator context) throws Exception {
        this.traceEnter("getDeviceSetMo( " + setFroId + " )");
        ManagedObject setMo = (ManagedObject)this.getDeviceSet(setFroId, "DpclDeviceSet", context);
        if (setMo == null) {
            setMo = (ManagedObject)this.getDeviceSet(setFroId, "TrDeviceSet", context);
        }
        if (setMo == null) {
            throw new Exception("Not possible to get MO with froId: " + setFroId);
        }
        return setMo;
    }

    private List getChildrenFroIds(ManagedObject mo, Coordinator context) throws Exception {
        ArrayList<Integer> result = new ArrayList<Integer>();
        MoIterator moIter = mo.getChildren();
        while (moIter.hasMoreElements()) {
            MaoHasFro child = (MaoHasFro)moIter.nextMo();
            result.add(new Integer(child.getFroId(context)));
        }
        return result;
    }

    private MaoHasFro getDeviceSet(int setFroId, String moTypeName, Coordinator context) throws Exception {
        MoIterator moIter = FindMo.findMOs(moTypeName);
        while (moIter.hasMoreElements()) {
            MaoHasFro deviceSet = (MaoHasFro)moIter.nextMo();
            if (deviceSet == null || deviceSet.getFroId(context) != setFroId) continue;
            return deviceSet;
        }
        return null;
    }

    private void createDeviceMoIfNotExisting(ManagedObject parent, String parentTypeName, int parentFroId, String newMoIdentity, int froId, Coordinator context) throws Exception {
        this.traceEnter("createDeviceMoIfNotExisting()");
        String moTypeName = (String)typeNames.get(parentTypeName);
        if (moTypeName == null) {
            throw new Exception("Not possible to find child type name for " + parentTypeName);
        }
        String newLdn = parent.getLocalDistinguishedName() + "," + moTypeName + "=" + newMoIdentity;
        if (BoamHelper.findMOs((String)moTypeName, (String)newMoIdentity, (ManagedObject)parent, (int)1).size() == 0) {
            if (!this.isCMoDataExisting(froId, moTypeName, parent.getLocalDistinguishedName(), context)) {
                this.createDeviceMo(parent.getLocalDistinguishedName(), parentFroId, moTypeName, newMoIdentity, froId, context);
            } else {
                this.trace("CMoData already exists for " + newLdn + ", no new CMoData needed");
            }
        }
    }

    private boolean isCMoDataExisting(int froId, String moTypeName, String parentLdn, Coordinator context) throws MoAccessException {
        Vector cMoDataList = CreateMoHelper.getCMoData(moTypeName, parentLdn);
        Iterator iter = cMoDataList.iterator();
        while (iter.hasNext()) {
            CMoData element = (CMoData)iter.next();
            if (froId != CreateMoHelper.getFroId(element, context)) continue;
            return true;
        }
        return false;
    }

    private void createDeviceMo(String parentLdn, int parentFroId, String moTypeName, String newMoIdentity, int froId, Coordinator context) throws MoAccessException {
        this.traceEnter("createDeviceMo(), parent: " + parentLdn + ", parentFroId: " + parentFroId + ", type: " + moTypeName + ", id: " + newMoIdentity);
        BoamCollectorBaseMo moParameters = new BoamCollectorBaseMo(parentLdn, moTypeName, newMoIdentity, froId);
        CMoData cMoData = new CMoData(moParameters.getLocalDistinguishedName(), moParameters.getTypeName(), true, context);
        cMoData.registerPersistentAttr(new IntegerAttribute(MoDataHelper.getFroIdAttrName(moTypeName), false, froId));
        cMoData.handleTransaction(context, CMoData.WRITE_ACCESS);
        createdDevices.add(cMoData.getLocalDistinguishedName());
    }

    private String getNextAvailableRdn(ManagedObject parent) throws Exception {
        String moTypeName = (String)typeNames.get(parent.getType());
        if (moTypeName == null) {
            throw new Exception("Not possible to get typeName from " + parent.getType());
        }
        boolean found = false;
        for (int rdn = 1; !found && rdn < 50; ++rdn) {
            if (!this.isRdnAvailable(rdn, moTypeName, parent)) continue;
            this.trace("Next available RDN is " + rdn);
            return String.valueOf(rdn);
        }
        throw new Exception("Not possible to get available RDN for parent " + parent.getLocalDistinguishedName());
    }

    private boolean isRdnAvailable(int rdn, String moTypeName, ManagedObject parent) {
        MoIterator moIter = BoamHelper.findMOs((String)moTypeName, (ManagedObject)parent, (int)1);
        while (moIter.hasMoreElements()) {
            ManagedObject mo = moIter.nextMo();
            String moRdn = mo.getNamingAttributeValue();
            int rdnAsInt = Integer.parseInt(moRdn);
            if (rdn == rdnAsInt) {
                return false;
            }
            if (CreateMoHelper.getCMoData(parent.getLocalDistinguishedName(), moTypeName, String.valueOf(rdn)) != null) {
                return false;
            }
            if (!createdDevices.contains(parent.getLocalDistinguishedName() + "," + moTypeName + "=" + rdn)) continue;
            return false;
        }
        return true;
    }

    private int getNumberOfSets(MpswTaAueGetDeviceInfoT[] deviceInfo) {
        ArrayList<Integer> devSetList = new ArrayList<Integer>();
        for (int i = 0; i < deviceInfo.length; ++i) {
            Integer setFroId = new Integer(deviceInfo[i].setFroId);
            if (devSetList.contains(setFroId)) continue;
            devSetList.add(setFroId);
        }
        return devSetList.size();
    }
}

