/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.aue.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoDataConversionException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcDeviceGroupProxy;
import se.ericsson.wcdma.rbs.boam.upfwk.common.FindMo;

public abstract class CabinetParameterHandlerBase {
    public static final int EXACT_MATCH = 1;
    public static final int STARTS_WITH_MATCH = 2;
    public static final int FORCE_MATCH = 3;
    public static final int CABINET_PARAMETERS_LENGTH = 50;
    public final String CABINET_PARAMETERS_PROFILE_STANDARD = "cabinetParametersProfileStandard";
    public final String CABINET_PARAMETERS_PROFILE_EXTENDED = "cabinetParametersProfileExtended";
    protected final String CABINET_PARAMETERS = "cabinetParameters";
    protected String MANAGED_ELEMENT = "ManagedElement";
    protected String PRODUCT_NAME = "productName";
    protected String[] rbs_types;
    protected Class theAue;
    protected String CABINET = "Cabinet";
    protected String FCU_DEVICE_GROUP = "FcuDeviceGroup";

    CabinetParameterHandlerBase(Class _theAue) {
        this.theAue = _theAue;
    }

    protected void updateEcCabinetParameterMoData(ManagedObject ParameterMo, int[] indexes, int[] newValues, Coordinator context) throws NoSuchAttributeException, MoAccessException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        MessageLog.traceEnter((Class)this.theAue, (String)"updateEcCabinetParameterMoData");
        boolean CLIENT_ID = false;
        int[] cabinetParameters = (int[])ParameterMo.getAttribute("cabinetParameters", context);
        int cabinetParametersLength = cabinetParameters.length;
        if (this.updateNeeded(cabinetParameters, indexes, newValues)) {
            int[] newParameters = new int[cabinetParametersLength];
            for (int i = 0; i < cabinetParametersLength; ++i) {
                newParameters[i] = cabinetParameters[i];
            }
            for (int j = 0; j < indexes.length; ++j) {
                if (indexes[j] >= cabinetParameters.length) {
                    MessageLog.traceError(this.getClass(), (String)("Index of new parameter value too large: " + indexes[j]));
                    break;
                }
                newParameters[indexes[j]] = newValues[j];
            }
            EqcDeviceGroupProxy eqcDeviceGroupProxy = EqcDeviceGroupProxy.instance();
            try {
                Class[] argTypes = new Class[]{Integer.TYPE, new int[0].getClass(), Integer.TYPE};
                Method setMethod = EqcDeviceGroupProxy.class.getDeclaredMethod("setCabinetParameters", argTypes);
                Integer transId = new Integer(context.getTransactionID());
                Object[] args = new Object[]{new Integer(0), newParameters, transId};
                setMethod.invoke((Object)eqcDeviceGroupProxy, args);
            }
            catch (NoSuchMethodException e) {
                Class[] argTypes = new Class[]{Integer.TYPE, new int[0].getClass(), Coordinator.class};
                Method setMethod = EqcDeviceGroupProxy.class.getDeclaredMethod("setCabinetParameters", argTypes);
                Object[] args = new Object[]{new Integer(0), newParameters, context};
                setMethod.invoke((Object)eqcDeviceGroupProxy, args);
            }
        }
    }

    private boolean updateNeeded(int[] cabinetParameters, int[] indexes, int[] newValues) {
        MessageLog.traceEnter(this.getClass(), (String)"updateNeeded()");
        for (int j = 0; j < indexes.length; ++j) {
            if (indexes[j] >= cabinetParameters.length) {
                MessageLog.traceError(this.getClass(), (String)("Index of new parameter value too large: " + indexes[j]));
                return false;
            }
            if (newValues[j] == cabinetParameters[indexes[j]]) continue;
            return true;
        }
        return false;
    }

    protected boolean isProductNameEqual(String aueProductName, String OperationalProductName, int matchType) {
        switch (matchType) {
            case 1: {
                return aueProductName.equals(OperationalProductName);
            }
            case 2: {
                return OperationalProductName.startsWith(aueProductName);
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    protected ManagedObject getParamaterMO(String moTypeName, int matchType, Coordinator context) throws NoSuchAttributeException, MoAccessException {
        MessageLog.traceEnter(this.getClass(), (String)"getParameterMO()");
        ManagedObject rootMo = MibMgr.instance().getMib().getRootMo();
        String productName = (String)rootMo.getAttribute(this.PRODUCT_NAME, context);
        ManagedObject paramMo = null;
        if (matchType == 3 && this.rbs_types == null) {
            this.rbs_types = new String[]{""};
        }
        for (int i = 0; i < this.rbs_types.length; ++i) {
            if (this.isProductNameEqual(this.rbs_types[i], productName, matchType)) {
                MoIterator paramMoIterator = FindMo.findMOs(moTypeName);
                if (paramMoIterator.size() == 0) {
                    MessageLog.trace((int)9, this.getClass(), (String)("no " + moTypeName + " instance, nothing to do"));
                    break;
                }
                paramMo = paramMoIterator.nextMo();
                break;
            }
            if (i != this.rbs_types.length - 1) continue;
            MessageLog.trace((int)9, this.getClass(), (String)(this.MANAGED_ELEMENT + "." + this.PRODUCT_NAME + " = " + productName + ", does not match Product name/s inteded by this aue , nothing to do"));
            break;
        }
        if (paramMo == null) {
            MessageLog.trace((int)9, this.getClass(), (String)("no " + moTypeName + " instance, nothing to do"));
        }
        return paramMo;
    }

    public abstract void checkAndUpdateCabinetParameters(int var1, Coordinator var2) throws NoSuchAttributeException, MoAccessException, MoDataConversionException, IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException;

    public abstract void checkAndSetDefaultParameterValueIfProductNameMismatch(int[] var1, int[] var2, int var3, Coordinator var4) throws NoSuchAttributeException, MoAccessException, MoDataConversionException, IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException;

    public abstract void checkAndSetDefaultParameterValueIfProductNameMismatch(int var1, int var2, int var3, Coordinator var4) throws NoSuchAttributeException, MoAccessException, MoDataConversionException, IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException;
}

