/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.aue.impl;

import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.aue.fpx.AueProxy;
import se.ericsson.wcdma.rbs.boam.aue.fpx.MpswTaAueCreateSaRspS;
import se.ericsson.wcdma.rbs.boam.aue.fpx.MpswTaAueParentFroIdInfoT;
import se.ericsson.wcdma.rbs.boam.mao.common.AttrListImpl;
import se.ericsson.wcdma.rbs.boam.upfwk.common.LDNHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.MoDataHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.data.Attribute;
import se.ericsson.wcdma.rbs.boam.upfwk.data.CMoData;
import se.ericsson.wcdma.rbs.boam.upfwk.data.IntegerAttribute;
import se.ericsson.wcdma.rbs.boam.upfwk.data.RecoveryHandler;

public abstract class CreateMoHelper {
    public static CMoData getCMoData(String ldn) {
        MessageLog.traceEnter((Class)CreateMoHelper.class, (String)"getCMoData()");
        if (ldn == null) {
            throw new IllegalArgumentException("local distinguished name must not be null");
        }
        Iterator it = RecoveryHandler.getCollectedMoData().iterator();
        while (it.hasNext()) {
            CMoData cMoData = (CMoData)it.next();
            if (!ldn.equals(cMoData.getLocalDistinguishedName())) continue;
            return cMoData;
        }
        return null;
    }

    public static Vector getCMoData() {
        return RecoveryHandler.getCollectedMoData();
    }

    public static int CMoDataSize() {
        return RecoveryHandler.getCollectedMoData().size();
    }

    public static int getFroId(CMoData moData, Coordinator context) throws MoAccessException {
        Attribute attr = moData.getAttribute(MoDataHelper.getFroIdAttrName(moData.getMoTypeName()));
        return ((IntegerAttribute)attr).getValue(context);
    }

    public static void createMo(String moType, ManagedObject parent, String identity, AttrListImpl attributes, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter((Class)CreateMoHelper.class, (String)"createMo()");
        MoFactory moFactory = MoFactoryMgr.instance().lookup(moType);
        if (moFactory == null) {
            MessageLog.traceError((Class)CreateMoHelper.class, (String)("Factory not found for type:" + moType));
            return;
        }
        moFactory.createMo(parent, (AttrList)attributes, identity, null, context);
    }

    public static int[] createSectorAntennaFroIdsRequest(int nFroIds) throws MoAccessException {
        AueProxy.instance().checkAndWaiteForProxy();
        MpswTaAueCreateSaRspS rspSig = AueProxy.instance().createSectorAntennaFroIdsRequest(nFroIds);
        int[] result = new int[rspSig.numberOfElements];
        for (int i = 0; i < rspSig.numberOfElements; ++i) {
            result[i] = (int)rspSig.froIdList[i];
        }
        return result;
    }

    public static void setParentFroIdRequest(MpswTaAueParentFroIdInfoT[] parentFroIds) throws MoAccessException {
        AueProxy.instance().checkAndWaiteForProxy();
        AueProxy.instance().setParentFroId(parentFroIds);
    }

    public static Vector getCMoData(String moTypeName, String parentLdn) {
        RecoveryHandler.forceRecovery();
        Vector cMoDataList = RecoveryHandler.getCollectedMoData();
        Vector<CMoData> result = new Vector<CMoData>();
        Iterator iter = cMoDataList.iterator();
        while (iter.hasNext()) {
            CMoData cMoData = (CMoData)iter.next();
            String cMoDataParentLdn = LDNHelper.getParentLdn(cMoData.getLocalDistinguishedName(), cMoData.getMoTypeName());
            if (!cMoData.getMoTypeName().equals(moTypeName) || !cMoDataParentLdn.equals(parentLdn)) continue;
            result.add(cMoData);
        }
        return result;
    }

    public static CMoData getCMoData(String parentLdn, String typeName, String id) {
        MessageLog.traceEnter((Class)CreateMoHelper.class, (String)"getCMoData()");
        if (parentLdn == null || typeName == null || id == null) {
            throw new IllegalArgumentException("argument must not be null");
        }
        if (parentLdn.equals("")) {
            return CreateMoHelper.getCMoData(typeName + "=" + id);
        }
        return CreateMoHelper.getCMoData(parentLdn + "," + typeName + "=" + id);
    }
}

