/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.conv;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.Strings;
import se.ericsson.wcdma.rbs.boam.upfwk.common.LDNHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.MoConverterUtility;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.DataConverterBase;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.helper.TopologyMgr;

public class DC20030299To20030300
extends DataConverterBase {
    private static final int fromConverterRev = 20030299;
    private static final int toConverterRev = 20030300;
    private static final DC20030299To20030300 instance = new DC20030299To20030300();
    private Coordinator context;
    private ArrayList auxPluginList = new ArrayList();
    private ArrayList ruw1 = new ArrayList();
    private ArrayList ruw2 = new ArrayList();
    private ArrayList ruw3 = new ArrayList();
    private int[] correctRuw1Position;
    private int sectorNumbers = 0;

    private DC20030299To20030300() {
        super(20030299, 20030300);
    }

    private void reset() {
        this.auxPluginList.clear();
        this.ruw1.clear();
        this.ruw2.clear();
        this.ruw3.clear();
    }

    public static DC20030299To20030300 instance() {
        return instance;
    }

    protected void doDC() throws Exception {
        this.traceEnter("doDC(),DC20030299To20030300");
        this.reset();
        if (this.isHybridRbs()) {
            this.getUpdateCandidates();
            if (this.ruw2.size() > 0 || this.ruw3.size() > 0) {
                this.trace("There exist cascading RUW on one sector, not fit HS50275 configuration.Do nothing.");
                return;
            }
            if (!this.diff(this.ruw1, this.correctRuw1Position(this.ruw1.size()))) {
                this.trace("No update is needed, no candidates found.");
            } else {
                this.trace("ruw1 need change for some elements");
                this.updateNamingAttributeValues();
                this.updateRfCableLdn();
                this.updateDigitalCableLdn();
            }
        } else {
            this.trace("No update is needed,preCondition not meet.");
        }
    }

    private void updateDigitalCableLdn() throws Exception {
        Iterator digitCableIter = this.workingMoData.getMoData("DigitalCable").iterator();
        ArrayList<MoData> digitalCableList = new ArrayList<MoData>();
        while (digitCableIter.hasNext()) {
            MoData digitCable = (MoData)digitCableIter.next();
            digitalCableList.add(digitCable);
        }
        for (int i = 0; i < digitalCableList.size(); ++i) {
            MoData digitCable = (MoData)digitalCableList.get(i);
            ReferenceAttribute refA = (ReferenceAttribute)digitCable.getAttribute("connectedToObjectARef");
            MoData auxPiu = this.getMoDataFromLdn(refA.getReferenceAsLDN(), "AuxPlugInUnit");
            if (auxPiu == null) continue;
            if (auxPiu.getLocalDistinguishedName().indexOf("RbsSlot=") != -1) {
                String oldDigitRdn = LDNHelper.getRelativeDistinguishedName(digitCable.getLocalDistinguishedName());
                this.trace("oldDigitRdn: " + oldDigitRdn);
                int oldDigitRdnNum = Integer.parseInt(Strings.split((String)oldDigitRdn, (String)"_")[1]);
                int auxPiuPosition = this.getRuwPositionNum(auxPiu);
                if (oldDigitRdnNum != auxPiuPosition) {
                    String newDigitRdn = Strings.split((String)oldDigitRdn, (String)"_")[0] + "_" + auxPiuPosition + "_" + Strings.split((String)oldDigitRdn, (String)"_")[2] + "_" + Strings.split((String)oldDigitRdn, (String)"_")[3];
                    String newDigitLdn = LDNHelper.replaceFirst(digitCable.getLocalDistinguishedName(), oldDigitRdn, newDigitRdn);
                    this.trace("newDigitLdn: " + newDigitLdn);
                    TopologyMgr mgr = new TopologyMgr(this.workingMoData);
                    mgr.changeLdnTopology(digitCable, newDigitLdn);
                    continue;
                }
                this.trace("nothing to do, matched.");
                continue;
            }
            this.trace("no rfCable need update.");
        }
    }

    private void updateRfCableLdn() throws Exception {
        Iterator rfCableIter = this.workingMoData.getMoData("RfCable").iterator();
        ArrayList<MoData> rfCableList = new ArrayList<MoData>();
        while (rfCableIter.hasNext()) {
            MoData rfCable = (MoData)rfCableIter.next();
            rfCableList.add(rfCable);
        }
        for (int i = 0; i < rfCableList.size(); ++i) {
            MoData rfCable = (MoData)rfCableList.get(i);
            ReferenceAttribute refA = (ReferenceAttribute)rfCable.getAttribute("connectedToObjectARef");
            MoData auxPiu = this.getMoDataFromLdn(refA.getReferenceAsLDN(), "AuxPlugInUnit");
            if (auxPiu == null) continue;
            if (auxPiu.getLocalDistinguishedName().indexOf("RbsSlot=") != -1) {
                String oldRfRdn = LDNHelper.getRelativeDistinguishedName(rfCable.getLocalDistinguishedName());
                this.trace("oldRfRdn: " + oldRfRdn);
                int oldRfRdnNum = Integer.parseInt(Strings.split((String)oldRfRdn, (String)"_")[1]);
                int auxPiuPosition = this.getRuwPositionNum(auxPiu);
                if (oldRfRdnNum != auxPiuPosition) {
                    String newRfRdn = Strings.split((String)oldRfRdn, (String)"_")[0] + "_" + auxPiuPosition + "_" + Strings.split((String)oldRfRdn, (String)"_")[2] + "_" + Strings.split((String)oldRfRdn, (String)"_")[3];
                    String newRfLdn = LDNHelper.replaceFirst(rfCable.getLocalDistinguishedName(), oldRfRdn, newRfRdn);
                    this.trace("newRfLdn: " + newRfLdn);
                    TopologyMgr mgr = new TopologyMgr(this.workingMoData);
                    mgr.changeLdnTopology(rfCable, newRfLdn);
                    continue;
                }
                this.trace("nothing to do, matched.");
                continue;
            }
            this.trace("no rfCable need update.");
        }
    }

    private MoData getMoDataFromLdn(String ldn, String typeName) {
        this.traceEnter("getMoDataFromLdn()");
        Collection moDatas = this.workingMoData.getMoData(typeName);
        Iterator it = moDatas.iterator();
        while (it.hasNext()) {
            MoData moData = (MoData)it.next();
            if (!moData.getLocalDistinguishedName().equals(ldn)) continue;
            return moData;
        }
        return null;
    }

    private void updateNamingAttributeValues() throws Exception {
        this.traceEnter("updateNamingAttributeValues()");
        TopologyMgr mgr = new TopologyMgr(this.workingMoData);
        for (int i = this.ruw1.size() - 1; i >= 0; --i) {
            MoData moDataRuw1 = (MoData)this.ruw1.get(i);
            String ldnRuw1 = moDataRuw1.getLocalDistinguishedName();
            String newLdnRuw1 = this.getNewAuxLdn(i, moDataRuw1);
            this.trace("newLdnRuw1: " + newLdnRuw1);
            if (ldnRuw1.equals(newLdnRuw1)) continue;
            this.trace("Found AuxPluginUnit=RUW-1 that needs to be updated: " + ldnRuw1);
            mgr.changeLdnTopology(moDataRuw1, newLdnRuw1);
        }
        this.trace(mgr.getModificationInfo());
    }

    private String getNewAuxLdn(int index, MoData moData) {
        this.traceEnter("getNewAuxLdn()");
        String newAuxLnd = LDNHelper.replaceFirst(moData.getLocalDistinguishedName(), String.valueOf(this.getRuwPositionNum(moData)), String.valueOf(this.correctRuw1Position[index]));
        this.trace("newAuxLnd: " + newAuxLnd);
        return newAuxLnd;
    }

    private boolean isHybridRbs() throws MoAccessException {
        Collection sectorMo = this.workingMoData.getMoData("Sector");
        this.sectorNumbers = sectorMo.size();
        this.trace("sectorNumbers =" + this.sectorNumbers);
        Collection auxMo = this.workingMoData.getMoData("AuxPlugInUnit");
        int macroRadioNumber = 0;
        int remoteRadioNumber = 0;
        Iterator iter = auxMo.iterator();
        while (iter.hasNext()) {
            MoData auxMoData = (MoData)iter.next();
            IntegerAttribute auType = (IntegerAttribute)auxMoData.getAttribute("auType");
            if (auType == null) {
                this.traceError("Attribute auType is null!");
                return false;
            }
            if (auType.getValue(this.context) == 20 || auType.getValue(this.context) == 26 || auType.getValue(this.context) == 10) {
                ++remoteRadioNumber;
                continue;
            }
            if (auType.getValue(this.context) != 19) continue;
            ++macroRadioNumber;
            this.auxPluginList.add(auxMoData);
        }
        return macroRadioNumber > 0 && remoteRadioNumber > 0 && this.sectorNumbers == 4;
    }

    private void getUpdateCandidates() throws Exception {
        Iterator iter = this.auxPluginList.iterator();
        while (iter.hasNext()) {
            MoData mo = (MoData)iter.next();
            String AuxLDN = mo.getLocalDistinguishedName();
            if (-1 == AuxLDN.indexOf("RbsSlot=")) continue;
            if (AuxLDN.indexOf("RUW-1") != -1) {
                this.ruw1.add(mo);
                this.trace("ruw1 add mo:" + AuxLDN);
            }
            if (AuxLDN.indexOf("RUW-2") != -1) {
                this.ruw2.add(mo);
                this.trace("ruw2 add mo:" + AuxLDN);
                continue;
            }
            if (AuxLDN.indexOf("RUW-3") == -1) continue;
            this.ruw3.add(mo);
            this.trace("ruw3 add mo:" + AuxLDN);
        }
    }

    private int[] correctRuw1Position(int size) {
        this.correctRuw1Position = size == 2 ? new int[]{3, 9} : (size == 4 ? new int[]{3, 9, 7, 13} : new int[]{3, 7, 11, 5, 9, 13});
        return this.correctRuw1Position;
    }

    private boolean diff(ArrayList ruw1, int[] correctRuw1Position) throws NoSuchAttributeException, MoAccessException {
        for (int i = 0; i < ruw1.size(); ++i) {
            if (this.getRuwPositionNum((MoData)ruw1.get(i)) == correctRuw1Position[i]) continue;
            return true;
        }
        return false;
    }

    private int getRuwPositionNum(MoData auxMo) {
        MoData RbsSlot;
        String RbsSlotLDN = LDNHelper.getParentLdn(auxMo.getLocalDistinguishedName(), "AuxPlugInUnit");
        if (RbsSlotLDN != null && !RbsSlotLDN.equals("") && (RbsSlot = MoConverterUtility.getMoDataByLDN(this.workingMoData, null, RbsSlotLDN)).getMoTypeName().equals("RbsSlot")) {
            this.trace("Found RbsSlot: " + RbsSlotLDN);
            IntegerAttribute slotPosition = (IntegerAttribute)RbsSlot.getAttribute("slotPosition");
            return slotPosition.getValue(null);
        }
        return 0;
    }

    protected void initDC(Coordinator arg0) throws Exception {
        this.traceEnter("initDC()");
        this.context = arg0;
    }
}

