/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.conv;

import java.util.Collection;
import java.util.Iterator;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.conv.operations.AddSingleReferenceAttributeOp;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.command.Macro;
import se.ericsson.wcdma.rbs.boam.upfwk.common.LDNHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.DataConverterBase;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.operations.AddReservedByOp;

public class DC26060998To26060999
extends DataConverterBase {
    private static final DC26060998To26060999 instance = new DC26060998To26060999();
    protected static final int FROM_CONVERTER_REV = 26060998;
    protected static final int TO_CONVERTER_REV = 26060999;
    private static final String EXTERNAL_ANTENNA_TYPENAME = "ExternalAntenna";
    private static final String EXTERNAL_ANTENNA_ATTRIBUTE_NAME = "sectorAntennaRef";
    private static final String TYPE_RET = "2";
    private final Macro macro = new Macro();

    protected DC26060998To26060999() {
        super(26060998, 26060999);
    }

    public static DC26060998To26060999 instance() {
        return instance;
    }

    protected void initDC(Coordinator context) throws Exception {
        this.traceEnter("initDC()");
        this.context = context;
        this.handleExternalAntennaData();
    }

    protected void doDC() throws Exception {
        this.traceEnter("doDC()");
        CommandHandler.execute(this.macro, 1);
    }

    private void handleExternalAntennaData() throws Exception {
        Collection eaCollection = this.workingMoData.getMoData(EXTERNAL_ANTENNA_TYPENAME);
        if (eaCollection.isEmpty()) {
            this.trace("ExternalAntenna mo not found.");
            return;
        }
        Iterator externalAntennaIterator = eaCollection.iterator();
        while (externalAntennaIterator.hasNext()) {
            MoData eaMoData = (MoData)externalAntennaIterator.next();
            String eaLdn = eaMoData.getLocalDistinguishedName();
            this.trace("The externalAntenna ldn : " + eaLdn);
            boolean isMountRet = this.isConnectedRet(eaLdn);
            String sectorAntennaLdn = null;
            if (isMountRet) {
                String sector = eaLdn.substring(eaLdn.lastIndexOf("=") + 1, eaLdn.lastIndexOf("-"));
                sectorAntennaLdn = "ManagedElement=1,Equipment=1,SectorAntenna=" + sector + "-1";
                this.macro.add(new AddReservedByOp(this.workingMoData, this.context, sectorAntennaLdn, eaLdn));
            }
            this.trace("isMountRet : " + isMountRet + ", sectorAntennaLdn : " + sectorAntennaLdn);
            this.macro.add(new AddSingleReferenceAttributeOp(26060999, EXTERNAL_ANTENNA_ATTRIBUTE_NAME, sectorAntennaLdn, eaMoData, false, this.context));
        }
    }

    private boolean isConnectedRet(String ldn) throws MoAccessException {
        Collection auxPlugInUnitCollection = this.workingMoData.getMoData("AuxPlugInUnit");
        if (auxPlugInUnitCollection.isEmpty()) {
            this.trace("AuxPlugInUnit mo not found in Working Data.");
            return false;
        }
        Iterator auxPlugInUnitIterator = auxPlugInUnitCollection.iterator();
        while (auxPlugInUnitIterator.hasNext()) {
            String auxPlugInUnitLdn = ((MoData)auxPlugInUnitIterator.next()).getLocalDistinguishedName();
            if (auxPlugInUnitLdn.indexOf(ldn) == -1 || !TYPE_RET.equals(LDNHelper.getNamingAttributeValue(auxPlugInUnitLdn))) continue;
            return true;
        }
        return false;
    }
}

