/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.conv.operations;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.command.Command;
import se.ericsson.wcdma.rbs.boam.upfwk.common.MoDataHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.ReserveMoHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.WorkingMoData;

public class addReservedByOfAUOp
implements Command {
    public static final String BOAM_RESERVED_BY = "persistentReservers";
    public static final String CELLO_RESERVED_BY = "reservedBy";
    public static final String CELLO_RESERVED_BY_UC = "ReservedBy";
    public static final String CELLO_RESERVED_BY_PIU = "reservedByList";
    private final WorkingMoData workingMoData;
    private final String callerLdn;
    private final String callerMoTypeName;
    private final String reserveLdn;
    private final Coordinator context;

    public addReservedByOfAUOp(WorkingMoData workingMoData, Coordinator context, String callerLdn, String callerMoTypeName, String reserveLdn) {
        MessageLog.traceEnter(this.getClass(), (String)"Start addReservedByOfAUOp");
        this.workingMoData = workingMoData;
        this.context = context;
        this.callerLdn = callerLdn;
        this.callerMoTypeName = callerMoTypeName;
        this.reserveLdn = reserveLdn;
    }

    public void execute() throws Exception {
        MessageLog.traceEnter(this.getClass(), (String)"execute()");
        Collection mos = this.workingMoData.getMoData(this.callerMoTypeName);
        if (mos.isEmpty()) {
            MessageLog.trace((int)9, this.getClass(), (String)(this.callerMoTypeName + " MO not found in Working Data."));
            return;
        }
        Iterator iter = mos.iterator();
        while (iter.hasNext()) {
            MoData tmpMoData = (MoData)iter.next();
            if (!this.callerLdn.equals(tmpMoData.getLocalDistinguishedName()) || !tmpMoData.getMoTypeName().equalsIgnoreCase("AuxPlugInUnit")) continue;
            MessageLog.trace((int)9, this.getClass(), (String)("Add persistentReservers in " + this.callerLdn + " with value " + this.reserveLdn));
            MoDataHelper.activateWriteAccess(this.context, tmpMoData);
            this.checkReservation(tmpMoData.getLocalDistinguishedName(), this.reserveLdn);
        }
    }

    public void checkReservation(String LDN, String refLdn) throws Exception {
        MessageLog.trace((int)9, this.getClass(), (String)(" refLdn is " + refLdn));
        MoData toBeReservedMo = this.getMoDataByLdn(LDN);
        if (toBeReservedMo != null) {
            String reserverLDN;
            Attribute reserverAuxPlugInUnit = toBeReservedMo.getAttribute(CELLO_RESERVED_BY);
            if (reserverAuxPlugInUnit == null) {
                reserverAuxPlugInUnit = toBeReservedMo.getAttribute(CELLO_RESERVED_BY_PIU);
            }
            if (reserverAuxPlugInUnit == null) {
                reserverAuxPlugInUnit = toBeReservedMo.getAttribute(CELLO_RESERVED_BY_UC);
            }
            if (reserverAuxPlugInUnit == null) {
                reserverAuxPlugInUnit = toBeReservedMo.getAttribute(BOAM_RESERVED_BY);
            }
            if (reserverAuxPlugInUnit == null) {
                MoDataHelper.registerSeqAttr(toBeReservedMo, null, CELLO_RESERVED_BY, false, new Attribute[]{new ReferenceAttribute("", refLdn, false)});
                reserverAuxPlugInUnit = toBeReservedMo.getAttribute(CELLO_RESERVED_BY);
                MessageLog.trace((int)9, this.getClass(), (String)(" reserverAuxPlugInUnit is " + reserverAuxPlugInUnit.getName()));
            }
            if (reserverAuxPlugInUnit instanceof SequenceAttribute) {
                if (ReserveMoHelper.isReservedBy((SequenceAttribute)reserverAuxPlugInUnit, LDN, this.context)) {
                    MessageLog.trace((int)9, (Class)ReserveMoHelper.class, (String)("reservee is " + refLdn + ", the reserver:" + LDN + " is already in the reservedBy list. "));
                } else {
                    toBeReservedMo.handleTransaction(this.context, MoData.WRITE_ACCESS);
                    MessageLog.trace((int)9, this.getClass(), (String)("reservee is " + refLdn + ", did not find LDN " + LDN + " in the reserver list, reserver list size is : " + ((SequenceAttribute)reserverAuxPlugInUnit).size()));
                    ReserveMoHelper.reserve(toBeReservedMo, refLdn, this.context);
                    MessageLog.trace((int)9, this.getClass(), (String)(" new reserver list size is : " + ((SequenceAttribute)reserverAuxPlugInUnit).size()));
                }
            } else if (reserverAuxPlugInUnit instanceof ReferenceAttribute && !LDN.equals(reserverLDN = ((ReferenceAttribute)reserverAuxPlugInUnit).getReferenceAsLDN())) {
                toBeReservedMo.handleTransaction(this.context, MoData.WRITE_ACCESS);
                MessageLog.trace((int)9, this.getClass(), (String)" did not find the reserver, make explicit reservation... ");
                ReserveMoHelper.reserve(toBeReservedMo, LDN, this.context);
            }
        } else {
            MessageLog.traceError(this.getClass(), (String)"did not find the corresponding MO according to LDN");
        }
    }

    private MoData getMoDataByLdn(String moLdn) {
        MessageLog.traceEnter(this.getClass(), (String)"getMoDataByLdn()");
        Vector originalData = this.workingMoData.getOriginalData();
        MoData tmp = null;
        Iterator i = originalData.iterator();
        while (i.hasNext()) {
            tmp = (MoData)i.next();
            if (!tmp.getLocalDistinguishedName().equals(moLdn)) continue;
            return tmp;
        }
        return null;
    }
}

