/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.frodataconv;

import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.frodataconv.ApcFroAttributes;
import se.ericsson.wcdma.rbs.boam.frodataconv.ColumnData;
import se.ericsson.wcdma.rbs.boam.frodataconv.CommonSupportSystemFroDataConverter;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.OutDeviceMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.OutDeviceMo;
import se.ericsson.wcdma.rbs.boam.upfwk.database.DatabaseMgr;

public class ControlPortFroDataConverter
extends CommonSupportSystemFroDataConverter {
    private static ControlPortFroDataConverter _theOne = new ControlPortFroDataConverter();
    private ColumnData[] columnData = new ColumnData[]{new ColumnData("ldn", DatabaseMgr.getSql().varcharType(100)), new ColumnData("administrativeState", "INTEGER"), new ColumnData("normallyOpen", "INTEGER"), new ColumnData("portStatus", "INTEGER")};

    private ControlPortFroDataConverter() {
        super("ControlPortFroDataConverter");
    }

    public static ControlPortFroDataConverter instance() {
        return _theOne;
    }

    protected ColumnData[] getColumnData() {
        return this.columnData;
    }

    protected String getTypeName() {
        return "OutDevice";
    }

    protected Object[] getTableData(ManagedObject nextMo, Coordinator context) throws MoAccessException {
        OutDeviceMo outDeviceMo = (OutDeviceMo)nextMo;
        ManagedObject mo = OutDeviceMoImpl.getAncestor((ManagedObject)outDeviceMo, (String)"AuxPlugInUnit");
        if (!(mo instanceof AuxPlugInUnitMo)) {
            return null;
        }
        String auType = ControlPortFroDataConverter.getAuType(mo, context);
        if (auType == null) {
            return null;
        }
        String hwUnitId = auType.equalsIgnoreCase("SUP") ? this.getSupHwUnitId(mo.getNamingAttributeValue()) : auType;
        String ldn = "ManagedElement=1,Equipment=1,HwUnit=" + hwUnitId + ",ControlPort=" + outDeviceMo.getNamingAttributeValue();
        return new Object[]{new Integer(this.nextFroId()), ldn, new Integer(outDeviceMo.getAdministrativeState(context)), new Integer(outDeviceMo.getNormallyOpen(context) ? 1 : 0), new Integer(outDeviceMo.getOutDeviceStatus(context))};
    }

    protected void createNewMoData(MoData modata, String ldn, int froId, Coordinator c) throws MoAccessException {
        StringAttribute userLabel = (StringAttribute)modata.getAttribute("userLabel");
        MoData newModata = new MoData(ldn, this.getNewTypeName(), true, c);
        newModata.handleTransaction(c, MoData.WRITE_ACCESS);
        newModata.registerPersistentAttr((Attribute)userLabel);
        IntegerAttribute intAttr = new IntegerAttribute("froId", false);
        newModata.registerPersistentAttr((Attribute)intAttr);
        intAttr.setValue(froId);
        StringAttribute equipmentName = (StringAttribute)modata.getAttribute("equipmentName");
        newModata.registerPersistentAttr((Attribute)equipmentName);
        newModata.setRevision(8010001);
    }

    protected ApcFroAttributes[] getApcFroAttributesData() {
        int froType = this.getFroType();
        return new ApcFroAttributes[]{new ApcFroAttributes(froType, "administrativeState", "S32"), new ApcFroAttributes(froType, "normallyOpen", "S32"), new ApcFroAttributes(froType, "portStatus", "S32")};
    }

    protected String getNewTypeName() {
        return "ControlPort";
    }
}

