/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.common;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import se.ericsson.cello.support.debug.Assert;
import se.ericsson.cello.support.debug.MessageLog;

public abstract class Const {
    public static final int DC_TRACE_GROUP = 9;
    public static final int AUE_TRACE_GROUP = 9;
    public static final int UPFWK_TRACE_GROUP = 9;
    private static final String CPP6_ASSERT = "assert";
    private static final String CPP7_ASSERT = "cppAssert";

    public static final void callAssert(boolean b) {
        Class[] formalParameters = new Class[]{Boolean.TYPE};
        Object[] actualParameters = new Object[]{new Boolean(b)};
        Const.invokeAssert(CPP7_ASSERT, formalParameters, actualParameters);
    }

    public static final void callAssert(boolean b, String msg) {
        Class[] formalParameters = new Class[]{Boolean.TYPE, String.class};
        Object[] actualParameters = new Object[]{new Boolean(b), msg};
        Const.invokeAssert(CPP7_ASSERT, formalParameters, actualParameters);
    }

    public static final void callAssert(long j) {
        Class[] formalParameters = new Class[]{Long.TYPE};
        Object[] actualParameters = new Object[]{new Long(j)};
        Const.invokeAssert(CPP7_ASSERT, formalParameters, actualParameters);
    }

    public static final void callAssert(double x) {
        Class[] formalParameters = new Class[]{Double.TYPE};
        Object[] actualParameters = new Object[]{new Double(x)};
        Const.invokeAssert(CPP7_ASSERT, formalParameters, actualParameters);
    }

    public static final void callAssert(Object b) {
        Class[] formalParameters = new Class[]{Object.class};
        Object[] actualParameters = new Object[]{b};
        Const.invokeAssert(CPP7_ASSERT, formalParameters, actualParameters);
    }

    public static final void callAssert(Object b, String msg) {
        Class[] formalParameters = new Class[]{Object.class, String.class};
        Object[] actualParameters = new Object[]{b, msg};
        Const.invokeAssert(CPP7_ASSERT, formalParameters, actualParameters);
    }

    public static void logStackTrace(Class c, Throwable t) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            MessageLog.info((Class)c, (String)sw.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void invokeAssert(String methodName, Class[] formalParameters, Object[] actualParameters) {
        try {
            Method m = Assert.class.getMethod(methodName, formalParameters);
            m.invoke(null, actualParameters);
        }
        catch (NoSuchMethodException e) {
            if (!methodName.equals(CPP6_ASSERT)) {
                Const.invokeAssert(CPP6_ASSERT, formalParameters, actualParameters);
            }
            String msg = "no CPP assert-method found";
            MessageLog.traceError((Class)Const.class, (String)"no CPP assert-method found", (Throwable)e);
            throw new RuntimeException("no CPP assert-method found");
        }
        catch (InvocationTargetException e) {
            String msg = "InvocationTargetException caught when invoking CPP assert-method: " + e;
            MessageLog.traceError((Class)Const.class, (String)msg, (Throwable)e.getTargetException());
            throw new RuntimeException(msg + ", caused by: " + e.getTargetException());
        }
        catch (Exception e) {
            String msg = "exception caught when invoking CPP assert-method";
            MessageLog.traceError((Class)Const.class, (String)"exception caught when invoking CPP assert-method", (Throwable)e);
            throw new RuntimeException("exception caught when invoking CPP assert-method: " + Const.toString(e));
        }
    }

    private static String toString(Throwable t) {
        try {
            Method m = Throwable.class.getMethod("getCause", new Class[0]);
            Throwable cause = (Throwable)m.invoke((Object)t, new Object[0]);
            if (cause == null) {
                return t.toString();
            }
            return t.toString() + ", caused by: " + Const.toString(cause);
        }
        catch (Exception e) {
            return t.toString();
        }
    }
}

