/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.conv;

import java.io.PrintWriter;
import java.io.StringWriter;
import se.ericsson.cello.moframework.MoDataConversionException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.wcdma.rbs.boam.upfwk.common.MoDataHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.TransactionWrapper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.WorkingMoData;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.Converter;

public abstract class DataConverterBase
implements Converter {
    private final int fromConverterRev;
    private final int toConverterRev;
    protected WorkingMoData workingMoData = null;
    protected Coordinator context;

    protected DataConverterBase(int fromConverterRev, int toConverterRev) {
        this.fromConverterRev = fromConverterRev;
        this.toConverterRev = toConverterRev;
        String longName = this.getClass().getName();
        String shortName = longName.substring(longName.lastIndexOf(".") + 1);
        if (!this.deleteDigits(shortName).equals("DCTo")) {
            throw new IllegalArgumentException("ill-formed classname: " + shortName);
        }
        if (!shortName.equals("DC" + fromConverterRev + "To" + toConverterRev)) {
            throw new IllegalArgumentException("converter revisions: " + fromConverterRev + ", " + toConverterRev + " does not match classname: " + shortName);
        }
    }

    public boolean convert(WorkingMoData data) throws MoDataConversionException {
        MessageLog.info(this.getClass(), (String)("convert(), from Rev:" + this.fromConverterRev + "==> Rev:" + this.toConverterRev));
        boolean result = false;
        this.workingMoData = data;
        if (data != null) {
            TransactionWrapper tx = null;
            try {
                tx = new TransactionWrapper(2000);
                this.initDC(tx.getCoordinator());
                this.doDC();
                tx.commit();
            }
            catch (InactiveTransactionException ite) {
                MessageLog.traceError(this.getClass(), (String)"\n\n InactiveTransactionException!!");
                throw new MoDataConversionException(ite.toString());
            }
            catch (TransactionRolledBackException txe) {
                MessageLog.traceError(this.getClass(), (String)"\n\n TransactionRolledBackException!!");
                throw new MoDataConversionException(txe.toString());
            }
            catch (Exception ex) {
                try {
                    if (tx != null) {
                        tx.rollback();
                    }
                    MessageLog.traceError(this.getClass(), (String)("\n\n An irrecoverable failure during data conversion has occurred. Calling Assert!!" + ex));
                    this.printErrorMessage(ex);
                    MoDataHelper.restartSystem(this.getClass());
                    result = true;
                }
                catch (InactiveTransactionException ite) {
                    // empty catch block
                }
                throw new MoDataConversionException(ex.toString());
            }
        }
        MessageLog.info(this.getClass(), (String)"WorkingMoData is empty, nothing to do!!");
        result = false;
        MessageLog.info(this.getClass(), (String)("End of convert() " + this.getClass().getName()));
        return result;
    }

    public int getFromRevision() {
        return this.fromConverterRev;
    }

    public int getToRevision() {
        return this.toConverterRev;
    }

    protected abstract void initDC(Coordinator var1) throws Exception;

    protected abstract void doDC() throws Exception;

    protected void traceEnter(String message) {
        MessageLog.traceEnter(this.getClass(), (String)message);
    }

    protected void traceError(String message) {
        MessageLog.traceError(this.getClass(), (String)message);
    }

    protected void traceError(String message, Exception e) {
        MessageLog.traceError(this.getClass(), (String)message, (Throwable)e);
    }

    protected void info(String message) {
        MessageLog.info(this.getClass(), (String)message);
    }

    protected void trace(String message) {
        MessageLog.trace((int)9, this.getClass(), (String)message);
    }

    private void printErrorMessage(Exception ex) {
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        MessageLog.traceError(this.getClass(), (String)("\n\n An irrecoverable failure occurred during data conversion. Exception: " + ex + "\n Stack trace: \n" + sw.toString()));
    }

    private String deleteDigits(String x) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < x.length(); ++i) {
            if (Character.isDigit(x.charAt(i))) continue;
            result.append(x.charAt(i));
        }
        return result.toString();
    }
}

