/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.conv.operations;

import java.util.Collection;
import java.util.Iterator;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoDataConversionException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.command.Command;
import se.ericsson.wcdma.rbs.boam.upfwk.common.MoDataHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.WorkingMoData;

public class ConvertRefToSeqAttributeOp
implements Command {
    private final WorkingMoData workingMoData;
    private final String moTypeName;
    private final int newRev;
    private final String oldRefAttrName;
    private final String newSeqAttrName;
    private final Coordinator context;

    public ConvertRefToSeqAttributeOp(WorkingMoData workingMoData, String moTypeName, int oldRev, int newRev, String oldRefAttrName, String newSeqAttrName, Coordinator context) {
        this.workingMoData = workingMoData;
        this.moTypeName = moTypeName;
        this.newRev = newRev;
        if (oldRefAttrName == null) {
            throw new IllegalArgumentException("old attribute name must not be null");
        }
        if (oldRefAttrName.equals("")) {
            throw new IllegalArgumentException("old attribute name must not be empty string");
        }
        if (newSeqAttrName == null) {
            throw new IllegalArgumentException("new attribute name must not be null");
        }
        if (newSeqAttrName.equals("")) {
            throw new IllegalArgumentException("new attribute name must not be empty string");
        }
        this.oldRefAttrName = oldRefAttrName;
        this.newSeqAttrName = newSeqAttrName;
        this.context = context;
    }

    public void execute() throws Exception {
        MessageLog.traceEnter(this.getClass(), (String)"execute()");
        Collection mos = this.workingMoData.getMoData(this.moTypeName);
        if (mos.isEmpty()) {
            MessageLog.trace((int)9, this.getClass(), (String)(this.moTypeName + " MO not found in Working Data."));
            return;
        }
        Iterator iter = mos.iterator();
        while (iter.hasNext()) {
            MoData tmpMoData = (MoData)iter.next();
            MoDataHelper.activateWriteAccess(this.context, tmpMoData);
            Attribute attr = tmpMoData.getAttribute(this.oldRefAttrName);
            String prelude = " Attribute " + this.oldRefAttrName + " in " + this.moTypeName + " (rev " + tmpMoData.getRevision() + ") ";
            if (attr == null) {
                MessageLog.trace((int)9, this.getClass(), (String)(" The attribute " + this.oldRefAttrName + " does not exist in the MoData : " + tmpMoData.getLocalDistinguishedName()));
                throw new MoDataConversionException(" The attribute " + this.oldRefAttrName + " does not exist in the MoData : " + tmpMoData.getLocalDistinguishedName());
            }
            if (attr instanceof ReferenceAttribute) {
                SequenceAttribute seq = new SequenceAttribute(this.newSeqAttrName, false);
                if (((ReferenceAttribute)attr).getReferenceAsLDN() != null) {
                    seq.addElement(attr);
                }
                tmpMoData.deregisterAttribute(this.oldRefAttrName);
                tmpMoData.registerPersistentAttr((Attribute)seq);
                tmpMoData.setRevision(this.newRev);
                continue;
            }
            if (attr instanceof SequenceAttribute && this.oldRefAttrName.equals(this.newSeqAttrName)) {
                MessageLog.trace((int)9, this.getClass(), (String)(prelude + "is already of type SequenceAttribute, no action"));
                continue;
            }
            throw new MoDataConversionException(prelude + "is of type " + attr.getClass().getName() + ", expected a ReferenceAttribute!! ");
        }
    }
}

