/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.data;

import java.io.Serializable;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoRemovedException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.recovery.MoTypeLookup;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.data.Attribute;

public class ReferenceAttribute
extends Attribute
implements Serializable {
    static final long serialVersionUID = 259823827781573047L;
    private transient ManagedObject myReferredMo = null;
    private transient ManagedObject myReferredMoBackup = null;
    private String myReferredDName = null;
    private transient boolean myIsTransactionActive = false;

    public ReferenceAttribute(String aName, boolean isAttrValueChangeNotifier) {
        super(aName, isAttrValueChangeNotifier);
    }

    public ReferenceAttribute(String aName, boolean isAttrValueChangeNotifier, ManagedObject initialValue) {
        super(aName, isAttrValueChangeNotifier);
        this.myReferredMo = initialValue;
    }

    public ReferenceAttribute(String aName, String ldn, boolean isAttrValueChangeNotifier) {
        super(aName, isAttrValueChangeNotifier);
        this.myReferredDName = ldn;
    }

    public ReferenceAttribute(String aName, String attrData) {
        super(aName, attrData.charAt(1));
        String data = attrData.substring(2);
        this.myReferredDName = data.equals("null") ? null : MoTypeLookup.instance().convertToLDN(data);
    }

    public synchronized ManagedObject getValue(Coordinator c) throws MoRemovedException {
        if (this.myReferredMo == null && this.myReferredDName != null) {
            this.resolve();
        }
        if (this.myReferredMo != null && this.myReferredMo.isRemoved()) {
            throw new MoRemovedException(this.myReferredMo.getLocalDistinguishedName());
        }
        if ((c == null || c.getTransactionID() == 0) && this.myIsTransactionActive) {
            return this.myReferredMoBackup;
        }
        return this.myReferredMo;
    }

    public synchronized String getReferenceAsLDN() {
        if (this.myReferredDName != null) {
            return this.myReferredDName;
        }
        if (this.myReferredMo != null) {
            return this.myReferredMo.getLocalDistinguishedName();
        }
        return null;
    }

    public synchronized void setValue(ManagedObject anMo) {
        this.myReferredDName = null;
        this.myReferredMo = anMo;
    }

    synchronized void rollback() {
        this.myReferredMo = this.myReferredMoBackup;
        this.myIsTransactionActive = false;
    }

    synchronized void commit() {
        this.myReferredMoBackup = null;
        this.myIsTransactionActive = false;
    }

    synchronized void startTransaction() {
        try {
            this.resolve();
        }
        catch (MoRemovedException moRemovedException) {
            // empty catch block
        }
        this.myReferredMoBackup = this.myReferredMo;
        this.myIsTransactionActive = true;
    }

    private void resolve() throws MoRemovedException {
        if (this.myReferredMo == null && this.myReferredDName != null) {
            ManagedObject node = MoRepository.instance().lookup(this.myReferredDName);
            if (node == null) {
                throw new MoRemovedException(this.myReferredDName);
            }
            this.myReferredMo = node;
            this.myReferredMoBackup = node;
            this.myReferredDName = null;
        }
    }

    Object getValueAsObject(Coordinator c) {
        try {
            return this.getValue(c);
        }
        catch (MoRemovedException e) {
            return null;
        }
    }

    boolean isModified() {
        return this.myReferredMo != this.myReferredMoBackup;
    }

    public String buildString() {
        String ldnToStore = null;
        String avc = null;
        if ((this.myReferredMo != null || this.myReferredDName == null) && this.myReferredMo != null) {
            this.myReferredDName = this.myReferredMo.getLocalDistinguishedName();
        }
        avc = this.isAVCNotifier() ? "T" : "F";
        ldnToStore = this.myReferredDName != null ? MoTypeLookup.instance().convertToShortLDNFormat(this.myReferredDName) : null;
        return this.getName() + "^r" + avc + ldnToStore;
    }
}

