/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.frodata;

import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.wcdma.rbs.boam.upfwk.database.Database;
import se.ericsson.wcdma.rbs.boam.upfwk.database.DatabaseMgr;
import se.ericsson.wcdma.rbs.boam.upfwk.database.DbAccessException;
import se.ericsson.wcdma.rbs.boam.upfwk.database.ResultSet;
import se.ericsson.wcdma.rbs.boam.upfwk.database.Sql;

public class PersistentDictionary {
    private static PersistentDictionary _theOne;
    private final String TABLE = "boam_name_values";
    private final String KEY = "name";
    private final String VALUE = "value";
    Sql _sql = DatabaseMgr.getSql();
    Database _db;

    private PersistentDictionary() throws DbAccessException {
        try {
            this._db = DatabaseMgr.getDatabase();
            this.createTable();
        }
        catch (Throwable e) {
            MessageLog.info(this.getClass(), (String)"Could not connect to the database. This may happen in the test environment when Polyhedra is selected as database");
        }
    }

    public static PersistentDictionary instance() throws DbAccessException {
        if (_theOne == null) {
            _theOne = new PersistentDictionary();
        }
        return _theOne;
    }

    private Sql.Select select(String key) {
        return this._sql.selectEquals("boam_name_values", "*", "name", key);
    }

    public String get(String key) throws DbAccessException {
        if (this._db == null) {
            throw new DbAccessException(new Exception("No contact to the database"));
        }
        ResultSet res = this._db.executeQuery(this.select(key));
        if (res.next()) {
            return (String)res.getObject(2);
        }
        return null;
    }

    public void put(String key, String value) throws DbAccessException {
        if (this._db == null) {
            return;
        }
        ResultSet res = this._db.executeQuery(this.select(key), true, true);
        if (res.next()) {
            Sql.Update update = this._sql.updateEquals("boam_name_values", "name", key);
            update.updateValue("value", value);
            this._db.executeSql(update);
        } else {
            Sql.Insert insert = this._sql.insert("boam_name_values", new Object[]{key, value});
            this._db.executeSql(insert);
        }
        this._db.commit();
        res.close();
    }

    public void put(String key, int value) throws DbAccessException {
        this.put(key, new Integer(value).toString());
    }

    public int getInt(String key, int defaultValue) throws DbAccessException {
        String val = this.get(key);
        if (val != null) {
            try {
                int i = Integer.parseInt(val);
                return i;
            }
            catch (NumberFormatException e) {
                MessageLog.traceReturn(this.getClass(), (String)("Could not parse property :" + key + " to an int, value :" + val));
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public void remove(String key) throws DbAccessException {
        this._db.executeSql(this._sql.deleteRow("boam_name_values", "name", key));
        this._db.commit();
    }

    private void createTable() throws DbAccessException {
        if (!this._db.tableExists("boam_name_values")) {
            Sql.CreateTable create = this._sql.createTable("boam_name_values");
            create.addPrimaryKey("name", this._sql.varcharType(1024));
            create.addColumn("value", this._sql.varcharType(1024));
            this._db.executeSql(create);
        }
    }
}

