/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa;

import se.ericsson.security.cppsec.esa.SecurityActivationException;
import se.ericsson.security.cppsec.esa.proxy.EsaProxyFactory;
import se.ericsson.security.cppsec.esa.wrapper.MessageLogWrapper;
import se.ericsson.security.cppsec.esa.wrapper.MessageLogWrapperFactory;

public class AATestExecutor {
    static final String AATEST = "aatest -u -v -v";
    protected static final int AA_DIAG_AAQ_OK = 0;
    protected static final int AA_DIAG_AAQ_FAIL = 1;
    protected static final int AA_DIAG_HTTP_POST_FAIL = 2;
    protected static final int AA_DIAG_HTTP_GET_FAIL = 3;
    protected static final int AA_DIAG_SSL_FAIL = 4;
    protected static final int AA_DIAG_CMD_FAIL = 5;
    protected static final int AA_DIAG_NO_TEST_PERFORMED = 6;
    private static final MessageLogWrapper logger = MessageLogWrapperFactory.getLogger(AATestExecutor.class);

    protected static void execute(String string) throws SecurityActivationException {
        logger.traceEnter("execute AATest(" + string + ")");
        int n = EsaProxyFactory.getEsaProxy().runCommand(AATEST);
        if (n != 0) {
            throw new SecurityActivationException("Failed to execute the aatest command! Result: " + AATestExecutor.getResultMessage(n));
        }
    }

    private static String getResultMessage(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = "AAQ  OK";
                break;
            }
            case 1: {
                string = "AAQ NOT OK";
                break;
            }
            case 2: {
                string = "HTTP 'Post' NOT OK";
                break;
            }
            case 3: {
                string = "HTTP 'Get' NOT OK";
                break;
            }
            case 4: {
                string = "SSL context establishment NOT OK";
                break;
            }
            case 5: {
                string = "Bad parameters to the AATEST command";
                break;
            }
            case 6: {
                string = "No AA Server addresses";
                break;
            }
            default: {
                string = "Unknown return code from crypto server cmd interface";
            }
        }
        return string;
    }
}

