/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa.parser;

import java.util.ArrayList;
import org.xml.sax.Attributes;
import se.ericsson.security.cppsec.esa.SecurityActivationInputException;
import se.ericsson.security.cppsec.esa.parser.StackElement;

public class InitialSecConfData
extends StackElement {
    public String fileFormatVersion = null;
    public Body body = null;
    public Validator validator = null;

    protected void fetchAttributes(Attributes attributes) throws SecurityActivationInputException {
        int n = attributes.getLength();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            String string = attributes.getQName(i);
            String string2 = attributes.getValue(i);
            stringBuffer.append(", " + string + "=" + string2);
            if (!string.equalsIgnoreCase("fileFormatVersion")) {
                throw new SecurityActivationInputException("Unknown attribute for element " + this.getShortName() + ": " + string);
            }
            this.fileFormatVersion = string2;
        }
        if (!"1".equals(this.fileFormatVersion)) {
            throw new SecurityActivationInputException("Illegal fileFormatVersion" + this.getShortName() + ": " + stringBuffer.toString());
        }
    }

    protected StackElement createElement(String string, String string2, String string3, Attributes attributes) {
        StackElement stackElement = null;
        if ("body".equalsIgnoreCase(string2)) {
            stackElement = this.body = new Body();
        } else if ("validator".equalsIgnoreCase(string2)) {
            this.validator = new Validator();
            stackElement = this.validator;
        }
        return stackElement;
    }

    public void evaluate() throws SecurityActivationInputException {
        if (this.body == null || this.validator == null) {
            throw new SecurityActivationInputException("Element logical validation error: " + this.getShortName() + " body or validator missing");
        }
    }

    public static class Validator
    extends StackElement {
        public String hash = null;
        public String hmac = null;

        protected void fetchAttributes(Attributes attributes) throws SecurityActivationInputException {
            int n = attributes.getLength();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                String string = attributes.getQName(i);
                String string2 = attributes.getValue(i);
                stringBuffer.append(", " + string + "=" + string2);
                if (string.equalsIgnoreCase("hash")) {
                    this.hash = string2;
                    continue;
                }
                if (string.equalsIgnoreCase("hmac")) {
                    this.hmac = string2;
                    continue;
                }
                throw new SecurityActivationInputException("Unknown attribute for element " + this.getShortName() + ": " + string);
            }
            if (this.hash == null || this.hmac == null) {
                throw new SecurityActivationInputException("Illegal combination of attributes for element " + this.getShortName() + ": " + stringBuffer.toString() + " hash or hmac missing");
            }
        }
    }

    public static class Body
    extends StackElement {
        public InstallationMetaData installationMetaData = null;
        public Level1 level1 = null;
        public Level2 level2 = null;
        public Level3 level3 = null;

        protected StackElement createElement(String string, String string2, String string3, Attributes attributes) {
            StackElement stackElement = null;
            if ("InstallationMetaData".equalsIgnoreCase(string2)) {
                stackElement = this.installationMetaData = new InstallationMetaData();
            } else if ("Level1".equalsIgnoreCase(string2)) {
                this.level1 = new Level1();
                stackElement = this.level1;
            } else if ("Level2".equalsIgnoreCase(string2)) {
                this.level2 = new Level2();
                stackElement = this.level2;
            } else if ("Level3".equalsIgnoreCase(string2)) {
                this.level3 = new Level3();
                stackElement = this.level3;
            }
            return stackElement;
        }

        public void evaluate() throws SecurityActivationInputException {
            if (this.installationMetaData == null || this.level1 == null) {
                throw new SecurityActivationInputException("Element logical validation error: " + this.getShortName() + " installationMetaData and or level1 missing");
            }
            if ("2".equals(this.installationMetaData.wantedSecurityLevel) && this.level2 == null) {
                throw new SecurityActivationInputException("Element logical validation error: " + this.getShortName() + " wantedSecurityLevel=2 requires level2 values");
            }
            if ("3".equals(this.installationMetaData.wantedSecurityLevel) && (this.level2 == null || this.level3 == null)) {
                throw new SecurityActivationInputException("Element logical validation error: " + this.getShortName() + " wantedSecurityLevel=3 requires level2 and level3 values");
            }
            if (this.level1.lvl1ConfigurationSettings.secmode_Telnet_and_FTP_servers == null) {
                this.level1.lvl1ConfigurationSettings.secmode_Telnet_and_FTP_servers = new Level1.Lvl1ConfigurationSettings.Secmode_Telnet_and_FTP_servers();
                this.level1.lvl1ConfigurationSettings.secmode_Telnet_and_FTP_servers.value = "3".equals(this.installationMetaData.wantedSecurityLevel) ? "Secure" : "Unsecure";
            }
        }

        public static class Level3
        extends StackElement {
            public Lvl3ConfigurationSettings lvl3ConfigurationSettings = null;
            public Level3Files level3Files = null;

            protected StackElement createElement(String string, String string2, String string3, Attributes attributes) {
                StackElement stackElement = null;
                if ("Lvl3ConfigurationSettings".equalsIgnoreCase(string2)) {
                    stackElement = this.lvl3ConfigurationSettings = new Lvl3ConfigurationSettings();
                } else if ("Level3Files".equalsIgnoreCase(string2)) {
                    this.level3Files = new Level3Files();
                    stackElement = this.level3Files;
                }
                return stackElement;
            }

            public void evaluate() throws SecurityActivationInputException {
                if (this.lvl3ConfigurationSettings == null || this.level3Files == null) {
                    throw new SecurityActivationInputException("Element logical validation error: " + this.getShortName() + " lvl3ConfigurationSettings and level3Files must have values");
                }
            }

            public static class Level3Files
            extends StackElement {
                public LocalAaDbFileSigners_Certs localAaDbFileSigners_Certs = null;
                public AaServers_Certs aaServers_Certs = null;
                public LocalAuthenticationDB localAuthenticationDB = null;
                public LocalAuthorizationDB localAuthorizationDB = null;

                protected StackElement createElement(String string, String string2, String string3, Attributes attributes) {
                    StackElement stackElement = null;
                    if ("LocalAaDbFileSigners_Certs".equalsIgnoreCase(string2)) {
                        stackElement = this.localAaDbFileSigners_Certs = new LocalAaDbFileSigners_Certs();
                    } else if ("AaServers_Certs".equalsIgnoreCase(string2)) {
                        this.aaServers_Certs = new AaServers_Certs();
                        stackElement = this.aaServers_Certs;
                    } else if ("localAuthenticationDB".equalsIgnoreCase(string2)) {
                        this.localAuthenticationDB = new LocalAuthenticationDB();
                        stackElement = this.localAuthenticationDB;
                    } else if ("localAuthorizationDB".equalsIgnoreCase(string2)) {
                        this.localAuthorizationDB = new LocalAuthorizationDB();
                        stackElement = this.localAuthorizationDB;
                    }
                    return stackElement;
                }

                public void evaluate() throws SecurityActivationInputException {
                    if (this.localAaDbFileSigners_Certs == null || this.aaServers_Certs == null || this.localAuthenticationDB == null || this.localAuthorizationDB == null) {
                        throw new SecurityActivationInputException("Element logical validation error: " + this.getShortName() + " all of localAaDbFileSigners_Certs, localAuthenticationDB, and localAuthorizationDB must have values");
                    }
                }

                public static class LocalAuthorizationDB
                extends EncryptedContentContainer {
                }

                public static class LocalAuthenticationDB
                extends EncryptedContentContainer {
                }

                public static class AaServers_Certs
                extends CertFiles {
                }

                public static class LocalAaDbFileSigners_Certs
                extends CertFiles {
                }
            }

            public static class Lvl3ConfigurationSettings
            extends StackElement {
                public SecMO_aAServerIPAddressList secMO_aAServerIPAddressList = null;
                public SecMO_authorizationCacheTimeOut secMO_authorizationCacheTimeOut = new SecMO_authorizationCacheTimeOut();

                protected StackElement createElement(String string, String string2, String string3, Attributes attributes) {
                    StackElement stackElement = null;
                    if ("SecMO_aAServerIPAddressList".equalsIgnoreCase(string2)) {
                        stackElement = this.secMO_aAServerIPAddressList = new SecMO_aAServerIPAddressList();
                    } else if ("SecMO_authorizationCacheTimeOut".equalsIgnoreCase(string2)) {
                        stackElement = this.secMO_authorizationCacheTimeOut;
                    }
                    return stackElement;
                }

                public void evaluate() throws SecurityActivationInputException {
                    if (this.secMO_aAServerIPAddressList == null) {
                        throw new SecurityActivationInputException("Element logical validation error: " + this.getShortName() + " SecMO_aAServerIPAddressList cannot be empty");
                    }
                }

                public static class SecMO_authorizationCacheTimeOut
                extends StackElement {
                    public SecMO_authorizationCacheTimeOut() {
                        this.value = "60";
                    }
                }

                public static class SecMO_aAServerIPAddressList
                extends StackElement {
                    public ArrayList ipAddresses = new ArrayList();

                    protected StackElement createElement(String string, String string2, String string3, Attributes attributes) {
                        IpV4Address ipV4Address = null;
                        if ("ipV4Address".equalsIgnoreCase(string2)) {
                            ipV4Address = new IpV4Address();
                            this.ipAddresses.add(ipV4Address);
                        }
                        return ipV4Address;
                    }

                    public void evaluate() throws SecurityActivationInputException {
                        if (this.ipAddresses.isEmpty()) {
                            throw new SecurityActivationInputException("Element logical validation error: " + this.getShortName() + " the SecMO_aAServerIPAddressList cannot be empty");
                        }
                    }

                    public static class IpV4Address
                    extends StackElement {
                        public void evaluate() throws SecurityActivationInputException {
                            if (this.value == null) {
                                throw new SecurityActivationInputException("Element logical validation error: " + this.getShortName() + " ipV4Address must be specified");
                            }
                        }
                    }
                }
            }
        }

        public static class Level2
        extends StackElement {
            public Lvl2ConfigurationSettings lvl2ConfigurationSettings = null;
            public EnrollmentData enrollmentData = null;
            public Level2Files level2Files = null;

            protected StackElement createElement(String string, String string2, String string3, Attributes attributes) {
                StackElement stackElement = null;
                if ("Lvl2ConfigurationSettings".equalsIgnoreCase(string2)) {
                    stackElement = this.lvl2ConfigurationSettings = new Lvl2ConfigurationSettings();
                } else if ("enrollmentData".equalsIgnoreCase(string2)) {
                    this.enrollmentData = new EnrollmentData();
                    stackElement = this.enrollmentData;
                } else if ("Level2Files".equalsIgnoreCase(string2)) {
                    this.level2Files = new Level2Files();
                    stackElement = this.level2Files;
                }
                return stackElement;
            }

            public void evaluate() throws SecurityActivationInputException {
                if (this.lvl2ConfigurationSettings == null || this.enrollmentData == null || this.level2Files == null) {
                    throw new SecurityActivationInputException("Element logical validation error: " + this.getShortName() + " values must be specified in all of lvl2ConfigurationSettings, enrollmentData and level2Files");
                }
            }

            public static class Level2Files
            extends StackElement {
                public CorbaPeers_Certs corbaPeers_Certs = null;
                public EnrollmentDataChallangePassword enrollmentDataChallangePassword = null;

                protected StackElement createElement(String string, String string2, String string3, Attributes attributes) {
                    StackElement stackElement = null;
                    if ("corbaPeers_Certs".equalsIgnoreCase(string2)) {
                        stackElement = this.corbaPeers_Certs = new CorbaPeers_Certs();
                    } else if ("enrollmentDataChallangePassword".equalsIgnoreCase(string2)) {
                        this.enrollmentDataChallangePassword = new EnrollmentDataChallangePassword();
                        stackElement = this.enrollmentDataChallangePassword;
                    }
                    return stackElement;
                }

                public void evaluate() throws SecurityActivationInputException {
                    if (this.corbaPeers_Certs == null || this.enrollmentDataChallangePassword == null) {
                        throw new SecurityActivationInputException("Element logical validation error: " + this.getShortName() + " either of corbaPeers_Certs or enrollmentDataChallangePassword is missing");
                    }
                }

                public static class EnrollmentDataChallangePassword
                extends EncryptedContentContainer {
                }

                public static class CorbaPeers_Certs
                extends CertFiles {
                }
            }

            public static class EnrollmentData
            extends StackElement {
                public DistinguishedName distinguishedName = null;
                public EnrollmentServerURL enrollmentServerURL = null;
                public CA_Fingerprint cA_Fingerprint = null;

                protected StackElement createElement(String string, String string2, String string3, Attributes attributes) {
                    StackElement stackElement = null;
                    if ("DistinguishedName".equalsIgnoreCase(string2)) {
                        stackElement = this.distinguishedName = new DistinguishedName();
                    } else if ("EnrollmentServerURL".equalsIgnoreCase(string2)) {
                        this.enrollmentServerURL = new EnrollmentServerURL();
                        stackElement = this.enrollmentServerURL;
                    } else if ("CA_Fingerprint".equalsIgnoreCase(string2)) {
                        this.cA_Fingerprint = new CA_Fingerprint();
                        stackElement = this.cA_Fingerprint;
                    }
                    return stackElement;
                }

                public void evaluate() throws SecurityActivationInputException {
                    if (this.distinguishedName == null || this.enrollmentServerURL == null || this.cA_Fingerprint == null) {
                        throw new SecurityActivationInputException("Element logical validation error: " + this.getShortName() + " either of distinguishedName, enrollmentServerURL, or cA_Fingerprint is missing");
                    }
                }

                public static class CA_Fingerprint
                extends StackElement {
                    public void evaluate() throws SecurityActivationInputException {
                        if (this.value == null) {
                            throw new SecurityActivationInputException("Element logical validation error: " + this.getShortName() + " cA_Fingerprint missing");
                        }
                    }
                }

                public static class EnrollmentServerURL
                extends StackElement {
                    public void evaluate() throws SecurityActivationInputException {
                        if (this.value == null) {
                            throw new SecurityActivationInputException("Element logical validation error: " + this.getShortName() + " enrollmentServerURL missing");
                        }
                    }
                }

                public static class DistinguishedName
                extends StackElement {
                    public void evaluate() throws SecurityActivationInputException {
                        if (this.value == null) {
                            throw new SecurityActivationInputException("Element logical validation error: " + this.getShortName() + " distinguishedName missing");
                        }
                    }
                }
            }

            public static class Lvl2ConfigurationSettings
            extends StackElement {
                public ArrayList mgdElmtDtaMO_logonServerAddresses = new ArrayList();
                public SecMO_certExpirWarnTime secMO_certExpirWarnTime = new SecMO_certExpirWarnTime();

                protected StackElement createElement(String string, String string2, String string3, Attributes attributes) {
                    StackElement stackElement = null;
                    if ("MgmtElmtDtaMO_logonServerAddress".equalsIgnoreCase(string2)) {
                        stackElement = new MgdElmtDtaMO_logonServerAddress();
                        this.mgdElmtDtaMO_logonServerAddresses.add(stackElement);
                    } else if ("SecMO_certExpirWarnTime".equalsIgnoreCase(string2)) {
                        this.secMO_certExpirWarnTime = new SecMO_certExpirWarnTime();
                        stackElement = this.secMO_certExpirWarnTime;
                    }
                    return stackElement;
                }

                public void evaluate() throws SecurityActivationInputException {
                    if (this.mgdElmtDtaMO_logonServerAddresses.isEmpty() || this.secMO_certExpirWarnTime == null) {
                        throw new SecurityActivationInputException("Element logical validation error: " + this.getShortName() + " no value in MgdElmtDtaMO_logonServerAddresses or SecMO_certExpirWarnTime");
                    }
                }

                public static class SecMO_certExpirWarnTime
                extends StackElement {
                    public SecMO_certExpirWarnTime() {
                        this.value = "90";
                    }
                }

                public static class MgdElmtDtaMO_logonServerAddress
                extends StackElement {
                    public void evaluate() throws SecurityActivationInputException {
                        if (this.value == null) {
                            throw new SecurityActivationInputException("Element logical validation error: " + this.getShortName() + " MgdElmtDtaMO_logonServerAddress tag is missing");
                        }
                    }
                }
            }
        }

        public static class Level1
        extends StackElement {
            public Lvl1ConfigurationSettings lvl1ConfigurationSettings = null;

            protected StackElement createElement(String string, String string2, String string3, Attributes attributes) {
                Lvl1ConfigurationSettings lvl1ConfigurationSettings = null;
                if ("Lvl1ConfigurationSettings".equalsIgnoreCase(string2)) {
                    lvl1ConfigurationSettings = this.lvl1ConfigurationSettings = new Lvl1ConfigurationSettings();
                }
                return lvl1ConfigurationSettings;
            }

            public void evaluate() throws SecurityActivationInputException {
                if (this.lvl1ConfigurationSettings == null) {
                    throw new SecurityActivationInputException("Element logical validation error: " + this.getShortName() + " lvl1ConfigurationSettings missing");
                }
            }

            public static class Lvl1ConfigurationSettings
            extends StackElement {
                public SecMO_userLabel secMO_userLabel = null;
                public Secmode_fileTransferClient secmode_fileTransferClient = new Secmode_fileTransferClient();
                public Secmode_Telnet_and_FTP_servers secmode_Telnet_and_FTP_servers = null;

                protected StackElement createElement(String string, String string2, String string3, Attributes attributes) {
                    StackElement stackElement = null;
                    if ("SecMO_userLabel".equalsIgnoreCase(string2)) {
                        stackElement = this.secMO_userLabel = new SecMO_userLabel();
                    } else if ("secmode_fileTransferClient".equalsIgnoreCase(string2)) {
                        this.secmode_fileTransferClient = new Secmode_fileTransferClient();
                        stackElement = this.secmode_fileTransferClient;
                    } else if ("Secmode_Telnet_and_FTP_servers".equalsIgnoreCase(string2)) {
                        this.secmode_Telnet_and_FTP_servers = new Secmode_Telnet_and_FTP_servers();
                        stackElement = this.secmode_Telnet_and_FTP_servers;
                    }
                    return stackElement;
                }

                public static class Secmode_Telnet_and_FTP_servers
                extends StackElement {
                }

                public static class Secmode_fileTransferClient
                extends StackElement {
                    public Secmode_fileTransferClient() {
                        this.value = "Secure";
                    }
                }

                public static class SecMO_userLabel
                extends StackElement {
                    public SecMO_userLabel() {
                        this.value = "";
                    }
                }
            }
        }

        public static class InstallationMetaData
        extends StackElement {
            public String creationTime = null;
            public String notValidAfter = null;
            public String logicalName = null;
            public String wantedSecurityLevel = null;
            public String minimumSecurityLevel = null;
            public String setSecurityLevel3timeout = "30";

            protected void fetchAttributes(Attributes attributes) throws SecurityActivationInputException {
                int n = attributes.getLength();
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < n; ++i) {
                    String string = attributes.getQName(i);
                    String string2 = attributes.getValue(i);
                    stringBuffer.append(", " + string + "=" + string2);
                    if (string.equalsIgnoreCase("creationTime")) {
                        this.creationTime = string2;
                        continue;
                    }
                    if (string.equalsIgnoreCase("notValidAfter")) {
                        this.notValidAfter = string2;
                        continue;
                    }
                    if (string.equalsIgnoreCase("logicalName")) {
                        this.logicalName = string2;
                        continue;
                    }
                    if (string.equalsIgnoreCase("wantedSecurityLevel")) {
                        this.wantedSecurityLevel = string2;
                        continue;
                    }
                    if (string.equalsIgnoreCase("minimumSecurityLevel")) {
                        this.minimumSecurityLevel = string2;
                        continue;
                    }
                    if (string.equalsIgnoreCase("setSecurityLevel3timeout")) {
                        this.setSecurityLevel3timeout = string2;
                        continue;
                    }
                    throw new SecurityActivationInputException("Unknown attribute for element " + this.getShortName() + ": " + string);
                }
                if (this.creationTime == null || this.notValidAfter == null || this.logicalName == null || this.wantedSecurityLevel == null) {
                    throw new SecurityActivationInputException("Illegal combination of attributes for element " + this.getShortName() + ": " + stringBuffer.toString() + " required attributes must be present");
                }
                if (Integer.parseInt(this.wantedSecurityLevel) < 1 || Integer.parseInt(this.wantedSecurityLevel) > 3) {
                    throw new SecurityActivationInputException("Value out of range " + this.getShortName() + ": " + stringBuffer.toString() + ": wantedSecurityLevel is out of range");
                }
                if (this.minimumSecurityLevel == null) {
                    this.minimumSecurityLevel = this.wantedSecurityLevel;
                }
                if (Integer.parseInt(this.wantedSecurityLevel) < Integer.parseInt(this.minimumSecurityLevel)) {
                    throw new SecurityActivationInputException("Value out of range " + this.getShortName() + ": " + stringBuffer.toString() + ": wantedSecurityLevel is less than minimumSecurityLevel");
                }
            }
        }

        public static abstract class EncryptedContentContainer
        extends StackElement {
            public EncryptedContent encryptedContent = null;

            protected StackElement createElement(String string, String string2, String string3, Attributes attributes) {
                EncryptedContent encryptedContent = null;
                if ("EncryptedContent".equalsIgnoreCase(string2)) {
                    encryptedContent = this.encryptedContent = new EncryptedContent();
                }
                return encryptedContent;
            }

            public void evaluate() throws SecurityActivationInputException {
                if (this.encryptedContent == null) {
                    throw new SecurityActivationInputException("Element logical validation error: " + this.getShortName() + " encryptedContent is missing");
                }
            }
        }

        public static class CertFiles
        extends StackElement {
            public ArrayList certFiles = new ArrayList();

            protected StackElement createElement(String string, String string2, String string3, Attributes attributes) {
                CertFile certFile = null;
                if ("CertFile".equalsIgnoreCase(string2)) {
                    certFile = new CertFile();
                    this.certFiles.add(certFile);
                }
                return certFile;
            }

            public void evaluate() throws SecurityActivationInputException {
                if (this.certFiles.isEmpty()) {
                    throw new SecurityActivationInputException("Element logical validation error: " + this.getShortName() + " certFile is empty");
                }
            }

            public static class CertFile
            extends StackElement {
                public String certFingerprint = null;
                public String certSerialNumber = null;
                public EncryptedContent encryptedContent = null;

                protected StackElement createElement(String string, String string2, String string3, Attributes attributes) {
                    EncryptedContent encryptedContent = null;
                    if ("EncryptedContent".equalsIgnoreCase(string2)) {
                        encryptedContent = this.encryptedContent = new EncryptedContent();
                    }
                    return encryptedContent;
                }

                protected void fetchAttributes(Attributes attributes) throws SecurityActivationInputException {
                    int n = attributes.getLength();
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < n; ++i) {
                        String string = attributes.getQName(i);
                        String string2 = attributes.getValue(i);
                        stringBuffer.append(", " + string + "=" + string2);
                        if (string.equalsIgnoreCase("certFingerprint")) {
                            this.certFingerprint = string2;
                            continue;
                        }
                        if (string.equalsIgnoreCase("certSerialNumber")) {
                            this.certSerialNumber = string2;
                            continue;
                        }
                        throw new SecurityActivationInputException("Unknown attribute for element " + this.getShortName() + ": " + string);
                    }
                }

                public void evaluate() throws SecurityActivationInputException {
                    if (this.encryptedContent == null) {
                        throw new SecurityActivationInputException("Element logical validation error: " + this.getShortName() + " encryptedContent is missing");
                    }
                }
            }
        }

        public static class EncryptedContent
        extends StackElement {
            public String pBKDF2_salt = null;
            public String pBKDF2_iterationCount = null;

            protected void fetchAttributes(Attributes attributes) throws SecurityActivationInputException {
                int n = attributes.getLength();
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < n; ++i) {
                    String string = attributes.getQName(i);
                    String string2 = attributes.getValue(i);
                    stringBuffer.append(", " + string + "=" + string2);
                    if (string.equalsIgnoreCase("PBKDF2_salt")) {
                        this.pBKDF2_salt = string2;
                        continue;
                    }
                    if (string.equalsIgnoreCase("PBKDF2_iterationCount")) {
                        this.pBKDF2_iterationCount = string2;
                        continue;
                    }
                    throw new SecurityActivationInputException("Unknown attribute for element " + this.getShortName() + ": " + string);
                }
                if (this.pBKDF2_salt == null || this.pBKDF2_iterationCount == null) {
                    throw new SecurityActivationInputException("Illegal combination of attributes for element " + this.getShortName() + ": " + stringBuffer.toString());
                }
            }

            public void evaluate() throws SecurityActivationInputException {
                if (this.value == null) {
                    throw new SecurityActivationInputException("Element logical validation error: " + this.getShortName() + " encryptedContent is missing");
                }
            }
        }
    }
}

