/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.gui;

import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.nex.NexLog;
import se.ericsson.cello.nex.toolservices.StartFailureException;
import se.ericsson.cello.nex.toolservices.ToolServicesI;

public class NodeTime {
    public String timeString = "Loading...";
    private ToolServicesI toolServices = null;
    private TimeZone utcTimeZone;
    private Timer clockTimerNodeTime;
    private SimpleDateFormat timeFormatter;

    public NodeTime() {
    }

    public NodeTime(ToolServicesI aToolServices) {
        this.toolServices = aToolServices;
        this.initTimeZone();
        this.startTimer();
    }

    public void destroy() {
        if (null != this.clockTimerNodeTime) {
            this.clockTimerNodeTime.cancel();
        }
    }

    public String getTime() {
        return this.timeString;
    }

    private void fetchNodeTime() {
        if (null != this.toolServices && this.toolServices.isNodeServicesStarted()) {
            try {
                String tmpStr;
                Mo mo = this.toolServices.getNodeServices().getNode().getCmService().getMo("ManagedElement=1,ManagedElementData=1");
                NameValue nodeUTCTime = mo.getAttribute("nodeUTCTime", null);
                Object timeValue = nodeUTCTime.getValue();
                this.timeString = tmpStr = this.timeFormatter.format(timeValue) + " Z";
            }
            catch (StartFailureException e) {
                NexLog.logger().log(Level.WARNING, " NodeServices could not be started");
            }
            catch (Exception e) {
                NexLog.logger().log(Level.FINEST, " Node could be down, waiting for node to respond");
            }
        }
    }

    private void initTimeZone() {
        try {
            this.utcTimeZone = TimeZone.getTimeZone("GMT+00:00");
        }
        catch (Exception e) {
            NexLog.logger().info(" getTimeZone GMT+00:00 exception\n" + NexLog.stackToString(e));
        }
        this.timeFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        this.timeFormatter.setTimeZone(this.utcTimeZone);
    }

    private void startTimer() {
        final TimerTask task = new TimerTask(){

            public void run() {
                NodeTime.this.fetchNodeTime();
            }
        };
        Runnable starter = new Runnable(){

            public void run() {
                NodeTime.this.clockTimerNodeTime = new Timer();
                NodeTime.this.clockTimerNodeTime.schedule(task, 6000L, 20000L);
            }
        };
        new Thread(starter, "clockTimerNodeTime").start();
    }
}

