/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.gui.view;

import java.awt.Container;
import javax.swing.JLabel;
import javax.swing.JPanel;
import se.ericsson.cello.nex.gui.OwnerFrameI;
import se.ericsson.cello.nex.gui.view.NexTreeNode;
import se.ericsson.cello.nex.viewservices.model.ViewElementI;

public class MoNode
extends NexTreeNode {
    private static final String LDN = "LDN";
    private static final long serialVersionUID = -8957741094078932455L;
    private String longName = this.getViewElement().getLdn();
    private Container propContainer = new JPanel();

    public MoNode(ViewElementI aViewElement, boolean allowsChildren, OwnerFrameI anOwner) {
        super(aViewElement, allowsChildren, anOwner);
        this.propContainer.add(new JLabel("Here we will display the properties of this MO"));
    }

    public int compareTo(NexTreeNode o) {
        String otherName;
        NexTreeNode otherNode = o;
        if (otherNode.equals(this)) {
            return 0;
        }
        if (otherNode.isFolder()) {
            return 1;
        }
        String thisName = this.getName();
        if (thisName.equals(otherName = otherNode.getName())) {
            return this.compareLdns(this.getLongName(), otherNode.getLongName());
        }
        if (this.getViewElement().getMoClass().equals(otherNode.getViewElement().getMoClass())) {
            return this.compareLdns(this.getLongName(), otherNode.getLongName());
        }
        return thisName.compareTo(otherName);
    }

    public String getLongName() {
        return this.longName;
    }

    public Container getPropertiesContainer() {
        return this.propContainer;
    }

    public Object getValueAt(String columnName) {
        if (columnName.equals(LDN)) {
            return this.getLongName();
        }
        return this.getViewElement().getAttributeValue(columnName);
    }

    private int compareLdns(String firstLDN, String otherLDN) {
        try {
            int lastEqualSign = firstLDN.lastIndexOf("=");
            int lastCommaSign = firstLDN.lastIndexOf(",");
            String rdn = firstLDN.substring(lastCommaSign + 1);
            String moType = firstLDN.substring(lastCommaSign + 1, lastEqualSign);
            String id = firstLDN.substring(lastEqualSign + 1);
            int otherLastEqualSign = otherLDN.lastIndexOf("=");
            int otherLastCommaSign = otherLDN.lastIndexOf(",");
            String otherRdn = otherLDN.substring(lastCommaSign + 1);
            String otherMoType = otherLDN.substring(otherLastCommaSign + 1, otherLastEqualSign);
            String otherId = otherLDN.substring(otherLastEqualSign + 1);
            if (!moType.equals(otherMoType)) {
                return rdn.compareTo(otherRdn);
            }
            if (id.equals(otherId)) {
                if (-1 == lastCommaSign || -1 == otherLastCommaSign) {
                    return firstLDN.compareTo(otherLDN);
                }
                return this.compareLdns(firstLDN.substring(0, lastCommaSign), otherLDN.substring(0, otherLastCommaSign));
            }
            Integer thisNumber = new Integer(id);
            Integer otherNumber = new Integer(otherId);
            return thisNumber.compareTo(otherNumber);
        }
        catch (Exception exception) {
            return firstLDN.compareTo(otherLDN);
        }
    }
}

