/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.gui.view.workers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.tree.TreePath;
import se.ericsson.cello.nex.NexLog;
import se.ericsson.cello.nex.gui.view.MoTreeTableModel;
import se.ericsson.cello.nex.gui.view.NexTreeNode;
import se.ericsson.cello.nex.gui.view.workers.AddChildrenJob;
import se.ericsson.cello.nex.gui.view.workers.ModelCallback;
import se.ericsson.cello.nex.gui.view.workers.ModelWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefreshAllWorker
extends ModelWorker<Void, AddChildrenJob> {
    private ModelCallback<Collection<TreePath>> callback;
    private Enumeration<TreePath> oldPaths;
    private ArrayList<TreePath> paths = new ArrayList();
    private NexTreeNode root;

    public RefreshAllWorker(MoTreeTableModel model, Enumeration<TreePath> expanded, ModelCallback<Collection<TreePath>> cb) {
        super(model);
        this.root = (NexTreeNode)model.getRoot();
        this.oldPaths = expanded;
        this.callback = cb;
    }

    @Override
    protected Void doWork() throws Exception {
        ExpandNode expandTree = null;
        if (this.oldPaths != null) {
            expandTree = this.buildExpandTree(this.oldPaths);
        }
        this.root.refreshAttributes(this.getModel().getColumnNames());
        this.root.removeAllChildren();
        this.root.setPartiallyExpanded(false);
        this.root.setChildrenFetched(false);
        this.root.refreshHasChildren();
        if (expandTree != null) {
            this.expandToOldTree(this.root, expandTree);
        }
        return null;
    }

    private void expandToOldTree(NexTreeNode node, ExpandNode expandTree) {
        Collection<NexTreeNode> children = this.expand(node);
        if (children == null) {
            return;
        }
        for (ExpandNode expandChild : expandTree.children) {
            for (NexTreeNode child : children) {
                if (this.isCancelled()) {
                    return;
                }
                if (!child.getName().equals(expandChild.name)) continue;
                this.expandToOldTree(child, expandChild);
            }
        }
    }

    private ExpandNode buildExpandTree(Enumeration<TreePath> paths) {
        ExpandNode expandRoot = null;
        if (paths.hasMoreElements()) {
            expandRoot = new ExpandNode(paths.nextElement());
            while (paths.hasMoreElements()) {
                expandRoot.insertPath(paths.nextElement(), 1);
            }
        }
        return expandRoot;
    }

    private Collection<NexTreeNode> expand(NexTreeNode node) {
        try {
            List<NexTreeNode> children = this.createChildNodesFor(node);
            this.publish(new AddChildrenJob[]{new AddChildrenJob(node, children)});
            return children;
        }
        catch (Exception e) {
            NexLog.logger().warning("Exception when creating children for node " + node.getName() + "\n" + e);
            return null;
        }
    }

    protected void process(List<AddChildrenJob> jobs) {
        for (AddChildrenJob job : jobs) {
            try {
                this.replaceAllChildren(job.getParent(), job.getChildren());
                this.paths.add(new TreePath(job.getParent().getPath()));
            }
            catch (Exception e) {
                NexLog.logger().warning("Exception caught in RefreshAllWorker.process() \n" + NexLog.stackToString(e));
            }
        }
    }

    protected void done() {
        block4: {
            try {
                this.get();
            }
            catch (CancellationException e) {
            }
            catch (Exception e) {
                NexLog.logger().warning("Exception caught in RefreshAllWorker.done() \n" + NexLog.stackToString(e));
                if (this.callback == null) break block4;
                this.callback.setException(e);
            }
        }
        this.getModel().nodeStructureChanged(this.root);
        if (this.callback != null) {
            this.callback.run(this.paths, this.isCancelled());
        }
    }

    public String toString() {
        return "Refreshing all nodes below " + this.root.getLongName() + ".";
    }

    private class ExpandNode {
        public String name;
        public LinkedList<ExpandNode> children = new LinkedList();

        public ExpandNode(String name) {
            this.name = name;
        }

        public ExpandNode(TreePath path) {
            this(path.getPathComponent(0).toString());
            this.insertPath(path, 1);
        }

        public void insertPath(TreePath path, int level) {
            if (path.getPathCount() <= level) {
                return;
            }
            String component = path.getPathComponent(level).toString();
            for (ExpandNode child : this.children) {
                if (!child.name.equals(component)) continue;
                child.insertPath(path, level + 1);
                return;
            }
            ExpandNode child = new ExpandNode(component);
            this.children.add(child);
            child.insertPath(path, level + 1);
        }
    }
}

