/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.gui.view.workers;

import java.util.Collection;
import java.util.concurrent.CancellationException;
import se.ericsson.cello.nex.NexLog;
import se.ericsson.cello.nex.gui.view.MoTreeTableModel;
import se.ericsson.cello.nex.gui.view.NexTreeNode;
import se.ericsson.cello.nex.gui.view.workers.ModelCallback;
import se.ericsson.cello.nex.gui.view.workers.ModelWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateNodesWorker
extends ModelWorker<Void, Object> {
    private Collection<NexTreeNode> nodes;
    private Collection<String> attributes;
    private ModelCallback<Void> callback;

    public UpdateNodesWorker(MoTreeTableModel model, Collection<NexTreeNode> nodes, Collection<String> attributes, ModelCallback<Void> callback) {
        super(model);
        this.nodes = nodes;
        this.callback = callback;
        this.attributes = attributes;
    }

    @Override
    protected Void doWork() throws Exception {
        int refreshed = 0;
        String[] attrs = this.attributes.toArray(new String[0]);
        for (NexTreeNode node : this.nodes) {
            this.updateProgress((int)((float)refreshed++ / (float)this.nodes.size() * 100.0f));
            if (this.isCancelled()) break;
            node.refreshAttributes(attrs);
        }
        return null;
    }

    protected void done() {
        block4: {
            try {
                this.get();
            }
            catch (CancellationException c) {
            }
            catch (Exception e) {
                NexLog.logger().warning("Exception caught in UpdateNodesWorker.done() \n" + NexLog.stackToString(e));
                if (this.callback == null) break block4;
                this.callback.setException(e);
            }
        }
        if (this.callback != null) {
            this.callback.run(null, this.isCancelled());
        }
    }

    public String toString() {
        return "Refreshing attributes of " + this.nodes.size() + " nodes.";
    }
}

