/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.alarmlist.controller.impl;

import se.ericsson.cello.em.fm.alarmlist.controller.impl.AlarmListController;
import se.ericsson.cello.neal.Node;
import se.ericsson.cello.neal.fm.Alarm;
import se.ericsson.cello.neal.fm.Event;
import se.ericsson.cello.neal.fm.FmNotificationConsumer;
import se.ericsson.cello.neal.fm.FmService;
import se.ericsson.cello.neal.fm.FmSubscription;
import se.ericsson.security.utils.EmLogger;

public class AlarmListener
implements FmNotificationConsumer {
    private static final EmLogger LOG = EmLogger.TROUBLE_SHOOTING;
    private AlarmListController alarmListController;
    private FmSubscription fmSubscription;
    private FmService fmService;

    AlarmListener(AlarmListController alarmListController, FmService fmService) {
        this.alarmListController = alarmListController;
        this.fmService = fmService;
    }

    public void startListening() {
        LOG.info("Start listening for alarm notifications.", new Object[0]);
        this.createSubscription();
    }

    public void stopListening() {
        LOG.info("Stop listening for alarm notifications.", new Object[0]);
        this.fmSubscription.cancel();
        this.fmSubscription = null;
    }

    public void alarmListRebuilt(Node node) {
        LOG.info("Rebuild the alarm list.", new Object[0]);
        this.alarmListController.rebuildAlarmList();
    }

    public void notifyAckStateChanged(Alarm alarm) {
        LOG.info("Alarm (" + alarm.getAlarmId() + ") has been acknowledged or unacknowledged.", new Object[0]);
    }

    public void notifyChangedAlarm(Alarm alarm) {
        LOG.info("Alarm (" + alarm.getAlarmId() + ") has changed.", new Object[0]);
        this.alarmListController.updateAlarm(alarm);
    }

    public void notifyClearedAlarm(Alarm alarm) {
        LOG.info("Alarm (" + alarm.getAlarmId() + ") has been cleared.", new Object[0]);
        this.alarmListController.removeAlarm(alarm);
    }

    public void notifyDisconnected() {
    }

    public void notifyEvent(Event event) {
    }

    public void notifyNewAlarm(Alarm alarm) {
        LOG.info("New alarm (" + alarm.getAlarmId() + ").", new Object[0]);
        this.alarmListController.addAlarm(alarm);
    }

    public void notifySubscriptionLost() {
        LOG.info("Alarm notification subscription has been lost.", new Object[0]);
        this.alarmListController.rebuildAlarmList();
        this.createSubscription();
    }

    private void createSubscription() {
        this.fmSubscription = this.fmService.subscribe((FmNotificationConsumer)this);
    }
}

