/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.availability.view.impl;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import se.ericsson.cello.em.fm.availability.AvailabilityLog;
import se.ericsson.cello.em.fm.availability.view.impl.LogToolView;
import se.ericsson.cello.em.fm.availability.view.impl.SftpFileFetcherEm;
import se.ericsson.cello.em.fm.common.controller.ifc.LogToolController;
import se.ericsson.cello.em.fm.common.factory.impl.LogToolModelFactory;
import se.ericsson.cello.em.fm.common.model.ifc.LogTableModel;
import se.ericsson.cello.em.fm.common.utils.ifc.FileFetcher;
import se.ericsson.cello.em.fm.common.utils.impl.FmType;
import se.ericsson.cello.em.fm.common.utils.impl.LocalFileFetcher;
import se.ericsson.cello.em.fm.common.view.ifc.FileFetcherListener;
import se.ericsson.cello.emt.sshsftpservice.SshSftpService;
import se.ericsson.cello.emt.utils.guihelper.MessageDialog;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogFactory;
import se.ericsson.cello.emt.utils.guitestsupport.GuiTestEventTypes;
import se.ericsson.cello.emt.utils.launchhandler.LaunchHandler;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherException;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.security.utils.EmLogger;

public class AvailLogToolController
implements FileFetcherListener,
LogToolController {
    private static final EmLogger LOG = EmLogger.TROUBLE_SHOOTING;
    private static final String TOOL_ICON = "TOOL_ICON";
    private static final String OPEN_LOG_FILE = "OPEN_LOG_FILE";
    private static final String AVAILABILITYLOG_CONFIG = "AVAILABILITYLOG_CONFIG";
    private static final String SUPERSEDING_PARAMETER_LIST = "SUPERSEDING_PARAMETER_LIST";
    private static final String ELEMENT_MANAGER = "Element Manager";
    private static final String SECTION_TAG = "NodeLogTool";
    private static final String AVAILABILITYLOG_NAME = "AVAILABILITYLOG_NAME";
    private static final String ADDRESS = "address";
    private static final String HTTP_PORT = "httpPort";
    private static final String SSH_SFTP_SERV_CONFIG_KEY = "SSHSERVICE_CONFIG";
    private LogToolView logToolView = null;
    private Properties properties;
    private LauncherInterface launcher;
    private Launchable availLaunchable;
    private int nProgress = 0;
    private int nProgressMin = 0;
    private int nProgressMax = 10;
    private Map<Thread, ProgressMonitor> myProgressMonitorMap = new HashMap<Thread, ProgressMonitor>();

    public AvailLogToolController(Properties properties, LauncherInterface launcher, Launchable availLaunchable) {
        this.properties = properties;
        this.launcher = launcher;
        this.availLaunchable = availLaunchable;
    }

    public void init() {
        this.initView();
        LogTableModel dummyModel = this.createModel();
        this.logToolView.setModel(dummyModel);
        this.startNewProgressMonitor("Get log file", "");
        LogTableModel modelToPopulate = this.createModel();
        this.populateModelFromLog(modelToPopulate);
        if (!this.progressMonitorIsCanceled()) {
            this.logToolView.setModel(modelToPopulate);
        }
        this.progressMonitorDone();
        if (this.availLaunchable instanceof AvailabilityLog) {
            ((AvailabilityLog)this.availLaunchable).sendEmNotification(GuiTestEventTypes.AVAILABILITYLOG_UPDATED, null, this);
        }
    }

    public void bringGuiToFront() {
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.getFrame().getState() == 1) {
                this.getFrame().setState(0);
            }
            this.getFrame().toFront();
            this.getFrame().requestFocus();
        } else {
            Runnable frontRunnable = new Runnable(){

                public void run() {
                    AvailLogToolController.this.bringGuiToFront();
                }
            };
            SwingUtilities.invokeLater(frontRunnable);
        }
    }

    public void rowSelected() {
    }

    private void populateModelFromLog(LogTableModel model) {
        FileFetcher fileFetcher = this.createFileFetcher();
        if (null != fileFetcher) {
            InputStream fileInputStream = fileFetcher.getFileInputStream();
            if (fileInputStream != null && !this.progressMonitorIsCanceled()) {
                this.populateModelWithFileStream(model, fileInputStream);
            } else {
                LOG.info("fileInputStream was null, starting with empty model.", new Object[0]);
            }
            fileFetcher.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startNewProgressMonitor(final String message, final String note) {
        Map<Thread, ProgressMonitor> map = this.myProgressMonitorMap;
        synchronized (map) {
            this.swingUtilInvokeAndWait(new Runnable(){

                public void run() {
                    AvailLogToolController.this.logToolView.createProgressMonitor(message, note, AvailLogToolController.this.nProgressMin, AvailLogToolController.this.nProgressMax);
                    if (System.getProperty("ARTH", "false").equals("true")) {
                        AvailLogToolController.this.logToolView.getProgressMonitor().setMillisToPopup(0);
                        AvailLogToolController.this.logToolView.getProgressMonitor().setMillisToDecideToPopup(0);
                    }
                }
            });
            this.myProgressMonitorMap.put(Thread.currentThread(), this.logToolView.getProgressMonitor());
            this.nProgress = 0;
        }
    }

    private boolean progressMonitorIsCanceled() {
        ProgressMonitor progressMonitor = this.myProgressMonitorMap.get(Thread.currentThread());
        boolean isCanceled = false;
        isCanceled = progressMonitor != null ? progressMonitor.isCanceled() : true;
        return isCanceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void progressMonitorDone() {
        Map<Thread, ProgressMonitor> map = this.myProgressMonitorMap;
        synchronized (map) {
            ProgressMonitor progressMonitor = this.myProgressMonitorMap.get(Thread.currentThread());
            if (progressMonitor != null) {
                progressMonitor.setProgress(this.nProgressMax + 1);
                progressMonitor.close();
                this.myProgressMonitorMap.remove(Thread.currentThread());
            }
        }
    }

    private LogTableModel createModel() {
        return LogToolModelFactory.INSTANCE.createLogToolModel(FmType.AVAILABILITY);
    }

    private FileFetcher createFileFetcher() {
        String filePath = this.properties.getProperty(OPEN_LOG_FILE);
        FileFetcher fileFetcher = null;
        fileFetcher = filePath == null ? this.launchSshSftService() : new LocalFileFetcher(filePath, this);
        return fileFetcher;
    }

    private FileFetcher launchSshSftService() {
        SshSftpService ss;
        if (System.getProperty("ARTH", "false").equals("true")) {
            LOG.info("Will use SEMLA sftp services...", new Object[0]);
            ss = this.getSshSftpServiceStub();
        } else {
            Properties propsToSendOn = this.getSuperseedingProps(this.properties);
            String sshserviceConfig = this.getSshSftpCfg();
            LOG.info("About to launch SshSftp service with the config file: " + sshserviceConfig + " from availability...", new Object[0]);
            try {
                ss = (SshSftpService)this.launcher.runResource(sshserviceConfig, this.getHostAndPortString(), propsToSendOn, this.availLaunchable);
            }
            catch (LauncherException e) {
                LOG.severe("Failed to launch SshSftp service with the config file: \n" + sshserviceConfig + " from availability. \n" + "Reason: " + e.getMessage(), new Object[0]);
                this.showError("Failed getting the log file from the node.", "The EM SSH SFTP Service could not be started.", (Exception)((Object)e), true);
                return null;
            }
            LOG.info("Success to launch SshSftp service with the config file: " + sshserviceConfig + " from availability.", new Object[0]);
        }
        return new SftpFileFetcherEm(ss, this, this.properties.getProperty(AVAILABILITYLOG_NAME, "Availability Log"));
    }

    private SshSftpService getSshSftpServiceStub() {
        try {
            Class<?> clazz = Class.forName("se.ericsson.cello.mibparser.sshstub.SshSftpServiceStub");
            Constructor<?> constructor = clazz.getConstructor(null);
            Object obj = constructor.newInstance(null);
            SshSftpService stubStarter = (SshSftpService)obj;
            return stubStarter;
        }
        catch (Throwable t) {
            LOG.fine("No valid SshSftpService present. Got " + t, new Object[0]);
            return null;
        }
    }

    private String getSshSftpCfg() {
        String sshserviceConfig = this.properties.getProperty(SSH_SFTP_SERV_CONFIG_KEY, "");
        if (sshserviceConfig.equals("")) {
            LOG.warning("Did not get property SSHSERVICE_CONFIG. Will try with /cello/emas/sshservcfg.xml", new Object[0]);
            sshserviceConfig = "/cello/emas/sshservcfg.xml";
        }
        return sshserviceConfig;
    }

    private void populateModelWithFileStream(LogTableModel model, InputStream fileInputStream) {
        this.updateProgress("Parsing file...");
        try {
            model.setInputStreamToModel(fileInputStream);
        }
        catch (IOException ioe) {
            this.showError("Failed displaying the log.", "An Exception occured while reading the log file.", ioe, false);
        }
        catch (ParserConfigurationException pce) {
            this.showError("Failed displaying the log.", "The parsing of the log file failed.", pce, false);
        }
        catch (SAXException se) {
            this.showError("Failed displaying the log.", "Unsuccessful parsing of the log file.", se, false);
        }
    }

    private String createTitle(Properties props) {
        String filePath;
        StringBuilder title = new StringBuilder();
        title.append(this.getHostAddress() + " - ");
        String prop = props.getProperty("MANAGER_TITLE", null);
        if (prop != null) {
            title.append(prop + " - ");
        }
        if ((prop = props.getProperty(AVAILABILITYLOG_NAME, null)) != null) {
            title.append(prop);
        }
        if ((filePath = props.getProperty(OPEN_LOG_FILE, null)) != null) {
            int index = filePath.lastIndexOf(System.getProperty("file.separator", null));
            if (index > 0 && index + 1 < filePath.length()) {
                filePath = filePath.substring(index + 1);
            }
            title.append(" - " + filePath);
        }
        return title.toString();
    }

    private void initView() {
        this.swingUtilInvokeAndWait(new Runnable(){

            public void run() {
                String icon = AvailLogToolController.this.properties.getProperty(AvailLogToolController.TOOL_ICON);
                String title = AvailLogToolController.this.createTitle(AvailLogToolController.this.properties);
                AvailLogToolController.this.logToolView = new LogToolView(title, icon);
                AvailLogToolController.this.logToolView.setRefreshListener(new RefreshListener());
                AvailLogToolController.this.logToolView.setCloseListener(new CloseListener());
                AvailLogToolController.this.logToolView.setExitListenerMenu(new CloseListener());
                AvailLogToolController.this.logToolView.setWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        AvailLogToolController.this.close();
                    }
                });
                AvailLogToolController.this.logToolView.setOpenListener(new OpenListener());
                AvailLogToolController.this.logToolView.setHelpListener(new HelpListener());
            }
        });
    }

    public JFrame getFrame() {
        return this.logToolView.getComponent();
    }

    private void swingUtilInvokeAndWait(Runnable runnable) {
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (InterruptedException e) {
            this.showError("Internal SW error.", "", e, false);
        }
        catch (InvocationTargetException e1) {
            this.showError("Internal SW error.", "", e1, false);
        }
    }

    private void close() {
        this.logToolView.clearAllListenerNow();
        this.logToolView.getComponent().dispose();
        this.availLaunchable.exit();
    }

    protected Properties getSuperseedingProps(Properties props) {
        Properties newProps = new Properties();
        String superSeedingProps = props.getProperty(SUPERSEDING_PARAMETER_LIST);
        if (superSeedingProps != null) {
            String[] items = superSeedingProps.split(";");
            for (int i = 0; i > items.length; ++i) {
                newProps.setProperty(items[i], props.getProperty(items[i]));
            }
        }
        return newProps;
    }

    public boolean isCanceled() {
        return this.progressMonitorIsCanceled();
    }

    public void showError(final String mainMessage, final String specificMessage, final Exception exception, final boolean severe) {
        if (!SwingUtilities.isEventDispatchThread()) {
            Runnable runner = new Runnable(){

                public void run() {
                    AvailLogToolController.this.showError(mainMessage, specificMessage, exception, severe);
                }
            };
            SwingUtilities.invokeLater(runner);
            return;
        }
        MessageDialog msgDlg = MessageDialogFactory.createMessageDialog((String)mainMessage, (String)specificMessage, (Exception)exception, (boolean)severe, (JFrame)this.getFrame());
        if (null != msgDlg) {
            msgDlg.setVisible(true);
        }
    }

    public void showModalMessage(final String message) {
        this.swingUtilInvokeAndWait(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(AvailLogToolController.this.logToolView.getComponent(), message);
            }
        });
    }

    public void updateProgress(String note) {
        ProgressMonitor progressMonitor = this.myProgressMonitorMap.get(Thread.currentThread());
        if (progressMonitor != null) {
            progressMonitor.setNote(note);
            progressMonitor.setProgress(++this.nProgress);
        }
    }

    public void endProgress() {
        this.progressMonitorDone();
    }

    private String getHostAndPortString() {
        StringBuilder sb = new StringBuilder(20);
        sb.append(this.getHostAddress());
        sb.append(":");
        sb.append(this.properties.getProperty(HTTP_PORT));
        return sb.toString();
    }

    private String getHostAddress() {
        return this.properties.getProperty(ADDRESS, "");
    }

    class HelpListener
    implements ActionListener {
        HelpListener() {
        }

        public void actionPerformed(ActionEvent e) {
            this.launchHelpTool();
        }

        private void launchHelpTool() {
            String helpCfg = this.getHelpCfg();
            Properties newProps = AvailLogToolController.this.getSuperseedingProps(AvailLogToolController.this.properties);
            newProps.setProperty("DOC_TITLE", AvailLogToolController.ELEMENT_MANAGER);
            newProps.setProperty("SECTION_TAG", AvailLogToolController.SECTION_TAG);
            LaunchHandler.launchToolAsResource((LauncherInterface)AvailLogToolController.this.launcher, (String)helpCfg, (String)AvailLogToolController.this.getHostAndPortString(), (Properties)newProps, null);
        }

        private String getHelpCfg() {
            String myHelpCfg = AvailLogToolController.this.properties.getProperty("HELPSERVICE_CONFIG", "");
            if (myHelpCfg.equals("")) {
                LOG.warning("Did not get property HELPSERVICE_CONFIG. Will try with /cello/emas/helpservcfg.xml", new Object[0]);
                myHelpCfg = "/cello/emas/helpservcfg.xml";
            }
            return myHelpCfg;
        }
    }

    public class OpenListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            JFileChooser dia = new JFileChooser();
            int returnValue = dia.showOpenDialog(null);
            if (returnValue == 0) {
                this.launchNewTool(dia.getSelectedFile());
            }
        }

        private void launchNewTool(File selectedFile) {
            String availCfg = AvailLogToolController.this.properties.getProperty(AvailLogToolController.AVAILABILITYLOG_CONFIG, "");
            if (availCfg.equals("")) {
                LOG.warning("Did not get property AVAILABILITYLOG_CONFIG. Will try with /cello/emas/availlogcfg.xml", new Object[0]);
                availCfg = "/cello/emas/availlogcfg.xml";
            }
            Properties newProps = AvailLogToolController.this.getSuperseedingProps(AvailLogToolController.this.properties);
            newProps.put(AvailLogToolController.OPEN_LOG_FILE, selectedFile.getAbsolutePath());
            LaunchHandler.launchTool((LauncherInterface)AvailLogToolController.this.launcher, (String)availCfg, (String)AvailLogToolController.this.getHostAndPortString(), (Properties)newProps, null);
        }
    }

    class CloseListener
    implements ActionListener {
        CloseListener() {
        }

        public void actionPerformed(ActionEvent e) {
            AvailLogToolController.this.close();
        }
    }

    class RefreshListener
    implements ActionListener {
        RefreshListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Thread refresher = new Thread(new Runnable(){

                public void run() {
                    AvailLogToolController.this.startNewProgressMonitor("Get log file", "");
                    LogTableModel modelToPopulate = AvailLogToolController.this.createModel();
                    AvailLogToolController.this.populateModelFromLog(modelToPopulate);
                    if (!AvailLogToolController.this.progressMonitorIsCanceled()) {
                        AvailLogToolController.this.logToolView.setModel(modelToPopulate);
                    }
                    AvailLogToolController.this.progressMonitorDone();
                }
            }, "refresher");
            refresher.start();
        }
    }
}

