/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.common.details.controller.impl;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import se.ericsson.cello.em.fm.common.details.view.impl.DetailsView;
import se.ericsson.cello.em.fm.common.model.ifc.SelectedObjectInterface;
import se.ericsson.cello.em.fm.common.model.impl.AdditionalInformation;
import se.ericsson.cello.em.fm.common.model.impl.CorrelatedNotification;
import se.ericsson.cello.em.fm.common.model.impl.RecordContent;
import se.ericsson.cello.em.fm.common.utils.ifc.ToolService;
import se.ericsson.cello.em.fm.common.utils.impl.FmType;
import se.ericsson.cello.em.fm.common.utils.impl.LogPart;
import se.ericsson.cello.em.fm.common.view.impl.AbstractActions;

public class DetailsController {
    private static final String HTML_START = "<html>";
    private static final String HTML_END = "</html>";
    private static final String TABLE_START = "<table border=0>";
    private static final String TABLE_END = "</table";
    private static final String ROW_START = "<tr>";
    private static final String ROW_END = "</tr>";
    private static final String HEADER_CELL_START = "<th valign=top align=left nowrap><font face=Ariel size=-1>";
    private static final String HEADER_CELL_END = "</font></th>";
    private static final String DATA_CELL_START = "<td valign=top><font face=Ariel size=-1>";
    private static final String DATA_CELL_END = "</font></td>";
    private static Dimension storedSize = null;
    private static Point storedLocation = null;
    private SelectedObjectInterface parentController;
    private DetailsView view;
    private FmType logType;
    private ToolService toolService;

    public DetailsController(FmType logType, SelectedObjectInterface parentController, ToolService toolService) {
        this.parentController = parentController;
        this.logType = logType;
        this.toolService = toolService;
    }

    public void createView() {
        SwingUtilities.invokeLater(new GuiThread(Action.CREATE_VIEW));
    }

    public void refreshView() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.addContent();
            this.view.bringToFront();
        } else {
            SwingUtilities.invokeLater(new GuiThread(Action.REFRESH_VIEW));
        }
    }

    public void exit() {
        if (SwingUtilities.isEventDispatchThread()) {
            storedSize = this.view.getSize();
            storedLocation = this.view.getLocation();
            this.view.disposeWindow();
            this.view = null;
            this.parentController.disposeDetailWindow();
        } else {
            SwingUtilities.invokeLater(new GuiThread(Action.EXIT));
        }
    }

    private void addContent() {
        RecordContent row = this.parentController.getSelectedObject();
        StringBuffer strBuf = new StringBuffer();
        strBuf.append(HTML_START);
        strBuf.append(TABLE_START);
        TreeSet<LogPart> tmpDetails = LogPart.getDetails(this.logType);
        block4: for (LogPart part : tmpDetails) {
            switch (part) {
                case CORRELATED_NOTIFICATIONS: {
                    this.addCorrelatedNotifications(strBuf, part, row);
                    continue block4;
                }
                case ADDITIONAL_INFORMATION: {
                    this.addAdditionalInformation(strBuf, part, row);
                    continue block4;
                }
            }
            this.addOtherInformation(row, strBuf, part);
        }
        strBuf.append(TABLE_END);
        strBuf.append(HTML_END);
        this.view.showContent(strBuf.toString());
    }

    private void addOtherInformation(RecordContent row, StringBuffer strBuf, LogPart part) {
        strBuf.append(ROW_START);
        strBuf.append(HEADER_CELL_START);
        strBuf.append(part.DETAILS_TITLE);
        strBuf.append(": ");
        strBuf.append(HEADER_CELL_END);
        strBuf.append(DATA_CELL_START);
        strBuf.append(row.get((Object)part));
        strBuf.append(DATA_CELL_END);
        strBuf.append(ROW_END);
    }

    private void addAdditionalInformation(StringBuffer strBuf, LogPart part, RecordContent row) {
        List additionalInformations = (List)row.get((Object)part);
        strBuf.append(ROW_START);
        strBuf.append(HEADER_CELL_START);
        strBuf.append(part.DETAILS_TITLE);
        strBuf.append(": ");
        strBuf.append(HEADER_CELL_END);
        strBuf.append(DATA_CELL_START);
        strBuf.append("<dl>");
        for (int i = 0; i < additionalInformations.size(); ++i) {
            strBuf.append("<dt>");
            strBuf.append(((AdditionalInformation)additionalInformations.get(i)).getType());
            strBuf.append(": ");
            strBuf.append("</dt>");
            strBuf.append("<dd>");
            strBuf.append(((AdditionalInformation)additionalInformations.get(i)).getValue());
            strBuf.append("</dd>");
        }
        strBuf.append("</dl>");
        strBuf.append(DATA_CELL_END);
        strBuf.append(ROW_END);
    }

    private void addCorrelatedNotifications(StringBuffer strBuf, LogPart part, RecordContent row) {
        List correlatedNotifications = (List)row.get((Object)part);
        strBuf.append(ROW_START);
        strBuf.append(HEADER_CELL_START);
        strBuf.append(part.DETAILS_TITLE);
        strBuf.append(": ");
        strBuf.append(HEADER_CELL_END);
        strBuf.append(DATA_CELL_START);
        strBuf.append("<dl>");
        for (int i = 0; i < correlatedNotifications.size(); ++i) {
            strBuf.append("<dt>");
            strBuf.append(LogPart.MANAGED_OBJECT_INSTANCE.DETAILS_TITLE);
            strBuf.append(": ");
            strBuf.append(((CorrelatedNotification)correlatedNotifications.get(i)).getMoi());
            strBuf.append("</dt>");
            strBuf.append("<dd>");
            strBuf.append(LogPart.NOTIFICATION_ID.DETAILS_TITLE);
            strBuf.append(((CorrelatedNotification)correlatedNotifications.get(i)).getNotificationId());
            strBuf.append("</dd>");
        }
        strBuf.append("</dl>");
        strBuf.append(DATA_CELL_END);
        strBuf.append(ROW_END);
    }

    class HelpOnWindowAction
    extends AbstractActions.AbstractHelpOnWindowAction {
        private static final long serialVersionUID = 1L;

        HelpOnWindowAction() {
        }

        public void actionPerformed(ActionEvent e) {
            DetailsController.this.toolService.displayAlexHelp("Element Manager", "AlarmAndEventDetails");
        }
    }

    class CopyAction
    extends AbstractActions.AbstractCopyAction {
        private static final long serialVersionUID = 1L;

        CopyAction() {
        }

        public void actionPerformed(ActionEvent event) {
            String clipText = DetailsController.this.view.getSelectedText();
            StringSelection ss = new StringSelection(clipText);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, ss);
        }
    }

    class CloseAction
    extends AbstractActions.AbstractCloseAction {
        private static final long serialVersionUID = 1L;

        CloseAction() {
        }

        public void actionPerformed(ActionEvent event) {
            DetailsController.this.exit();
        }
    }

    class TextAreaMouseListener
    extends MouseAdapter {
        TextAreaMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 4) == 4) {
                String selectedText = DetailsController.this.view.getSelectedText();
                if (selectedText == null || selectedText.equals("")) {
                    DetailsController.this.view.enableCopyPopupMenu(false);
                } else {
                    DetailsController.this.view.enableCopyPopupMenu(true);
                }
                DetailsController.this.view.showCopyPopupMenu(mouseEvent);
            }
        }
    }

    class WindowClosingListener
    extends WindowAdapter {
        WindowClosingListener() {
        }

        public void windowClosing(WindowEvent e) {
            DetailsController.this.exit();
        }
    }

    class GuiThread
    implements Runnable {
        private Action action;

        GuiThread(Action action) {
            this.action = action;
        }

        public void run() {
            switch (this.action) {
                case CREATE_VIEW: {
                    DetailsController.this.view = new DetailsView(DetailsController.this.toolService, storedLocation, storedSize);
                    DetailsController.this.view.layoutWindow(DetailsController.this.parentController.getView());
                    DetailsController.this.view.addTextAreaMouseListener(new TextAreaMouseListener());
                    DetailsController.this.view.addCloseAction(new CloseAction());
                    DetailsController.this.view.addCopyAction(new CopyAction());
                    DetailsController.this.view.addHelpAction(new HelpOnWindowAction());
                    DetailsController.this.view.addWindowClosingListener(new WindowClosingListener());
                    DetailsController.this.addContent();
                    break;
                }
                case REFRESH_VIEW: {
                    DetailsController.this.refreshView();
                    break;
                }
                case EXIT: {
                    DetailsController.this.exit();
                    break;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Action {
        CREATE_VIEW,
        REFRESH_VIEW,
        EXIT;

    }
}

