/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.common.factory.impl;

import java.util.Properties;
import se.ericsson.cello.em.fm.alarmlist.config.impl.AlarmListConfiguration;
import se.ericsson.cello.em.fm.alarmlist.controller.impl.AlarmListController;
import se.ericsson.cello.em.fm.alarmlog.config.impl.AlarmLogConfiguration;
import se.ericsson.cello.em.fm.alarmlog.controller.impl.AlarmLogController;
import se.ericsson.cello.em.fm.availability.view.impl.AvailLogToolController;
import se.ericsson.cello.em.fm.common.controller.ifc.ToolController;
import se.ericsson.cello.em.fm.common.utils.impl.FmToolService;
import se.ericsson.cello.em.fm.common.utils.impl.FmType;
import se.ericsson.cello.em.fm.eventlog.config.impl.EventLogConfiguration;
import se.ericsson.cello.em.fm.eventlog.controller.impl.EventLogController;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ToolFactory {
    INSTANCE;


    public ToolController createToolController(FmType logType, Properties properties, LauncherInterface launcher, Launchable launchable) {
        ToolController controller;
        switch (logType) {
            case ALARM_LIST: {
                AlarmListConfiguration config = new AlarmListConfiguration(properties);
                FmToolService toolService = new FmToolService(launchable, launcher, config);
                controller = new AlarmListController(launchable, toolService);
                break;
            }
            case ALARM_LOG: {
                AlarmLogConfiguration logConfig = new AlarmLogConfiguration(properties);
                FmToolService toolService = new FmToolService(launchable, launcher, logConfig);
                controller = new AlarmLogController(launchable, toolService, logConfig);
                break;
            }
            case EVENT: {
                EventLogConfiguration logConfig = new EventLogConfiguration(properties);
                FmToolService toolService = new FmToolService(launchable, launcher, logConfig);
                controller = new EventLogController(launchable, toolService, logConfig);
                break;
            }
            case AVAILABILITY: {
                controller = new AvailLogToolController(properties, launcher, launchable);
                break;
            }
            default: {
                controller = null;
            }
        }
        return controller;
    }
}

