/*
 * Decompiled with CFR 0.152.
 */
package enea.ose.io;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SignalInputStream
extends FilterInputStream {
    public static final boolean BIG_ENDIAN = true;
    public static final boolean LITTLE_ENDIAN = false;
    private static boolean hostEndian;
    public static int alignment64bit;
    protected int readpos = 4;
    protected int markpos;
    protected boolean bigEndian;

    public SignalInputStream(InputStream inputStream) {
        super(inputStream);
        this.bigEndian = hostEndian;
    }

    public SignalInputStream(InputStream inputStream, boolean bl) {
        super(inputStream);
        this.bigEndian = bl;
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (n != -1) {
            ++this.readpos;
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.in.read(byArray, 0, byArray.length);
        if (n > 0) {
            this.readpos += n;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 > 0) {
            this.readpos += n3;
        }
        return n3;
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        for (int i = 0; i < n2; i += n3) {
            n3 = this.in.read(byArray, n + i, n2 - i);
            if (n3 >= 0) continue;
            throw new EOFException();
        }
        this.readpos += n2;
    }

    public byte readS8() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException();
        }
        ++this.readpos;
        return (byte)n;
    }

    public int readU8() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException();
        }
        ++this.readpos;
        return n;
    }

    public short readS16() throws IOException {
        this.align(2);
        int n = this.in.read();
        int n2 = this.in.read();
        if ((n | n2) < 0) {
            throw new EOFException();
        }
        this.readpos += 2;
        short s = this.bigEndian ? (short)((n << 8) + (n2 << 0)) : (short)((n << 0) + (n2 << 8));
        return s;
    }

    public int readU16() throws IOException {
        this.align(2);
        int n = this.in.read();
        int n2 = this.in.read();
        if ((n | n2) < 0) {
            throw new EOFException();
        }
        this.readpos += 2;
        int n3 = this.bigEndian ? (n << 8) + (n2 << 0) : (n << 0) + (n2 << 8);
        return n3;
    }

    public int readS32() throws IOException {
        this.align(4);
        int n = this.in.read();
        int n2 = this.in.read();
        int n3 = this.in.read();
        int n4 = this.in.read();
        if ((n | n2 | n3 | n4) < 0) {
            throw new EOFException();
        }
        this.readpos += 4;
        int n5 = this.bigEndian ? (n << 24) + (n2 << 16) + (n3 << 8) + (n4 << 0) : (n << 0) + (n2 << 8) + (n3 << 16) + (n4 << 24);
        return n5;
    }

    public long readU32() throws IOException {
        return (long)this.readS32() & 0xFFFFFFFFL;
    }

    public long readS64() throws IOException {
        long l;
        this.align(alignment64bit);
        int n = this.in.read();
        int n2 = this.in.read();
        int n3 = this.in.read();
        int n4 = this.in.read();
        int n5 = this.in.read();
        int n6 = this.in.read();
        int n7 = this.in.read();
        int n8 = this.in.read();
        if ((n | n2 | n3 | n4 | n5 | n6 | n7 | n8) < 0) {
            throw new EOFException();
        }
        this.readpos += 8;
        if (this.bigEndian) {
            l = (long)n << 56;
            l |= (long)n2 << 48;
            l |= (long)n3 << 40;
            l |= (long)n4 << 32;
            l |= (long)n5 << 24;
            l |= (long)n6 << 16;
            l |= (long)n7 << 8;
            l |= (long)n8;
        } else {
            l = (long)n << 0;
            l |= (long)n2 << 8;
            l |= (long)n3 << 16;
            l |= (long)n4 << 24;
            l |= (long)n5 << 32;
            l |= (long)n6 << 40;
            l |= (long)n7 << 48;
            l |= (long)n8 << 56;
        }
        return l;
    }

    public byte[] readS8Array(int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = this.in.read(byArray, 0, n);
        if (n2 < 0) {
            throw new EOFException();
        }
        this.readpos += n2;
        return byArray;
    }

    public int[] readU8Array(int n) throws IOException {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.readU8();
        }
        return nArray;
    }

    public short[] readS16Array(int n) throws IOException {
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = this.readS16();
        }
        return sArray;
    }

    public int[] readU16Array(int n) throws IOException {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.readU16();
        }
        return nArray;
    }

    public int[] readS32Array(int n) throws IOException {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.readS32();
        }
        return nArray;
    }

    public long[] readU32Array(int n) throws IOException {
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = this.readU32();
        }
        return lArray;
    }

    public long[] readS64Array(int n) throws IOException {
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = this.readS64();
        }
        return lArray;
    }

    public boolean readOSBOOLEAN() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException();
        }
        ++this.readpos;
        return n != 0;
    }

    public String readString() throws IOException {
        byte[] byArray = new byte[50];
        int n = 0;
        int n2 = 0;
        while (true) {
            int n3;
            if ((n3 = this.in.read()) == -1) {
                throw new EOFException();
            }
            if (n >= byArray.length) {
                byte[] byArray2 = new byte[byArray.length + 50];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                byArray = byArray2;
            }
            byArray[n2] = (byte)n3;
            ++n;
            if (n3 == 0) break;
            ++n2;
        }
        this.readpos += n;
        return new String(byArray, 0, n - 1, "8859_1");
    }

    public String readString(int n) throws IOException {
        int n2;
        byte[] byArray = new byte[50];
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            int n4 = this.in.read();
            if (n4 == -1) {
                throw new EOFException();
            }
            if (n3 >= byArray.length) {
                byte[] byArray2 = new byte[byArray.length + 50];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                byArray = byArray2;
            }
            byArray[n2] = (byte)n4;
            ++n3;
            if (n4 == 0) break;
        }
        this.readpos += n3;
        n2 = n - n3;
        if (n2 > 0) {
            this.skip(n2);
        }
        return new String(byArray, 0, n3 - 1, "8859_1");
    }

    public long skip(long l) throws IOException {
        long l2 = this.in.skip(l);
        this.readpos += (int)l2;
        return l2;
    }

    public int skipBytes(int n) throws IOException {
        int n2;
        for (int i = 0; i < n; i += n2) {
            n2 = (int)this.in.skip(n - i);
            if (n2 >= n) continue;
            throw new EOFException();
        }
        this.readpos += n;
        return n;
    }

    public void align(int n) throws IOException {
        if (n <= 0 || (n & 1) != 0) {
            return;
        }
        int n2 = (n - this.readpos & n - 1) % n;
        for (int i = 0; i < n2; i += (int)this.in.skip(n2 - i)) {
        }
        this.readpos += n2;
    }

    public synchronized void mark(int n) {
        if (this.in.markSupported()) {
            this.in.mark(n);
            this.markpos = this.readpos;
        }
    }

    public synchronized void reset() throws IOException {
        this.in.reset();
        this.readpos = this.markpos;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    static {
        String string = System.getProperty("java.vm.name").equalsIgnoreCase("j9") ? System.getProperty("com.ibm.cpu.endian", "big") : System.getProperty("sun.cpu.endian", "big");
        hostEndian = string.equals("big");
        String string2 = System.getProperty("alignment_64bit", "8");
        alignment64bit = string2.equals("8") ? 8 : 4;
    }
}

