/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.genericlog;

import java.util.ArrayList;
import java.util.StringTokenizer;
import se.ericsson.cello.genericlog.InvalidParameterException;
import se.ericsson.cello.genericlog.Log;
import se.ericsson.cello.genericlog.LogAlreadyExistsException;
import se.ericsson.cello.genericlog.LogInternalErrorException;
import se.ericsson.cello.genericlog.proxy.CelloLsi4GetLogAttributesRsp;
import se.ericsson.cello.genericlog.proxy.CelloLsiCreateLogRsp;
import se.ericsson.cello.genericlog.proxy.CelloLsiGetLogsListRsp;
import se.ericsson.cello.genericlog.proxy.LogServiceProxy;

public class LogMgr {
    public static final StorageType GLOBAL_STORAGE = new StorageType(3L);
    public static final LogFormat XML_FORMAT = new LogFormat(0L);
    public static final LogFormat RAW_FORMAT = new LogFormat(1L);
    public static final LogFullAction WRAPPED = new LogFullAction(0L);
    public static final LogFullAction HALTED = new LogFullAction(1L);
    public static final LogFullAction PUSHED = new LogFullAction(2L);
    public static final InsertInfoRecords NO_INFO_RECORDS = new InsertInfoRecords(0L);
    public static final InsertInfoRecords INFO_RECORDS = new InsertInfoRecords(1L);
    public static final long NO_SYS_PAR_REF = 0L;
    public static final int CELLO_LSI_OK = 0;
    public static final int CELLO_LSI_FAIL = 1;
    public static final int CELLO_LSI_SERVICE_UNAVAIL = 2;
    public static final int CELLO_LSI_LOG_NAME_NOT_VALID = 3;
    public static final int CELLO_LSI_TOO_LONG_LOG_NAME = 4;
    public static final int CELLO_LSI_STORAGE_NOT_VALID = 5;
    public static final int CELLO_LSI_FORMAT_NOT_VALID = 6;
    public static final int CELLO_LSI_TOO_LONG_LOCATION = 7;
    public static final int CELLO_LSI_LOGFULLACTION_NOT_VALID = 8;
    public static final int CELLO_LSI_LOG_ALREADY_EXIST = 9;
    public static final int CELLO_LSI_FORMAT_ERROR = 10;
    public static final int CELLO_LSI_FS_ERROR = 11;
    public static final int CELLO_LSI_ATTRIBUTES_DIR_NOT_EXIST = 12;
    public static final int CELLO_LSI_LOG_FULL = 13;
    public static final int CELLO_LSI_LOG_NOT_EXIST = 16;
    public static final int CELLO_LSI_TOO_LONG_ADDITIONAL_INFO = 20;
    public static final int CELLO_LSI_LOG_NOT_FULL = 21;
    public static final int CELLO_LSI_FTP_ERROR = 22;
    public static final int CELLO_LSI_WRITE_LIMIT_EXCEEDED = 23;
    public static final int CELLO_LSI_LOG_DATA_STRING_TOO_LONG = 10000;
    public static final int CELLO_LSI_SERVICE_DOWN = 10001;
    public static final int CELLO_LSI_SERVICE_TIMEOUT = 10002;
    private static LogMgr theOneAndOnly = new LogMgr();
    private LogServiceProxy theLogServiceProxy = LogServiceProxy.instance();

    private LogMgr() {
    }

    public static LogMgr instance() {
        return theOneAndOnly;
    }

    public Log createLog(String string, int n, StorageType storageType, LogFormat logFormat, String string2, LogFullAction logFullAction) throws LogAlreadyExistsException, LogInternalErrorException, InvalidParameterException {
        Log log = null;
        CelloLsiCreateLogRsp celloLsiCreateLogRsp = this.theLogServiceProxy.createLog(string, n, storageType.getValue(), logFormat.getValue(), string2, logFullAction.getValue());
        switch ((int)celloLsiCreateLogRsp.result) {
            case 0: {
                log = new Log(string, n, storageType, logFormat, string2, logFullAction, NO_INFO_RECORDS, 0L, "", 0L, 0L);
                break;
            }
            case 9: {
                throw new LogAlreadyExistsException(LogMgr.getResultMsg((int)celloLsiCreateLogRsp.result));
            }
            case 2: 
            case 11: 
            case 10001: 
            case 10002: {
                throw new LogInternalErrorException((int)celloLsiCreateLogRsp.result);
            }
            default: {
                throw new InvalidParameterException(LogMgr.getResultMsg((int)celloLsiCreateLogRsp.result));
            }
        }
        return log;
    }

    public Log lsi2CreateLog(String string, int n, StorageType storageType, LogFormat logFormat, String string2, LogFullAction logFullAction, InsertInfoRecords insertInfoRecords) throws LogAlreadyExistsException, LogInternalErrorException, InvalidParameterException {
        Log log = null;
        CelloLsiCreateLogRsp celloLsiCreateLogRsp = this.theLogServiceProxy.lsi2CreateLog(string, n, storageType.getValue(), logFormat.getValue(), string2, logFullAction.getValue(), insertInfoRecords.getValue());
        switch ((int)celloLsiCreateLogRsp.result) {
            case 0: {
                log = new Log(string, n, storageType, logFormat, string2, logFullAction, insertInfoRecords, 0L, "", 0L, 0L);
                break;
            }
            case 9: {
                throw new LogAlreadyExistsException(LogMgr.getResultMsg((int)celloLsiCreateLogRsp.result));
            }
            case 2: 
            case 11: 
            case 10001: 
            case 10002: {
                throw new LogInternalErrorException((int)celloLsiCreateLogRsp.result);
            }
            default: {
                throw new InvalidParameterException(LogMgr.getResultMsg((int)celloLsiCreateLogRsp.result));
            }
        }
        return log;
    }

    public Log lsi3CreateLog(String string, int n, StorageType storageType, LogFormat logFormat, String string2, LogFullAction logFullAction, InsertInfoRecords insertInfoRecords, long l, String string3) throws LogAlreadyExistsException, LogInternalErrorException, InvalidParameterException {
        Log log = null;
        CelloLsiCreateLogRsp celloLsiCreateLogRsp = this.theLogServiceProxy.lsi3CreateLog(string, n, storageType.getValue(), logFormat.getValue(), string2, logFullAction.getValue(), insertInfoRecords.getValue(), l, string3);
        switch ((int)celloLsiCreateLogRsp.result) {
            case 0: {
                log = new Log(string, n, storageType, logFormat, string2, logFullAction, insertInfoRecords, l, string3, 0L, 0L);
                break;
            }
            case 9: {
                throw new LogAlreadyExistsException(LogMgr.getResultMsg((int)celloLsiCreateLogRsp.result));
            }
            case 2: 
            case 11: 
            case 10001: 
            case 10002: {
                throw new LogInternalErrorException((int)celloLsiCreateLogRsp.result);
            }
            default: {
                throw new InvalidParameterException(LogMgr.getResultMsg((int)celloLsiCreateLogRsp.result));
            }
        }
        return log;
    }

    public Log lsi4CreateLog(String string, int n, StorageType storageType, LogFormat logFormat, String string2, LogFullAction logFullAction, InsertInfoRecords insertInfoRecords, long l, String string3, long l2, long l3) throws LogAlreadyExistsException, LogInternalErrorException, InvalidParameterException {
        Log log = null;
        CelloLsiCreateLogRsp celloLsiCreateLogRsp = this.theLogServiceProxy.lsi4CreateLog(string, n, storageType.getValue(), logFormat.getValue(), string2, logFullAction.getValue(), insertInfoRecords.getValue(), l, string3, l2, l3);
        switch ((int)celloLsiCreateLogRsp.result) {
            case 0: {
                log = new Log(string, n, storageType, logFormat, string2, logFullAction, insertInfoRecords, l, string3, l2, l3);
                break;
            }
            case 9: {
                throw new LogAlreadyExistsException(LogMgr.getResultMsg((int)celloLsiCreateLogRsp.result));
            }
            case 2: 
            case 11: 
            case 10001: 
            case 10002: {
                throw new LogInternalErrorException((int)celloLsiCreateLogRsp.result);
            }
            default: {
                throw new InvalidParameterException(LogMgr.getResultMsg((int)celloLsiCreateLogRsp.result));
            }
        }
        return log;
    }

    public String[] listExistingLogs() throws LogInternalErrorException {
        CelloLsiGetLogsListRsp celloLsiGetLogsListRsp = this.theLogServiceProxy.getLogList();
        switch ((int)celloLsiGetLogsListRsp.result) {
            case 0: {
                ArrayList<String> arrayList = new ArrayList<String>();
                StringTokenizer stringTokenizer = new StringTokenizer(celloLsiGetLogsListRsp.listOfLogs, "\\");
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
                return arrayList.toArray(new String[arrayList.size()]);
            }
        }
        throw new LogInternalErrorException((int)celloLsiGetLogsListRsp.result);
    }

    public Log findLog(String string) throws LogInternalErrorException, InvalidParameterException {
        Log log = null;
        CelloLsi4GetLogAttributesRsp celloLsi4GetLogAttributesRsp = this.theLogServiceProxy.lsi4GetLogAttributes(string);
        switch ((int)celloLsi4GetLogAttributesRsp.result) {
            case 0: {
                StorageType storageType = GLOBAL_STORAGE;
                LogFullAction logFullAction = celloLsi4GetLogAttributesRsp.logFullAction == 0L ? WRAPPED : (celloLsi4GetLogAttributesRsp.logFullAction == 1L ? HALTED : PUSHED);
                LogFormat logFormat = celloLsi4GetLogAttributesRsp.format == 0L ? XML_FORMAT : RAW_FORMAT;
                InsertInfoRecords insertInfoRecords = celloLsi4GetLogAttributesRsp.insertInfoRecords == 0L ? NO_INFO_RECORDS : INFO_RECORDS;
                log = new Log(string, celloLsi4GetLogAttributesRsp.maxSize, storageType, logFormat, celloLsi4GetLogAttributesRsp.location, logFullAction, insertInfoRecords, celloLsi4GetLogAttributesRsp.sysParRef, celloLsi4GetLogAttributesRsp.info, celloLsi4GetLogAttributesRsp.bufferSize, celloLsi4GetLogAttributesRsp.inactivityTimeout);
                break;
            }
            case 2: 
            case 11: {
                throw new LogInternalErrorException((int)celloLsi4GetLogAttributesRsp.result);
            }
            default: {
                throw new InvalidParameterException(LogMgr.getResultMsg((int)celloLsi4GetLogAttributesRsp.result));
            }
        }
        return log;
    }

    static String getResultMsg(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "CELLO_LSI_OK";
                break;
            }
            case 1: {
                string = "CELLO_LSI_FAIL";
                break;
            }
            case 2: {
                string = "CELLO_LSI_SERVICE_UNAVAIL";
                break;
            }
            case 3: {
                string = "CELLO_LSI_LOG_NAME_NOT_VALID";
                break;
            }
            case 4: {
                string = "CELLO_LSI_TOO_LONG_LOG_NAME";
                break;
            }
            case 5: {
                string = "CELLO_LSI_STORAGE_NOT_VALID";
                break;
            }
            case 6: {
                string = "CELLO_LSI_FORMAT_NOT_VALID";
                break;
            }
            case 7: {
                string = "CELLO_LSI_TOO_LONG_LOCATION";
                break;
            }
            case 8: {
                string = "CELLO_LSI_LOGFULLACTION_NOT_VALID";
                break;
            }
            case 9: {
                string = "CELLO_LSI_LOG_ALREADY_EXIST";
                break;
            }
            case 10: {
                string = "CELLO_LSI_FORMAT_ERROR";
                break;
            }
            case 11: {
                string = "CELLO_LSI_FS_ERROR";
                break;
            }
            case 12: {
                string = "CELLO_LSI_ATTRIBUTES_DIR_NOT_EXIST";
                break;
            }
            case 13: {
                string = "CELLO_LSI_LOG_FULL";
                break;
            }
            case 16: {
                string = "CELLO_LSI_LOG_NOT_EXIST";
                break;
            }
            case 20: {
                string = "CELLO_LSI_TOO_LONG_ADDITIONAL_INFO";
                break;
            }
            case 21: {
                string = "CELLO_LSI_LOG_NOT_FULL";
                break;
            }
            case 22: {
                string = "CELLO_LSI_FTP_ERROR";
                break;
            }
            case 23: {
                string = "CELLO_LSI_WRITE_LIMIT_EXCEEDED";
                break;
            }
            case 10000: {
                string = "CELLO_LSI_LOG_DATA_STRING_TOO_LONG";
                break;
            }
            case 10001: {
                string = "CELLO_LSI_SERVICE_DOWN";
                break;
            }
            case 10002: {
                string = "CELLO_LSI_SERVICE_TIMEOUT";
                break;
            }
            default: {
                string = "UNKNOWN RESULT CODE " + n;
            }
        }
        return string;
    }

    public static class InsertInfoRecords {
        private long value;

        InsertInfoRecords(long l) {
            this.value = l;
        }

        long getValue() {
            return this.value;
        }
    }

    public static class LogFullAction {
        private long value;

        LogFullAction(long l) {
            this.value = l;
        }

        long getValue() {
            return this.value;
        }
    }

    public static class LogFormat {
        private long value;

        LogFormat(long l) {
            this.value = l;
        }

        long getValue() {
            return this.value;
        }
    }

    public static class StorageType {
        private long value;

        StorageType(long l) {
            this.value = l;
        }

        long getValue() {
            return this.value;
        }
    }
}

