/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.persistence;

import java.util.NoSuchElementException;
import se.ericsson.cello.persistence.Convert;
import se.ericsson.cello.persistence.DbAccessException;
import se.ericsson.cello.persistence.DbTableExistsException;
import se.ericsson.cello.support.control.Control;
import se.ericsson.cello.support.debug.Assert;

public class DbWrapper {
    private String tableName;
    private long databaseConnection = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbWrapper(String string) throws DbAccessException {
        this.tableName = string;
        try {
            this.connectToDatabase();
            this.createTable(this.databaseConnection, this.tableName);
        }
        catch (DbTableExistsException dbTableExistsException) {
        }
        finally {
            this.disconnectFromDatabase();
        }
    }

    public void connectToDatabase() throws DbAccessException {
        Assert.cppAssert(this.databaseConnection == 0L, "DbWrapper.connectToDatabase() not disconnected");
        this.databaseConnection = this.connectDb();
    }

    public void disconnectFromDatabase() throws DbAccessException {
        Assert.cppAssert(this.databaseConnection != 0L, "DbWrapper.disconnectFromDatabase() not connected");
        this.disconnectDb(this.databaseConnection);
        this.databaseConnection = 0L;
    }

    public void createRow(int n, int n2) throws DbAccessException {
        String string = null;
        string = "INSERT INTO " + this.tableName + " VALUES (" + n2 + ", NULL, NULL)";
        this.update(n, string);
    }

    public void updateRow(int n, int n2, byte[] byArray) throws DbAccessException {
        String string = null;
        String string2 = null;
        string2 = Control.getOs() == 1 ? "E'\\\\x" + Convert.byteArrayToHexString(byArray) + "'" : "X'" + Convert.byteArrayToHexString(byArray) + "'";
        string = "UPDATE " + this.tableName + " SET SIZE = " + byArray.length + ", DATA = " + string2 + " WHERE ID = " + n2;
        this.update(n, string);
    }

    public void deleteRow(int n, int n2) throws DbAccessException {
        String string = null;
        string = "DELETE FROM " + this.tableName + " WHERE ID = " + n2;
        this.update(n, string);
    }

    public void deleteTable(int n) throws DbAccessException {
        String string = null;
        string = "DROP TABLE " + this.tableName;
        this.update(n, string);
    }

    public byte[] retrieveRow(int n) throws DbAccessException, NoSuchElementException {
        byte[] byArray = null;
        byArray = this.retrieveRow(this.databaseConnection, n, this.tableName);
        return byArray;
    }

    public byte[][] retrieveRows(int n, int n2) throws DbAccessException {
        byte[][] byArray = null;
        byArray = this.retrieveRows(this.databaseConnection, n, n2, this.tableName);
        return byArray;
    }

    public int[] retrieveAllPrimaryKeys() throws DbAccessException {
        int[] nArray = null;
        nArray = this.getAllPrimaryKeys(this.databaseConnection, this.tableName);
        return nArray;
    }

    public int getNoOfRows() throws DbAccessException {
        int[] nArray = null;
        nArray = this.getAllPrimaryKeys(this.databaseConnection, this.tableName);
        return nArray.length;
    }

    private native long connectDb() throws DbAccessException;

    private native int disconnectDb(long var1) throws DbAccessException;

    private native void createTable(long var1, String var3) throws DbTableExistsException, DbAccessException;

    private native byte[] retrieveRow(long var1, int var3, String var4) throws DbAccessException, NoSuchElementException;

    private native byte[][] retrieveRows(long var1, int var3, int var4, String var5) throws DbAccessException;

    private native int[] getAllPrimaryKeys(long var1, String var3) throws DbAccessException;

    private native void update(int var1, String var2) throws DbAccessException;
}

