/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.control;

import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.ArrayList;
import se.ericsson.cello.support.debug.Assert;
import se.ericsson.cello.support.debug.MessageLog;

public class CppClassLoader
extends URLClassLoader {
    private ArrayList vJarList = new ArrayList();
    private boolean svsEnabled = true;

    public CppClassLoader() {
        this((URL[])null, ClassLoader.getSystemClassLoader());
    }

    public CppClassLoader(URL[] uRLArray) {
        this(uRLArray, ClassLoader.getSystemClassLoader());
    }

    public CppClassLoader(URL[] uRLArray, ClassLoader classLoader) {
        super(uRLArray, classLoader);
        try {
            this.svsEnabled = CppClassLoader.initateSvsiService();
        }
        catch (SecurityException securityException) {
            MessageLog.info(this.getClass(), securityException.toString());
            Assert.cppAssert(false, "Failed to initiate SVSI Service");
        }
    }

    public void addURL(URL uRL) {
        super.addURL(uRL);
    }

    public final synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = null;
        clazz = this.findLoadedClass(string);
        if (clazz != null) {
            return clazz;
        }
        clazz = super.loadClass(string, bl);
        if (!this.svsEnabled) {
            return clazz;
        }
        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
        String string2 = new String();
        if (codeSource == null) {
            return clazz;
        }
        string2 = codeSource.getLocation().getPath();
        if (!this.vJarList.contains(string2)) {
            try {
                String string3 = string2 + ".sm";
                if (CppClassLoader.validateJarLM(string2, string3)) {
                    this.vJarList.add(string2);
                }
            }
            catch (SecurityException securityException) {
                clazz = null;
                MessageLog.info(this.getClass(), securityException.toString());
                throw new ClassNotFoundException();
            }
        }
        return clazz;
    }

    protected void finalized() throws Throwable {
        CppClassLoader.terminateSvsiService();
    }

    private static native boolean initateSvsiService() throws SecurityException;

    private static native boolean validateJarLM(String var0, String var1) throws SecurityException;

    private static native void terminateSvsiService();
}

