/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.debug;

import se.ericsson.cello.support.debug.GcStats;

public class GenerationalGcStats
implements GcStats {
    public int nLocalGc;
    public int nGlobalGc;
    public long timeLocalGc;
    public long timeGlobalGc;

    public GenerationalGcStats() {
        this.update();
    }

    public long getGcTime() {
        return this.timeLocalGc + this.timeGlobalGc;
    }

    public String toString() {
        return "Local GC, count=" + this.nLocalGc + ", time=" + this.timeLocalGc + " ms\n" + "Global GC, count=" + this.nGlobalGc + ", time=" + this.timeGlobalGc + " ms";
    }

    public GcStats subtract(GcStats gcStats) {
        GenerationalGcStats generationalGcStats = (GenerationalGcStats)gcStats;
        this.nLocalGc -= generationalGcStats.nLocalGc;
        this.timeLocalGc -= generationalGcStats.timeLocalGc;
        this.nGlobalGc -= generationalGcStats.nGlobalGc;
        this.timeGlobalGc -= generationalGcStats.timeGlobalGc;
        return this;
    }

    public native void update();
}

