/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.debug.signals;

import enea.ose.io.SignalInputStream;
import java.io.IOException;
import se.ericsson.cello.support.debug.signals.JteRuntimeException;
import se.ericsson.cello.support.debug.signals.LocalJTESignal;
import se.ericsson.cello.support.debug.trace.ThreadsContainerForOse;
import se.ericsson.cello.support.debug.trace.TraceItem;

public class OmcsfGroupMasksInd
extends LocalJTESignal {
    public static final int SigNo = 3161423;
    int noOfMasks = 0;
    int[] change;
    long[] groupMask;
    String[] procName;

    public OmcsfGroupMasksInd() {
        super(3161423);
    }

    public void initReceive() {
        SignalInputStream signalInputStream = this.getSignalInputStream();
        try {
            this.noOfMasks = signalInputStream.readS32();
            this.change = new int[this.noOfMasks];
            this.groupMask = new long[this.noOfMasks];
            this.procName = new String[this.noOfMasks];
            for (int i = 0; i < this.noOfMasks; ++i) {
                this.change[i] = (int)signalInputStream.readU32();
                this.groupMask[i] = signalInputStream.readU32();
                this.procName[i] = signalInputStream.readString();
                for (int j = 0; j < 128 - (this.procName[i].length() + 1); ++j) {
                    signalInputStream.readU8();
                }
            }
        }
        catch (IOException iOException) {
            throw new JteRuntimeException("IO-error in " + this.getClass());
        }
    }

    public void initSend() {
    }

    public LocalJTESignal[] handleSignal(ThreadsContainerForOse threadsContainerForOse) {
        int n;
        boolean[] blArray = new boolean[this.noOfMasks];
        for (n = 0; n < blArray.length; ++n) {
            blArray[n] = false;
        }
        for (n = 0; n < this.noOfMasks; ++n) {
            int n2 = -1;
            int n3 = 0;
            for (int i = 0; i < this.noOfMasks; ++i) {
                TraceItem traceItem;
                if (blArray[i]) continue;
                try {
                    traceItem = new TraceItem(this.procName[i]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    blArray[i] = true;
                    continue;
                }
                String string = traceItem.getPackageName();
                if (n2 >= 0 && string.length() >= n3) continue;
                n2 = i;
                n3 = string.length();
            }
            if (n2 < 0) continue;
            blArray[n2] = true;
            threadsContainerForOse.modifyFilter(this.procName[n2], this.groupMask[n2], this.change[n2]);
        }
        return null;
    }
}

