/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.debug.signals;

import enea.ose.io.SignalInputStream;
import enea.ose.system.OseProcess;
import java.io.IOException;
import se.ericsson.cello.support.debug.signals.JteRuntimeException;
import se.ericsson.cello.support.debug.signals.LocalJTESignal;
import se.ericsson.cello.support.debug.signals.OmcsfStatusInfoInd;
import se.ericsson.cello.support.debug.trace.OmcsfFilterMaskResult;
import se.ericsson.cello.support.debug.trace.ThreadContainer;
import se.ericsson.cello.support.debug.trace.ThreadsContainerForOse;
import se.ericsson.cello.support.debug.trace.TraceItem;

public class OmcsfStatusInd
extends LocalJTESignal {
    public static int sigNo = 3161413;
    private String procName;
    private long directPid;

    public OmcsfStatusInd() {
        super(sigNo);
    }

    public OmcsfStatusInd(String string, int n) {
        super(sigNo);
        this.procName = string;
        this.directPid = n;
    }

    public void initReceive() {
        SignalInputStream signalInputStream = this.getSignalInputStream();
        try {
            this.procName = signalInputStream.readString();
            for (int i = 0; i < 128 - (this.procName.length() + 1); ++i) {
                signalInputStream.readU8();
            }
            this.directPid = signalInputStream.readU32();
        }
        catch (IOException iOException) {
            throw new JteRuntimeException("IO-error in " + this.getClass());
        }
    }

    public void initSend() {
    }

    public LocalJTESignal[] handleSignal(ThreadsContainerForOse threadsContainerForOse) {
        LocalJTESignal[] localJTESignalArray = new OmcsfStatusInfoInd[1];
        OmcsfFilterMaskResult omcsfFilterMaskResult = threadsContainerForOse.getFilterMask(this.procName);
        if (omcsfFilterMaskResult == null) {
            localJTESignalArray[0] = new OmcsfStatusInfoInd(0, null, null, null);
            return localJTESignalArray;
        }
        int n = 470;
        int[] nArray = null;
        long[] lArray = null;
        String[] stringArray = null;
        int n2 = 0;
        for (int i = omcsfFilterMaskResult.size(); i > 0; i -= n) {
            n2 = i > n ? n : i;
            nArray = new int[n2];
            lArray = new long[n2];
            stringArray = new String[n2];
            for (int j = 0; j < n2; ++j) {
                ThreadContainer threadContainer = threadsContainerForOse.getTC(omcsfFilterMaskResult.thread);
                nArray[j] = threadContainer.getOseProcess().getPID();
                lArray[j] = omcsfFilterMaskResult.mask;
                stringArray[j] = TraceItem.getTraceItemString(omcsfFilterMaskResult.packageName, omcsfFilterMaskResult.thread.getName());
                omcsfFilterMaskResult = (OmcsfFilterMaskResult)omcsfFilterMaskResult.next;
            }
            if (i <= n) continue;
            try {
                OseProcess oseProcess = OseProcess.getProcess((int)this.directPid);
                oseProcess.post(new OmcsfStatusInfoInd(n2, nArray, lArray, stringArray));
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println(illegalArgumentException);
            }
        }
        localJTESignalArray[0] = new OmcsfStatusInfoInd(n2, nArray, lArray, stringArray);
        return localJTESignalArray;
    }
}

