/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.debug.trace;

import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.SignalRegistry;
import enea.ose.system.ThisProcess;
import java.util.Enumeration;
import se.ericsson.cello.support.debug.CsHuntSig;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.debug.signals.LocalJTESignal;
import se.ericsson.cello.support.debug.signals.OmcsfBusFilterInd;
import se.ericsson.cello.support.debug.signals.OmcsfDeregisterProcInd;
import se.ericsson.cello.support.debug.signals.OmcsfGroupMaskInd;
import se.ericsson.cello.support.debug.signals.OmcsfGroupMaskReq;
import se.ericsson.cello.support.debug.signals.OmcsfGroupMasksInd;
import se.ericsson.cello.support.debug.signals.OmcsfLogWriteInd;
import se.ericsson.cello.support.debug.signals.OmcsfProcInfoInd;
import se.ericsson.cello.support.debug.signals.OmcsfProcNameInd;
import se.ericsson.cello.support.debug.signals.OmcsfSaveGroupMaskInd;
import se.ericsson.cello.support.debug.signals.OmcsfSetDefaultGroupMaskInd;
import se.ericsson.cello.support.debug.signals.OmcsfSetProcInfoPidInd;
import se.ericsson.cello.support.debug.signals.OmcsfStatusInd;
import se.ericsson.cello.support.debug.trace.MessageDivider;
import se.ericsson.cello.support.debug.trace.ThreadContainer;
import se.ericsson.cello.support.debug.trace.ThreadsContainerForOse;
import se.ericsson.cello.support.debug.trace.TraceItem;

class ExternalCommunicatorForOse
implements Runnable {
    SignalRegistry reg;
    OseProcess global;
    OseProcess log;
    OseProcess signalReceiverProcess;
    ThreadsContainerForOse threadsContainer;
    boolean initialized = false;
    public int OSE_HUNT_TIMEOUT = 5000;
    static final int ERROR_SLEEP_TIME = 10000;
    static String logProcessName = "Sys_OMCSF_teLogMain";
    static String globalProcessName = "Sys_OMCSF_teGlobal";

    public ExternalCommunicatorForOse(ThreadsContainerForOse threadsContainerForOse) {
        this.threadsContainer = threadsContainerForOse;
        Thread thread = new Thread((Runnable)this, "Osa_debug_thread");
        thread.setPriority(thread.getThreadGroup().getMaxPriority());
        thread.setDaemon(true);
        thread.start();
    }

    private OseProcess hunt(String string) {
        OseProcess.hunt(string, new CsHuntSig());
        InSignal inSignal = null;
        SignalRegistry signalRegistry = new SignalRegistry();
        signalRegistry.add(CsHuntSig.class);
        inSignal = ThisProcess.receive(signalRegistry, this.OSE_HUNT_TIMEOUT);
        if (inSignal != null && inSignal instanceof CsHuntSig) {
            return inSignal.getSender();
        }
        throw new IllegalArgumentException("Tried to hunt the process " + string + ", but it was not found.");
    }

    private void initLoop() {
        while (true) {
            try {
                this.init();
                return;
            }
            catch (Throwable throwable) {
                this.setInitialized();
                MessageLog.traceError(this.getClass(), "Could not init the external communication.", throwable);
                try {
                    Thread.sleep(10000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    MessageLog.traceError(this.getClass(), "Unexpected exception.", interruptedException);
                    continue;
                }
            }
            break;
        }
    }

    private synchronized void init() {
        this.signalReceiverProcess = ThisProcess.getThisProcess();
        this.log = this.hunt(logProcessName);
        this.reg = new SignalRegistry();
        this.reg.add(OmcsfStatusInd.class);
        this.reg.add(OmcsfGroupMaskReq.class);
        this.reg.add(OmcsfGroupMaskInd.class);
        this.reg.add(OmcsfSetDefaultGroupMaskInd.class);
        this.reg.add(OmcsfBusFilterInd.class);
        this.reg.add(OmcsfSaveGroupMaskInd.class);
        this.reg.add(OmcsfSetProcInfoPidInd.class);
        this.reg.add(OmcsfProcInfoInd.class);
        this.reg.add(OmcsfGroupMasksInd.class);
        this.global = this.hunt(globalProcessName);
        this.setInitialized();
    }

    private final synchronized void setInitialized() {
        this.initialized = true;
        this.notifyAll();
    }

    private synchronized void waitForExternalCommunicatorProcess() {
        while (!this.initialized) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void internalSendTraceMessage(int n, int n2, String string, String string2) {
        if (!this.initialized) {
            this.waitForExternalCommunicatorProcess();
        }
        String string3 = TraceItem.stripPackage(string);
        String string4 = TraceItem.getTraceItemString(TraceItem.stripClass(string), Thread.currentThread().getName());
        if (string2 == null) {
            string2 = "<null>";
        }
        String[] stringArray = MessageDivider.divideMessage(string2, string3.length());
        for (int i = 0; i < stringArray.length; ++i) {
            OmcsfLogWriteInd omcsfLogWriteInd = new OmcsfLogWriteInd(n, n2, string3, string4, stringArray[i]);
            this.log.post(omcsfLogWriteInd, this.signalReceiverProcess);
        }
    }

    void sendTraceMessage(int n, int n2, String string, String string2) {
        try {
            this.internalSendTraceMessage(n, n2, string, string2);
        }
        catch (Throwable throwable) {
            OmcsfLogWriteInd omcsfLogWriteInd = new OmcsfLogWriteInd(n, n2, string, Thread.currentThread().getName(), string2);
            MessageLog.info(this.getClass(), "Could not send trace message " + omcsfLogWriteInd + ":\n" + throwable);
            System.err.println("Could not send trace message " + omcsfLogWriteInd + ":\n" + throwable);
        }
    }

    private void removeRegistration(Thread thread) {
        ThreadContainer threadContainer = this.threadsContainer.removeThread(thread);
        String string = TraceItem.getTraceItemString("", threadContainer.getThreadName());
        OmcsfDeregisterProcInd omcsfDeregisterProcInd = new OmcsfDeregisterProcInd(string);
        this.global.post(omcsfDeregisterProcInd, this.signalReceiverProcess);
    }

    private void checkForDeadThreads() {
        Enumeration enumeration = this.threadsContainer.keys();
        while (enumeration.hasMoreElements()) {
            Thread thread = (Thread)enumeration.nextElement();
            if (thread.isAlive()) continue;
            this.removeRegistration(thread);
        }
    }

    public final void register(Thread thread) {
        try {
            if (!this.initialized) {
                this.waitForExternalCommunicatorProcess();
            }
            ThreadContainer threadContainer = this.threadsContainer.getTC(thread);
            String string = threadContainer.getThreadName();
            String string2 = TraceItem.getTraceItemString("", string);
            this.checkForDeadThreads();
            OmcsfProcNameInd omcsfProcNameInd = new OmcsfProcNameInd(string2);
            this.global.post(omcsfProcNameInd, this.signalReceiverProcess);
        }
        catch (Throwable throwable) {
            MessageLog.traceError(this.getClass(), "Could not register thread with name " + thread.getName(), throwable);
        }
    }

    public void run() {
        this.initLoop();
        while (true) {
            try {
                while (true) {
                    this.receiveSignal();
                }
            }
            catch (Throwable throwable) {
                MessageLog.traceError(this.getClass(), "Error while receiveing and handling signal from global module", throwable);
                continue;
            }
            break;
        }
    }

    public void receiveSignal() {
        InSignal inSignal = ThisProcess.receive(this.reg);
        if (!(inSignal instanceof LocalJTESignal)) {
            return;
        }
        LocalJTESignal localJTESignal = (LocalJTESignal)inSignal;
        LocalJTESignal[] localJTESignalArray = localJTESignal.handleSignal(this.threadsContainer);
        if (localJTESignalArray == null) {
            return;
        }
        for (int i = 0; i < localJTESignalArray.length; ++i) {
            this.global.post(localJTESignalArray[i], this.signalReceiverProcess);
        }
    }
}

