/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.sigutil;

import enea.ose.system.InSignal;
import enea.ose.system.SignalRegistry;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.sigutil.SignalObserver;
import se.ericsson.cello.support.sigutil.signals.UpdateSignal;
import se.ericsson.cello.support.thread.ReadWriteLock;

class ObserverList {
    private ReadWriteLock lock = new ReadWriteLock();
    private Hashtable observerTable = new Hashtable(100);
    private Hashtable sigNoTable = new Hashtable(100);

    ObserverList() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(SignalObserver signalObserver, Class clazz) {
        try {
            this.lock.requestWrite();
            Vector<SignalObserver> vector = (Vector<SignalObserver>)this.observerTable.get(clazz);
            if (vector != null) {
                vector.insertElementAt(signalObserver, vector.size());
            } else if (this.addSignal(clazz)) {
                vector = new Vector<SignalObserver>(1);
                vector.insertElementAt(signalObserver, 0);
                this.observerTable.put(clazz, vector);
                MessageLog.trace(7, this.getClass(), "Added Observer for  Signal :" + clazz.getName());
            }
        }
        finally {
            this.lock.writeAccomplished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(SignalObserver signalObserver, Class clazz) {
        block8: {
            try {
                this.lock.requestWrite();
                Vector vector = (Vector)this.observerTable.get(clazz);
                if (vector != null) {
                    if (!vector.removeElement(signalObserver)) {
                        return;
                    }
                    if (vector.isEmpty()) {
                        this.sigNoTable.remove(new Integer(ObserverList.classToSigNo(clazz)));
                        this.observerTable.remove(clazz);
                        MessageLog.trace(7, this.getClass(), "Removed Observer for  Signal :" + clazz.getName());
                        return;
                    }
                    break block8;
                }
                MessageLog.trace(7, this.getClass(), "No Signal Observer Class registered for Signal :" + clazz.getName());
                return;
            }
            finally {
                this.lock.writeAccomplished();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Enumeration getEnumeratedObservers(Class clazz) {
        try {
            this.lock.requestRead();
            Vector vector = (Vector)this.observerTable.get(clazz);
            if (vector != null) {
                Vector vector2 = (Vector)vector.clone();
                Enumeration enumeration = vector2.elements();
                return enumeration;
            }
            Enumeration enumeration = null;
            return enumeration;
        }
        finally {
            this.lock.readAccomplished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SignalRegistry getSignalRegistry() {
        SignalRegistry signalRegistry = new SignalRegistry();
        try {
            this.lock.requestRead();
            Enumeration enumeration = this.observerTable.keys();
            while (enumeration.hasMoreElements()) {
                Class clazz = (Class)enumeration.nextElement();
                signalRegistry.add(clazz);
            }
            signalRegistry.add(UpdateSignal.class);
        }
        finally {
            this.lock.readAccomplished();
        }
        return signalRegistry;
    }

    private boolean addSignal(Class clazz) {
        int n = ObserverList.classToSigNo(clazz);
        Integer n2 = new Integer(n);
        Class clazz2 = (Class)this.sigNoTable.get(n2);
        if (clazz2 != null) {
            MessageLog.info(this.getClass(), "The signal " + clazz + " can not be added to SignalRegistry, " + " it already contains the signal " + clazz2 + " with sigNo = 0x" + Integer.toHexString(n));
            return false;
        }
        MessageLog.trace(7, this.getClass(), "Added " + clazz + " with sigNo = 0x" + Integer.toHexString(n) + " to sigreg");
        this.sigNoTable.put(n2, clazz);
        return true;
    }

    static int classToSigNo(Class clazz) {
        try {
            InSignal inSignal = (InSignal)clazz.newInstance();
            return inSignal.getSigNo();
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Default constructor missing in " + clazz.getName());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Default constructor not public in " + clazz.getName());
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(clazz.getName() + " do not extend " + "enea.ose.system.InSignal");
        }
    }
}

