/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.transaction;

public final class TerminationCause {
    public static final int CELLO_TRANI_UNKNOWN = 0;
    public static final int CELLO_TRANI_MAX_SIZE_EXCEEDED = 1;
    public static final int CELLO_TRANI_TIMEOUT = 2;
    public static final int CELLO_TRANI_DB_ERROR = 3;
    public static final int CELLO_TRANI_USER_DB_ERROR = 4;
    public static final int CELLO_TRANI_RESOURCE_TERMINATED = 5;
    public static final int CELLO_TRANI_ROLLBACK_REQUEST = 6;
    public static final int CELLO_TRANI_SERVER_TERMINATED = 10000;
    public static final int CELLO_TRANI_COMMITTED = 10001;
    public static final int CELLO_TRANI_STILL_ACTIVE = 10002;
    public int value;

    TerminationCause(int n) {
        this.value = n;
    }

    public String toString() {
        switch (this.value) {
            case 3: {
                return "database error";
            }
            case 4: {
                return "SQL error";
            }
            case 6: {
                return "rollback requested";
            }
            case 5: {
                return "resource terminated";
            }
            case 2: {
                return "time-out";
            }
            case 1: {
                return "max size exceeded";
            }
            case 10000: {
                return "server terminated";
            }
            case 10001: {
                return "committed";
            }
            case 10002: {
                return "still active";
            }
        }
        return "unknown";
    }

    private static native void initJNI();

    static {
        TerminationCause.initJNI();
    }
}

