/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.transaction;

import se.ericsson.cello.transaction.CHandler;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.ControlImpl;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionManager;
import se.ericsson.cello.transaction.TransactionResult;
import se.ericsson.cello.transaction.TransactionRolledBackException;

class TransactionFactoryImpl
implements TransactionFactory {
    private static TransactionFactoryImpl uniqueInstance = new TransactionFactoryImpl();

    public static TransactionFactoryImpl instance() {
        return uniqueInstance;
    }

    public Control create(int n) throws TransactionRolledBackException {
        ControlImpl controlImpl = null;
        TransactionResult transactionResult = new TransactionResult();
        int n2 = CHandler.create(n, transactionResult);
        if (transactionResult.value != 0) {
            throw new TransactionRolledBackException(transactionResult.toString());
        }
        controlImpl = new ControlImpl(n2);
        CHandler.register(n2, transactionResult);
        CHandler.instance().waitForRegisterResponse(n2);
        return controlImpl;
    }

    public Control get(int n) {
        return TransactionManager.instance().getTransaction(n);
    }

    private TransactionFactoryImpl() {
    }
}

