/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.common.util;

import se.ericsson.crbs.omf.aue.common.CrbsAueException;

public class LdnUtil {
    private LdnUtil() {
    }

    public static String createChildLdn(String parentLdn, String childMoType, String childId) {
        return parentLdn + "," + childMoType + "=" + childId;
    }

    public static String getRdnValue(String ldn) {
        return ldn.substring(ldn.lastIndexOf(61) + 1);
    }

    public static String getMoType(String ldn) {
        int startMoType = ldn.lastIndexOf(44) + 1;
        int endMoType = ldn.lastIndexOf(61);
        return ldn.substring(startMoType, endMoType);
    }

    public static String replaceLdn(String ldn, String oldLdnPart, String newLdnPart) {
        String newLdn = ldn.trim();
        String search = oldLdnPart.trim();
        String replace = newLdnPart.trim();
        int startindex = newLdn.indexOf(search);
        if (startindex >= 0) {
            String beforeSubString = newLdn.substring(0, startindex);
            String afterSubString = newLdn.substring(startindex + search.length());
            newLdn = beforeSubString + replace + afterSubString;
        }
        return newLdn;
    }

    public static String getParentLdn(String ldn) {
        String parentLdn = null;
        if (LdnUtil.hasParent(ldn)) {
            parentLdn = ldn.substring(0, ldn.lastIndexOf(44));
        }
        return parentLdn;
    }

    public static boolean hasParent(String ldn) {
        return ldn.lastIndexOf(44) != -1;
    }

    public static boolean isParent(String parentLdn, String childLdn) {
        return childLdn.indexOf(parentLdn) != -1;
    }

    public static String getTypeNameFromLdn(String ldnToType) throws CrbsAueException {
        int lastCommaIndex = ldnToType.lastIndexOf(",");
        int lastEqualsIndex = ldnToType.lastIndexOf("=");
        if (lastCommaIndex == -1) {
            lastCommaIndex = 0;
        }
        if (lastCommaIndex > lastEqualsIndex) {
            throw new CrbsAueException("Not a valid LDN: " + ldnToType);
        }
        String typeFromLdn = ldnToType.substring(lastCommaIndex + 1, lastEqualsIndex);
        return typeFromLdn;
    }
}

