/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step2.actions;

import java.io.StringReader;
import java.util.AbstractList;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.StructAttribute;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;

public class ChildInstanceAttributesHandler
extends DefaultHandler {
    private static final String XML_STRING_NOTIFICATION = "notification";
    private static final String XML_STRING_ATTRIBUTE = "attr";
    private static final String XML_STRING_NAME = "name";
    private static final String XML_STRING_TYPE = "type";
    private static final String XML_STRING_VALUE = "value";
    private AbstractList attributeList;

    public void startDocument() throws SAXException {
        this.attributeList = new ArrayList();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (XML_STRING_ATTRIBUTE.equals(localName)) {
            String name = attributes.getValue(XML_STRING_NAME);
            String type = attributes.getValue(XML_STRING_TYPE);
            String value = attributes.getValue(XML_STRING_VALUE);
            String notification = attributes.getValue(XML_STRING_NOTIFICATION);
            boolean notificationValue = true;
            if (notification != null && notification.equalsIgnoreCase("false")) {
                notificationValue = false;
            }
            IntegerAttribute attribute = null;
            if (type.equalsIgnoreCase("S32")) {
                attribute = new IntegerAttribute(name, notificationValue, Integer.parseInt(value));
            } else if (type.equalsIgnoreCase("STRING")) {
                attribute = new StringAttribute(name, notificationValue, value);
            } else if (type.equalsIgnoreCase("moref")) {
                attribute = new ReferenceAttribute(name, value, notificationValue);
            } else if (type.equalsIgnoreCase("STRUCT")) {
                AbstractList structElements = this.parseAttributeAttributes(value);
                attribute = new StructAttribute(name, notificationValue);
                this.addAttributeElements((Attribute)attribute, structElements);
            } else if (type.equalsIgnoreCase("ARRAY")) {
                AbstractList arrayElements = this.parseAttributeAttributes(value);
                attribute = new SequenceAttribute(name, notificationValue);
                this.addAttributeElements((Attribute)attribute, arrayElements);
            }
            if (attribute != null) {
                this.attributeList.add(attribute);
            }
        }
    }

    public AbstractList getAttributeList() {
        return this.attributeList;
    }

    private AbstractList parseAttributeAttributes(String attributesXmlString) throws SAXException {
        AbstractList attributeDataList = null;
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            StringReader reader = new StringReader(attributesXmlString);
            InputSource inputSource = new InputSource(reader);
            ChildInstanceAttributesHandler handler = new ChildInstanceAttributesHandler();
            parser.setContentHandler(handler);
            parser.parse(inputSource);
            attributeDataList = handler.getAttributeList();
            if (attributeDataList == null) {
                throw new CrbsAueException("No attribute list recieved from the ChildInstanceAttributeHandler");
            }
        }
        catch (Exception e) {
            throw new SAXException(e.getMessage());
        }
        return attributeDataList;
    }

    private void addAttributeElements(Attribute attribute, AbstractList elementList) {
        for (int element = 0; element < elementList.size(); ++element) {
            if (attribute instanceof StructAttribute) {
                ((StructAttribute)attribute).addElement((Attribute)elementList.get(element));
                continue;
            }
            if (!(attribute instanceof SequenceAttribute)) continue;
            ((SequenceAttribute)attribute).addElement((Attribute)elementList.get(element));
        }
    }
}

