/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.asn1;

import com.maverick.crypto.asn1.ASN1OctetString;
import com.maverick.crypto.asn1.ASN1TaggedObject;
import com.maverick.crypto.asn1.DERObject;
import com.maverick.crypto.asn1.DEROutputStream;
import com.maverick.crypto.asn1.DERString;
import java.io.IOException;

public class DERGeneralString
extends DERObject
implements DERString {
    private String jb;

    public static DERGeneralString getInstance(Object object) {
        if (object == null || object instanceof DERGeneralString) {
            return (DERGeneralString)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERGeneralString(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERGeneralString.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERGeneralString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERGeneralString.getInstance(aSN1TaggedObject.getObject());
    }

    public DERGeneralString(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int k = 0; k != cArray.length; ++k) {
            cArray[k] = (char)(byArray[k] & 0xFF);
        }
        this.jb = new String(cArray);
    }

    public DERGeneralString(String string) {
        this.jb = string;
    }

    public String getString() {
        return this.jb;
    }

    public byte[] getOctets() {
        char[] cArray = this.jb.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int k = 0; k != cArray.length; ++k) {
            byArray[k] = (byte)cArray[k];
        }
        return byArray;
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.b(27, this.getOctets());
    }

    public int hashCode() {
        return this.getString().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DERGeneralString)) {
            return false;
        }
        DERGeneralString dERGeneralString = (DERGeneralString)object;
        return this.getString().equals(dERGeneralString.getString());
    }
}

