/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.asn1;

import com.maverick.crypto.asn1.ASN1OctetString;
import com.maverick.crypto.asn1.ASN1TaggedObject;
import com.maverick.crypto.asn1.DERObject;
import com.maverick.crypto.asn1.DEROutputStream;
import com.maverick.crypto.asn1.OIDTokenizer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DERObjectIdentifier
extends DERObject {
    String yb;

    public static DERObjectIdentifier getInstance(Object object) {
        if (object == null || object instanceof DERObjectIdentifier) {
            return (DERObjectIdentifier)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERObjectIdentifier(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERObjectIdentifier.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERObjectIdentifier getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERObjectIdentifier.getInstance(aSN1TaggedObject.getObject());
    }

    DERObjectIdentifier(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        boolean bl = true;
        for (int k = 0; k != byArray.length; ++k) {
            int n2 = byArray[k] & 0xFF;
            n = n * 128 + (n2 & 0x7F);
            if ((n2 & 0x80) != 0) continue;
            if (bl) {
                switch (n / 40) {
                    case 0: {
                        stringBuffer.append('0');
                        break;
                    }
                    case 1: {
                        stringBuffer.append('1');
                        n -= 40;
                        break;
                    }
                    default: {
                        stringBuffer.append('2');
                        n -= 80;
                    }
                }
                bl = false;
            }
            stringBuffer.append('.');
            stringBuffer.append(Integer.toString(n));
            n = 0;
        }
        this.yb = stringBuffer.toString();
    }

    public DERObjectIdentifier(String string) {
        this.yb = string;
    }

    public String getId() {
        return this.yb;
    }

    private void b(OutputStream outputStream, int n) throws IOException {
        if (n >= 128) {
            if (n >= 16384) {
                if (n >= 0x200000) {
                    if (n >= 0x10000000) {
                        outputStream.write(n >> 28 | 0x80);
                    }
                    outputStream.write(n >> 21 | 0x80);
                }
                outputStream.write(n >> 14 | 0x80);
            }
            outputStream.write(n >> 7 | 0x80);
        }
        outputStream.write(n & 0x7F);
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        OIDTokenizer oIDTokenizer = new OIDTokenizer(this.yb);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream2 = new DEROutputStream(byteArrayOutputStream);
        this.b(byteArrayOutputStream, Integer.parseInt(oIDTokenizer.nextToken()) * 40 + Integer.parseInt(oIDTokenizer.nextToken()));
        while (oIDTokenizer.hasMoreTokens()) {
            this.b(byteArrayOutputStream, Integer.parseInt(oIDTokenizer.nextToken()));
        }
        dEROutputStream2.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        dEROutputStream.b(6, byArray);
    }

    public int hashCode() {
        return this.yb.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DERObjectIdentifier)) {
            return false;
        }
        return this.yb.equals(((DERObjectIdentifier)object).yb);
    }
}

