/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.asn1.x509;

import com.maverick.crypto.asn1.ASN1Encodable;
import com.maverick.crypto.asn1.ASN1EncodableVector;
import com.maverick.crypto.asn1.ASN1Sequence;
import com.maverick.crypto.asn1.ASN1TaggedObject;
import com.maverick.crypto.asn1.DEREncodable;
import com.maverick.crypto.asn1.DERObject;
import com.maverick.crypto.asn1.DERObjectIdentifier;
import com.maverick.crypto.asn1.DERSequence;

public class AlgorithmIdentifier
extends ASN1Encodable {
    private DERObjectIdentifier ic;
    private DEREncodable kc;
    private boolean jc = false;

    public static AlgorithmIdentifier getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return AlgorithmIdentifier.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static AlgorithmIdentifier getInstance(Object object) {
        if (object instanceof AlgorithmIdentifier) {
            return (AlgorithmIdentifier)object;
        }
        if (object instanceof DERObjectIdentifier) {
            return new AlgorithmIdentifier((DERObjectIdentifier)object);
        }
        if (object instanceof String) {
            return new AlgorithmIdentifier((String)object);
        }
        if (object instanceof ASN1Sequence) {
            return new AlgorithmIdentifier((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public AlgorithmIdentifier(DERObjectIdentifier dERObjectIdentifier) {
        this.ic = dERObjectIdentifier;
    }

    public AlgorithmIdentifier(String string) {
        this.ic = new DERObjectIdentifier(string);
    }

    public AlgorithmIdentifier(DERObjectIdentifier dERObjectIdentifier, DEREncodable dEREncodable) {
        this.jc = true;
        this.ic = dERObjectIdentifier;
        this.kc = dEREncodable;
    }

    public AlgorithmIdentifier(ASN1Sequence aSN1Sequence) {
        this.ic = (DERObjectIdentifier)aSN1Sequence.getObjectAt(0);
        if (aSN1Sequence.size() == 2) {
            this.jc = true;
            this.kc = aSN1Sequence.getObjectAt(1);
        } else {
            this.kc = null;
        }
    }

    public DERObjectIdentifier getObjectId() {
        return this.ic;
    }

    public DEREncodable getParameters() {
        return this.kc;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.ic);
        if (this.jc) {
            aSN1EncodableVector.add(this.kc);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

