/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.engines;

import com.maverick.crypto.engines.DESEngine;
import java.io.IOException;

public class DESedeEngine
extends DESEngine {
    protected static final int BLOCK_SIZE = 8;
    private int[] ib = null;
    private int[] gb = null;
    private int[] fb = null;
    private boolean hb;

    public void init(boolean bl, byte[] byArray) {
        byte[] byArray2 = byArray;
        byte[] byArray3 = new byte[8];
        byte[] byArray4 = new byte[8];
        byte[] byArray5 = new byte[8];
        this.hb = bl;
        if (byArray2.length == 24) {
            System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
            System.arraycopy(byArray2, 8, byArray4, 0, byArray4.length);
            System.arraycopy(byArray2, 16, byArray5, 0, byArray5.length);
            this.ib = this.generateWorkingKey(bl, byArray3);
            this.gb = this.generateWorkingKey(!bl, byArray4);
            this.fb = this.generateWorkingKey(bl, byArray5);
        } else {
            System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
            System.arraycopy(byArray2, 8, byArray4, 0, byArray4.length);
            this.ib = this.generateWorkingKey(bl, byArray3);
            this.gb = this.generateWorkingKey(!bl, byArray4);
            this.fb = this.ib;
        }
    }

    public String getAlgorithmName() {
        return "DESede";
    }

    public int getBlockSize() {
        return 8;
    }

    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws IOException {
        if (this.ib == null) {
            throw new IllegalStateException("DESede engine not initialised");
        }
        if (n + 8 > byArray.length) {
            throw new IOException("input buffer too short");
        }
        if (n2 + 8 > byArray2.length) {
            throw new IOException("output buffer too short");
        }
        if (this.hb) {
            this.desFunc(this.ib, byArray, n, byArray2, n2);
            this.desFunc(this.gb, byArray2, n2, byArray2, n2);
            this.desFunc(this.fb, byArray2, n2, byArray2, n2);
        } else {
            this.desFunc(this.fb, byArray, n, byArray2, n2);
            this.desFunc(this.gb, byArray2, n2, byArray2, n2);
            this.desFunc(this.ib, byArray2, n2, byArray2, n2);
        }
        return 8;
    }

    public void reset() {
    }
}

