/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.publickey;

import com.maverick.crypto.publickey.RsaPrivateCrtKey;
import com.maverick.crypto.security.SecureRandom;
import java.math.BigInteger;

public final class Rsa {
    private static BigInteger b = BigInteger.valueOf(1L);

    public static BigInteger doPrivateCrt(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5) {
        return Rsa.doPrivateCrt(bigInteger, bigInteger3, bigInteger4, Rsa.getPrimeExponent(bigInteger2, bigInteger3), Rsa.getPrimeExponent(bigInteger2, bigInteger4), bigInteger5);
    }

    public static BigInteger doPrivateCrt(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6) {
        BigInteger bigInteger7;
        if (!bigInteger6.equals(bigInteger3.modInverse(bigInteger2))) {
            bigInteger7 = bigInteger2;
            bigInteger2 = bigInteger3;
            bigInteger3 = bigInteger7;
            bigInteger7 = bigInteger4;
            bigInteger4 = bigInteger5;
            bigInteger5 = bigInteger7;
        }
        bigInteger7 = bigInteger.modPow(bigInteger4, bigInteger2);
        BigInteger bigInteger8 = bigInteger.modPow(bigInteger5, bigInteger3);
        BigInteger bigInteger9 = bigInteger6.multiply(bigInteger7.subtract(bigInteger8)).mod(bigInteger2);
        return bigInteger8.add(bigInteger9.multiply(bigInteger3));
    }

    public static BigInteger getPrimeExponent(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = bigInteger2.subtract(b);
        return bigInteger.mod(bigInteger3);
    }

    public static BigInteger padPKCS1(BigInteger bigInteger, int n, int n2) throws IllegalStateException {
        int n3 = (bigInteger.bitLength() + 7) / 8;
        if (n3 > n2 - 11) {
            throw new IllegalStateException("PKCS1 failed to pad input! input=" + String.valueOf(n3) + " padding=" + String.valueOf(n2));
        }
        byte[] byArray = new byte[n2 - n3 - 3 + 1];
        byArray[0] = 0;
        for (int k = 1; k < n2 - n3 - 3 + 1; ++k) {
            if (n == 1) {
                byArray[k] = -1;
                continue;
            }
            byte[] byArray2 = new byte[1];
            do {
                SecureRandom.getInstance().nextBytes(byArray2);
            } while (byArray2[0] == 0);
            byArray[k] = byArray2[0];
        }
        BigInteger bigInteger2 = new BigInteger(1, byArray);
        bigInteger2 = bigInteger2.shiftLeft((n3 + 1) * 8);
        BigInteger bigInteger3 = BigInteger.valueOf(n);
        bigInteger3 = bigInteger3.shiftLeft((n2 - 2) * 8);
        bigInteger3 = bigInteger3.or(bigInteger2);
        bigInteger3 = bigInteger3.or(bigInteger);
        return bigInteger3;
    }

    public static BigInteger removePKCS1(BigInteger bigInteger, int n) throws IllegalStateException {
        int n2;
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] != n) {
            throw new IllegalStateException("PKCS1 padding type " + n + " is not valid");
        }
        for (n2 = 1; n2 < byArray.length && byArray[n2] != 0; ++n2) {
            if (n != 1 || byArray[n2] == -1) continue;
            throw new IllegalStateException("Corrupt data found in expected PKSC1 padding");
        }
        if (n2 == byArray.length) {
            throw new IllegalStateException("Corrupt data found in expected PKSC1 padding");
        }
        byte[] byArray2 = new byte[byArray.length - n2];
        System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
        return new BigInteger(1, byArray2);
    }

    public static RsaPrivateCrtKey generateKey(int n, SecureRandom secureRandom) {
        return Rsa.generateKey(n, BigInteger.valueOf(65537L), secureRandom);
    }

    public static RsaPrivateCrtKey generateKey(int n, BigInteger bigInteger, SecureRandom secureRandom) {
        BigInteger bigInteger2 = null;
        BigInteger bigInteger3 = null;
        BigInteger bigInteger4 = null;
        BigInteger bigInteger5 = null;
        BigInteger bigInteger6 = null;
        BigInteger bigInteger7 = null;
        BigInteger bigInteger8 = null;
        boolean bl = false;
        BigInteger bigInteger9 = BigInteger.valueOf(1L);
        int n2 = (n + 1) / 2;
        int n3 = n - n2;
        while (!bl) {
            bigInteger2 = new BigInteger(n2, 80, secureRandom);
            bigInteger3 = new BigInteger(n3, 80, secureRandom);
            if (bigInteger2.compareTo(bigInteger3) == 0) continue;
            if (bigInteger2.compareTo(bigInteger3) < 0) {
                bigInteger4 = bigInteger3;
                bigInteger3 = bigInteger2;
                bigInteger2 = bigInteger4;
            }
            if (!bigInteger2.isProbablePrime(25) || !bigInteger3.isProbablePrime(25) || (bigInteger4 = bigInteger2.gcd(bigInteger3)).compareTo(bigInteger9) != 0 || (bigInteger8 = bigInteger2.multiply(bigInteger3)).bitLength() != n) continue;
            bigInteger5 = bigInteger2.subtract(bigInteger9).multiply(bigInteger3.subtract(bigInteger9));
            bigInteger6 = bigInteger.modInverse(bigInteger5);
            bigInteger7 = bigInteger3.modInverse(bigInteger2);
            bl = true;
        }
        return new RsaPrivateCrtKey(bigInteger8, bigInteger, bigInteger6, bigInteger2, bigInteger3, Rsa.getPrimeExponent(bigInteger6, bigInteger2), Rsa.getPrimeExponent(bigInteger6, bigInteger3), bigInteger7);
    }

    public static BigInteger doPublic(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return bigInteger.modPow(bigInteger3, bigInteger2);
    }

    public static BigInteger doPrivate(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return Rsa.doPublic(bigInteger, bigInteger2, bigInteger3);
    }
}

