/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.sftp;

import com.maverick.sftp.SftpFile;
import com.maverick.sftp.SftpStatusException;
import com.maverick.sftp.SftpSubsystemChannel;
import com.maverick.ssh.SshException;
import com.maverick.ssh.SshIOException;
import com.maverick.util.UnsignedInteger32;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public class SftpFileOutputStream
extends OutputStream {
    SftpFile e;
    SftpSubsystemChannel d;
    long c;
    Vector b = new Vector();

    public SftpFileOutputStream(SftpFile sftpFile) throws SftpStatusException, SshException {
        if (sftpFile.getHandle() == null) {
            throw new SftpStatusException(100, "The file does not have a valid handle!");
        }
        if (sftpFile.getSFTPChannel() == null) {
            throw new SshException("The file is not attached to an SFTP subsystem!", 4);
        }
        this.e = sftpFile;
        this.d = sftpFile.getSFTPChannel();
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            while (n2 > 0) {
                int n3 = Math.min(32768, n2);
                this.b.addElement(this.d.postWriteRequest(this.e.getHandle(), this.c, byArray, n, n3));
                this.b(100);
                n += n3;
                n2 -= n3;
                this.c += (long)n3;
            }
        }
        catch (SshException sshException) {
            throw new SshIOException(sshException);
        }
        catch (SftpStatusException sftpStatusException) {
            throw new IOException(sftpStatusException.getMessage());
        }
    }

    public void write(int n) throws IOException {
        try {
            byte[] byArray = new byte[]{(byte)n};
            this.b.addElement(this.d.postWriteRequest(this.e.getHandle(), this.c, byArray, 0, 1));
            this.b(100);
            ++this.c;
        }
        catch (SshException sshException) {
            throw new SshIOException(sshException);
        }
        catch (SftpStatusException sftpStatusException) {
            throw new IOException(sftpStatusException.getMessage());
        }
    }

    private boolean b(int n) throws SftpStatusException, SshException {
        if (this.b.size() > n) {
            UnsignedInteger32 unsignedInteger32 = (UnsignedInteger32)this.b.elementAt(0);
            this.d.getOKRequestStatus(unsignedInteger32);
            this.b.removeElementAt(0);
        }
        return this.b.size() > 0;
    }

    public void close() throws IOException {
        try {
            while (this.b(0)) {
            }
            this.e.close();
        }
        catch (SshException sshException) {
            throw new SshIOException(sshException);
        }
        catch (SftpStatusException sftpStatusException) {
            throw new IOException(sftpStatusException.getMessage());
        }
    }

    protected void finalize() throws IOException {
        if (this.e.getHandle() != null) {
            this.close();
        }
    }
}

